/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block.entities.storage;

import com.google.common.collect.Maps;
import com.google.common.math.LongMath;
import com.mojang.datafixers.util.Pair;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import mod.chiselsandbits.api.block.storage.IStateEntryStorage;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.config.IServerConfiguration;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.block.entities.storage.SimpleStateEntryPalette;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.utils.ByteArrayUtils;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2826;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SimpleStateEntryStorage
implements IStateEntryStorage {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int size;
    private final SimpleStateEntryPalette palette;
    private BitSet data = new BitSet();
    private int entryWidth = 0;
    private boolean isDeserializing = false;
    private List<IBatchMutation> ongoingBatchMutations = new ArrayList<IBatchMutation>();

    public SimpleStateEntryStorage() {
        this(IServerConfiguration.getInstance().getBitSize().get().getBitsPerBlockSide());
    }

    private SimpleStateEntryStorage(SimpleStateEntryStorage stateEntryStorage) {
        this.size = stateEntryStorage.size;
        this.palette = new SimpleStateEntryPalette(this::onPaletteResize, this::onPaletteIndexChanged, stateEntryStorage.palette);
        this.data = stateEntryStorage.data;
        this.entryWidth = stateEntryStorage.entryWidth;
    }

    public SimpleStateEntryStorage(int size) {
        this.size = size;
        this.palette = new SimpleStateEntryPalette(this::onPaletteResize, this::onPaletteIndexChanged);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private int getTotalEntryCount() {
        return this.size * this.size * this.size;
    }

    @Override
    public void clear() {
        this.data = new BitSet();
        this.entryWidth = 0;
        this.palette.clear();
    }

    private void resetData() {
        this.data = new BitSet();
    }

    @Override
    public void initializeWith(IBlockInformation currentState) {
        this.clear();
        if (currentState.getBlockState() == class_2246.field_10124.method_9564()) {
            return;
        }
        int blockStateId = this.palette.getIndex(currentState);
        this.data = ByteArrayUtils.fill(blockStateId, this.entryWidth, this.getTotalEntryCount());
    }

    @Override
    public void loadFromChunkSection(class_2826 chunkSection) {
        if (this.size != StateEntrySize.ONE_SIXTEENTH.getBitsPerBlockSide()) {
            throw new IllegalStateException("Updating to the new storage format is only possible on the default 1/16th size.");
        }
        this.clear();
        try (IBatchMutation ignored = this.batch();){
            BlockPosStreamProvider.getForRange(StateEntrySize.ONE_SIXTEENTH.getBitsPerBlockSide()).forEach(position -> this.setBlockInformation(position.method_10263(), position.method_10264(), position.method_10260(), new BlockInformation(chunkSection.method_12254(position.method_10263(), position.method_10264(), position.method_10260()), Optional.empty())));
        }
    }

    @Override
    public IBlockInformation getBlockInformation(int x, int y, int z) {
        int offSetIndex = this.doCalculatePositionIndex(x, y, z);
        int blockStateId = ByteArrayUtils.getValueAt(this.data, this.entryWidth, offSetIndex);
        return this.palette.getBlockState(blockStateId);
    }

    @Override
    public void setBlockInformation(int x, int y, int z, IBlockInformation blockState) {
        int offSetIndex = this.doCalculatePositionIndex(x, y, z);
        int blockStateId = this.palette.getIndex(blockState);
        this.ensureCapacity();
        ByteArrayUtils.setValueAt(this.data, blockStateId, this.entryWidth, offSetIndex);
    }

    private void ensureCapacity() {
        int requiredSize = (int)Math.ceil((float)(this.getTotalEntryCount() * this.entryWidth) / 8.0f);
        if (this.data.length() < requiredSize) {
            byte[] rawData = this.getRawData();
            byte[] newData = new byte[requiredSize];
            System.arraycopy(rawData, 0, newData, 0, rawData.length);
            this.data = BitSet.valueOf(newData);
        } else if (this.ongoingBatchMutations.isEmpty()) {
            this.data = BitSet.valueOf(this.getRawData());
        }
    }

    private int doCalculatePositionIndex(int x, int y, int z) {
        return x * this.size * this.size + y * this.size + z;
    }

    private class_2382 doCalculatePosition(int index) {
        int x = index / (this.size * this.size);
        int y = (index - x * this.size * this.size) / this.size;
        int z = index - x * this.size * this.size - y * this.size;
        return new class_2382(x, y, z);
    }

    @Override
    public void count(BiConsumer<IBlockInformation, Integer> storageConsumer) {
        HashMap countMap = Maps.newHashMap();
        BlockPosStreamProvider.getForRange(this.getSize()).map(position -> this.getBlockInformation(position.method_10263(), position.method_10264(), position.method_10260())).forEach(blockState -> countMap.compute(blockState, (state, count) -> count == null ? 1 : count + 1));
        countMap.forEach(storageConsumer);
    }

    public BitSet getData() {
        return this.data;
    }

    @Override
    public byte[] getRawData() {
        return this.data.toByteArray();
    }

    @Override
    public IStateEntryStorage createSnapshot() {
        return new SimpleStateEntryStorage(this);
    }

    @Override
    public void fillFromBottom(IBlockInformation state, int entries) {
        this.clear();
        int loopCount = Math.max(0, Math.min(entries, StateEntrySize.current().getBitsPerBlock()));
        if (loopCount == 0) {
            return;
        }
        int count = 0;
        try (IBatchMutation ignored = this.batch();){
            for (int y = 0; y < this.getSize(); ++y) {
                for (int x = 0; x < this.getSize(); ++x) {
                    for (int z = 0; z < this.getSize(); ++z) {
                        this.setBlockInformation(x, y, z, state);
                        if (++count != loopCount) continue;
                        return;
                    }
                }
            }
        }
    }

    @Override
    public List<IBlockInformation> getContainedPalette() {
        return this.palette.getStates();
    }

    @Override
    public void rotate(class_2350.class_2351 axis, int rotationCount) {
        if (rotationCount == 0) {
            return;
        }
        IStateEntryStorage clone = this.createSnapshot();
        this.resetData();
        class_243 centerVector = new class_243(7.5, 7.5, 7.5);
        try (IBatchMutation ignored = this.batch();){
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        class_243 workingVector = new class_243((double)x, (double)y, (double)z);
                        class_243 rotatedVector = workingVector.method_1020(centerVector);
                        for (int i = 0; i < rotationCount; ++i) {
                            rotatedVector = VectorUtils.rotate90Degrees(rotatedVector, axis);
                        }
                        class_2338 sourcePos = new class_2338(workingVector);
                        class_243 offsetPos = rotatedVector.method_1019(centerVector).method_18805(1000.0, 1000.0, 1000.0);
                        class_2338 targetPos = new class_2338(new class_243((double)Math.round(offsetPos.method_10216()), (double)Math.round(offsetPos.method_10214()), (double)Math.round(offsetPos.method_10215())).method_18805(0.001, 0.001, 0.001));
                        this.setBlockInformation(targetPos.method_10263(), targetPos.method_10264(), targetPos.method_10260(), clone.getBlockInformation(sourcePos.method_10263(), sourcePos.method_10264(), sourcePos.method_10260()));
                    }
                }
            }
        }
    }

    @Override
    public void mirror(class_2350.class_2351 axis) {
        IStateEntryStorage clone = this.createSnapshot();
        this.resetData();
        try (IBatchMutation ignored = this.batch();){
            for (int y = 0; y < this.getSize(); ++y) {
                for (int x = 0; x < this.getSize(); ++x) {
                    for (int z = 0; z < this.getSize(); ++z) {
                        IBlockInformation blockInformation = clone.getBlockInformation(x, y, z);
                        int mirroredX = axis == class_2350.class_2351.field_11048 ? this.getSize() - x - 1 : x;
                        int mirroredY = axis == class_2350.class_2351.field_11052 ? this.getSize() - y - 1 : y;
                        int mirroredZ = axis == class_2350.class_2351.field_11051 ? this.getSize() - z - 1 : z;
                        this.setBlockInformation(mirroredX, mirroredY, mirroredZ, blockInformation);
                    }
                }
            }
        }
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 result = new class_2487();
        result.method_10566("palette", (class_2520)this.palette.serializeNBT());
        result.method_10570("data", this.getRawData());
        return result;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.clear();
        this.isDeserializing = true;
        if (!nbt.method_10545("palette") || !nbt.method_10545("data")) {
            LOGGER.error("The given NBT tag does not contain the required data for deserialization of a simple state entry storage. NBT: %s".formatted(nbt));
            this.isDeserializing = false;
            return;
        }
        this.palette.deserializeNBT((class_2499)Objects.requireNonNull(nbt.method_10580("palette")));
        this.data = BitSet.valueOf(nbt.method_10547("data"));
        HashSet<IBlockInformation> containedStates = new HashSet<IBlockInformation>();
        for (int i = 0; i < this.getTotalEntryCount(); ++i) {
            class_2382 pos = this.doCalculatePosition(i);
            IBlockInformation blockState = this.getBlockInformation(pos);
            containedStates.add(blockState);
        }
        ArrayList<IBlockInformation> paletteStates = new ArrayList<IBlockInformation>(this.palette.getStates());
        paletteStates.removeAll(containedStates);
        paletteStates.remove(BlockInformation.AIR);
        this.isDeserializing = false;
        this.palette.sanitize(paletteStates);
    }

    @Override
    public void serializeInto(@NotNull class_2540 packetBuffer) {
        this.palette.serializeInto(packetBuffer);
        packetBuffer.method_10813(this.data.toByteArray());
    }

    @Override
    public void deserializeFrom(@NotNull class_2540 packetBuffer) {
        this.clear();
        this.isDeserializing = true;
        this.palette.deserializeFrom(packetBuffer);
        this.data = BitSet.valueOf(packetBuffer.method_10795());
        this.isDeserializing = false;
    }

    private void onPaletteResize(int newSize) {
        int currentEntryWidth = this.entryWidth;
        this.entryWidth = LongMath.log2((long)newSize, (RoundingMode)RoundingMode.CEILING);
        if (!this.isDeserializing && this.entryWidth != currentEntryWidth) {
            BitSet rawData = this.data;
            this.data = new BitSet(this.getTotalEntryCount() * this.entryWidth);
            BlockPosStreamProvider.getForRange(this.getSize()).mapToInt(pos -> this.doCalculatePositionIndex(pos.method_10263(), pos.method_10264(), pos.method_10260())).mapToObj(index -> Pair.of((Object)index, (Object)ByteArrayUtils.getValueAt(rawData, currentEntryWidth, index))).forEach(pair -> ByteArrayUtils.setValueAt(this.data, (Integer)pair.getSecond(), this.entryWidth, (Integer)pair.getFirst()));
        }
    }

    private void onPaletteIndexChanged(Map<Integer, Integer> remaps) {
        if (remaps.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.getTotalEntryCount(); ++i) {
            int currentId = ByteArrayUtils.getValueAt(this.data, this.entryWidth, i);
            if (!remaps.containsKey(currentId)) continue;
            ByteArrayUtils.setValueAt(this.data, remaps.get(currentId), this.entryWidth, i);
        }
    }

    @Override
    public IBatchMutation batch() {
        IBatchMutation mutation = new IBatchMutation(){

            @Override
            public void close() {
                SimpleStateEntryStorage.this.ongoingBatchMutations.remove(this);
            }
        };
        this.ongoingBatchMutations.add(mutation);
        this.data = BitSet.valueOf(this.data.toLongArray());
        return mutation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleStateEntryStorage)) {
            return false;
        }
        SimpleStateEntryStorage that = (SimpleStateEntryStorage)o;
        if (this.entryWidth != that.entryWidth) {
            return false;
        }
        if (!this.palette.equals(that.palette)) {
            return false;
        }
        return this.getData().equals(that.getData());
    }

    public int hashCode() {
        int result = this.palette.hashCode();
        result = 31 * result + this.getData().hashCode();
        result = 31 * result + this.entryWidth;
        return result;
    }

    public String toString() {
        return "SimpleStateEntryStorage{palette=" + this.palette + ", data=" + this.data + ", entryWidth=" + this.entryWidth + "}";
    }
}

