/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.blockinformation;

import com.mojang.serialization.DataResult;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.util.BlockStateSerializationUtils;
import mod.chiselsandbits.api.util.ComparatorUtils;
import mod.chiselsandbits.api.variant.state.IStateVariant;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.stateinfo.additional.StateVariantManager;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public final class BlockInformation
implements IBlockInformation {
    private static final Comparator<class_2680> STATE_COMPARATOR = Comparator.comparing(IBlockStateIdManager.getInstance()::getIdFrom);
    private static final Comparator<IStateVariant> VARIANT_COMPARATOR = Comparator.comparing(variant -> variant.getClass().getName()).thenComparing(Comparator.naturalOrder());
    private static final Comparator<Optional<IStateVariant>> OPTIONAL_VARIANT_COMPARATOR = ComparatorUtils.createOptionalComparator(VARIANT_COMPARATOR);
    private static final Comparator<BlockInformation> COMPARATOR = Comparator.comparing(BlockInformation::getBlockState, STATE_COMPARATOR).thenComparing(BlockInformation::getVariant, OPTIONAL_VARIANT_COMPARATOR);
    private class_2680 blockState;
    private Optional<IStateVariant> variant;

    public BlockInformation(class_2487 tag) {
        this.deserializeNBT(tag);
    }

    public BlockInformation(class_2540 packetBuffer) {
        this.deserializeFrom(packetBuffer);
    }

    public BlockInformation(class_2680 blockState, Optional<IStateVariant> variant) {
        this.blockState = blockState;
        this.variant = variant;
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        tag.method_10582("state", BlockStateSerializationUtils.serialize(this.getBlockState()));
        this.variant.ifPresent(info -> tag.method_10566("variant", (class_2520)IStateVariantManager.getInstance().serializeNBT((IStateVariant)info)));
        return tag;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        DataResult<class_2680> dataResult = BlockStateSerializationUtils.deserialize(nbt.method_10558("state"));
        this.blockState = dataResult.result().orElseGet(() -> ((class_2248)class_2246.field_10124).method_9564());
        this.variant = Optional.empty();
        if (nbt.method_10545("variant")) {
            this.variant = Optional.of(IStateVariantManager.getInstance().deserializeNBT(nbt.method_10562("variant")));
        }
    }

    @Override
    public void serializeInto(@NotNull class_2540 packetBuffer) {
        BlockStateSerializationUtils.serialize(packetBuffer, this.getBlockState());
        packetBuffer.writeBoolean(this.variant.isPresent());
        this.variant.ifPresent(info -> IStateVariantManager.getInstance().serializeInto(packetBuffer, (IStateVariant)info));
    }

    @Override
    public void deserializeFrom(@NotNull class_2540 packetBuffer) {
        this.blockState = BlockStateSerializationUtils.deserialize(packetBuffer);
        this.variant = Optional.empty();
        if (packetBuffer.readBoolean()) {
            this.variant = Optional.of(IStateVariantManager.getInstance().deserializeFrom(packetBuffer));
        }
    }

    @Override
    public class_2680 getBlockState() {
        return this.blockState;
    }

    @Override
    public Optional<IStateVariant> getVariant() {
        return StateVariantManager.getInstance().unwrapVariant(this.variant);
    }

    @Override
    public boolean isFluid() {
        return this.getBlockState().method_26227().method_15771();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BlockInformation that = (BlockInformation)obj;
        return Objects.equals(this.blockState, that.blockState) && Objects.equals(this.variant, that.variant);
    }

    public int hashCode() {
        return Objects.hash(this.blockState, this.variant);
    }

    public String toString() {
        return "BlockInformation[blockState=" + this.blockState + ", variant=" + this.variant + "]";
    }

    @Override
    public boolean isAir() {
        return this.getBlockState().method_26215();
    }

    @Override
    public BlockInformation createSnapshot() {
        return this.variant.map(stateVariant -> new BlockInformation(this.blockState, Optional.ofNullable((IStateVariant)stateVariant.createSnapshot()))).orElseGet(() -> new BlockInformation(this.blockState, Optional.empty()));
    }

    @Override
    public int compareTo(@NotNull IBlockInformation o) {
        if (!(o instanceof BlockInformation)) {
            return -1;
        }
        BlockInformation blockInformation = (BlockInformation)o;
        return COMPARATOR.compare(this, blockInformation);
    }
}

