/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.eligibility;

import com.communi.suggestu.saecularia.caudices.core.block.IBlockWithWorldlyProperties;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityOptions;
import mod.chiselsandbits.api.config.IServerConfiguration;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.registrars.ModBlocks;
import mod.chiselsandbits.utils.ClassUtils;
import mod.chiselsandbits.utils.ReflectionHelperBlock;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4970;

public class BlockEligibilityAnalysisData {
    private final boolean isCompatible;
    private final float hardness;
    private final float explosionResistance;

    private BlockEligibilityAnalysisData(boolean isCompatible, float hardness, float explosionResistance) {
        this.isCompatible = isCompatible;
        this.hardness = hardness;
        this.explosionResistance = explosionResistance;
    }

    public boolean isCompatible() {
        return this.isCompatible;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getExplosionResistance() {
        return this.explosionResistance;
    }

    public static BlockEligibilityAnalysisData createFromState(IBlockInformation state) {
        try {
            boolean isFluid;
            ReflectionHelperBlock reflectBlock = (ReflectionHelperBlock)((Object)ModBlocks.REFLECTION_HELPER_BLOCK.get());
            class_2248 blk = state.getBlockState().method_26204();
            Class<?> blkClass = blk.getClass();
            reflectBlock.method_9594(null, null, null, null);
            Class<?> b_Class = ClassUtils.getDeclaringClass(blkClass, reflectBlock.getLastInvokedThreadLocalMethodName(), class_2680.class, class_1657.class, class_1922.class, class_2338.class);
            boolean test_b = b_Class == class_2248.class || b_Class == class_4970.class;
            reflectBlock.method_9520();
            Class<?> exploResistanceClz = ClassUtils.getDeclaringClass(blkClass, reflectBlock.getLastInvokedThreadLocalMethodName(), new Class[0]);
            boolean test_c = exploResistanceClz == class_2248.class || exploResistanceClz == class_4970.class;
            reflectBlock.getExplosionResistance(null, null, null, null);
            exploResistanceClz = ClassUtils.getDeclaringClass(blkClass, reflectBlock.getLastInvokedThreadLocalMethodName(), class_2680.class, class_1922.class, class_2338.class, class_1927.class);
            boolean test_d = exploResistanceClz == class_2248.class || exploResistanceClz == class_4970.class || exploResistanceClz == null || IEligibilityOptions.getInstance().isValidExplosionDefinitionClass(exploResistanceClz);
            boolean bl = isFluid = !state.getBlockState().method_26227().method_15769();
            if (test_b && test_c && test_d && !isFluid) {
                float blockHardness = state.getBlockState().method_26214((class_1922)new SingleBlockBlockReader(state, state.getBlockState().method_26204()), class_2338.field_10980);
                float resistance = blk.method_9520();
                if (blk instanceof IBlockWithWorldlyProperties) {
                    IBlockWithWorldlyProperties blockWithWorldlyProperties = (IBlockWithWorldlyProperties)blk;
                    resistance = blockWithWorldlyProperties.getExplosionResistance(state.getBlockState(), (class_1922)new SingleBlockBlockReader(state, state.getBlockState().method_26204()), class_2338.field_10980, new class_1927(null, null, null, null, 0.0, 1.0, 0.0, 10.0f, false, class_1927.class_4179.field_18685));
                }
                return new BlockEligibilityAnalysisData(true, blockHardness, resistance);
            }
            if (test_b && test_c && test_d && isFluid) {
                return new BlockEligibilityAnalysisData(true, 2.0f, 6.0f);
            }
            return new BlockEligibilityAnalysisData(IServerConfiguration.getInstance().getCompatabilityMode().get(), 2.0f, 6.0f);
        }
        catch (Exception err) {
            return new BlockEligibilityAnalysisData(false, -1.0f, -1.0f);
        }
    }
}

