/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.util;

import java.util.Collection;
import java.util.List;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.client.model.baked.face.FaceManager;
import mod.chiselsandbits.client.model.baked.face.model.BakedQuadAdapter;
import mod.chiselsandbits.client.model.baked.face.model.ModelQuadLayer;
import mod.chiselsandbits.client.model.baked.face.model.VertexData;
import mod.chiselsandbits.client.util.VertexDataUtils;
import mod.chiselsandbits.utils.LightUtil;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_777;
import org.jetbrains.annotations.NotNull;

public final class QuadGenerationUtils {
    private QuadGenerationUtils() {
        throw new IllegalStateException("Tried to instantiate: 'QuadGenerationUtils', but this is a utility class.");
    }

    public static void generateQuads(List<class_777> target, long primaryStateRenderSeed, @NotNull class_1921 renderType, IBlockInformation blockInformation, class_2350 cullDirection, class_1160 from, class_1160 to) {
        Collection<ModelQuadLayer> quadLayers = FaceManager.getInstance().getCachedLayersFor(blockInformation, cullDirection, renderType, primaryStateRenderSeed, renderType);
        if (quadLayers != null) {
            for (ModelQuadLayer layer : quadLayers) {
                Collection<VertexData> adaptedVertices = VertexDataUtils.adaptVertices(layer.vertexData(), cullDirection, from, to);
                BakedQuadAdapter adapter = new BakedQuadAdapter(adaptedVertices, layer.color());
                LightUtil.put(adapter, layer.sourceQuad());
                adapter.setQuadTint(layer.tint());
                adapter.setApplyDiffuseLighting(layer.shade());
                adapter.setTexture(layer.sprite());
                adapter.setQuadOrientation(cullDirection);
                class_777 quad = adapter.build();
                target.add(quad);
            }
        }
    }
}

