/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item.multistate;

import com.communi.suggestu.scena.core.registries.deferred.IRegistryObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mod.chiselsandbits.api.block.storage.IStateEntryStorage;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.item.multistate.IStatistics;
import mod.chiselsandbits.api.item.pattern.IPatternItem;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.identifier.IArrayBackedAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.callback.StateClearer;
import mod.chiselsandbits.api.multistate.mutator.callback.StateSetter;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.BlockPosForEach;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.block.entities.storage.SimpleStateEntryStorage;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.item.ChiseledBlockItem;
import mod.chiselsandbits.materials.MaterialManager;
import mod.chiselsandbits.registrars.ModItems;
import mod.chiselsandbits.storage.IStorageEngine;
import mod.chiselsandbits.storage.IStorageHandler;
import mod.chiselsandbits.storage.StorageEngineBuilder;
import mod.chiselsandbits.utils.LZ4DataCompressionUtils;
import mod.chiselsandbits.utils.MultiStateSnapshotUtils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3614;
import org.jetbrains.annotations.NotNull;

public class SingleBlockMultiStateItemStack
implements IMultiStateItemStack {
    private final class_1799 sourceStack;
    private IStateEntryStorage compressedSection;
    private Statistics statistics = new Statistics();
    private final IStorageEngine storageEngine = this.buildStorageEngine();

    public SingleBlockMultiStateItemStack(class_1799 sourceStack) {
        this.sourceStack = sourceStack;
        this.compressedSection = new SimpleStateEntryStorage();
        this.deserializeNBT(sourceStack.method_7911("chiseledData"));
        this.sourceStack.method_7948().method_10566("chiseledData", (class_2520)this.serializeNBT());
    }

    public SingleBlockMultiStateItemStack(class_1792 item, IStateEntryStorage compressedSection) {
        if (!(item instanceof IMultiStateItem)) {
            throw new IllegalArgumentException("The given item is not a MultiState Item");
        }
        this.sourceStack = new class_1799((class_1935)item);
        this.compressedSection = compressedSection;
        this.statistics.initializeFrom(this.compressedSection);
        this.sourceStack.method_7948().method_10566("chiseledData", (class_2520)this.serializeNBT());
    }

    public SingleBlockMultiStateItemStack(class_1792 item, class_2487 nbt) {
        if (!(item instanceof IMultiStateItem)) {
            throw new IllegalArgumentException("The given item is not a MultiState Item");
        }
        this.sourceStack = new class_1799((class_1935)item);
        this.compressedSection = new SimpleStateEntryStorage();
        this.statistics.initializeFrom(this.compressedSection);
        this.deserializeNBT(nbt);
        this.sourceStack.method_7948().method_10566("chiseledData", (class_2520)this.serializeNBT());
    }

    private IStorageEngine buildStorageEngine() {
        return StorageEngineBuilder.create().with(new LZ4StorageBasedStorageHandler()).build();
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        return new ShapeIdentifier(this.compressedSection);
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.compressedSection.getBlockInformation(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), (class_2382)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(class_243 inAreaTarget) {
        if (inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0 || inAreaTarget.method_10216() >= 1.0 || inAreaTarget.method_10214() >= 1.0 || inAreaTarget.method_10215() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        class_2338 inAreaPos = new class_2338(inAreaTarget.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        IBlockInformation currentState = this.compressedSection.getBlockInformation(inAreaPos.method_10263(), inAreaPos.method_10264(), inAreaPos.method_10260());
        return currentState.isAir() ? Optional.empty() : Optional.of(new StateEntry(currentState, (class_2382)inAreaPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)class_2338.field_10980)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        return this.getInAreaTarget(inBlockTarget);
    }

    @Override
    public boolean isInside(class_243 inAreaTarget) {
        return !(inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0 || inAreaTarget.method_10216() >= 1.0 || inAreaTarget.method_10214() >= 1.0 || inAreaTarget.method_10215() >= 1.0);
    }

    @Override
    public boolean isInside(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)class_2338.field_10980)) {
            return false;
        }
        return this.isInside(inBlockTarget);
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        return MultiStateSnapshotUtils.createFromStorage(this.compressedSection);
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.compressedSection.getBlockInformation(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), (class_2382)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public void setInAreaTarget(IBlockInformation blockInformation, class_243 inAreaTarget) throws SpaceOccupiedException {
        if (inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0 || inAreaTarget.method_10216() >= 1.0 || inAreaTarget.method_10214() >= 1.0 || inAreaTarget.method_10215() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        class_2338 inAreaPos = new class_2338(inAreaTarget.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        IBlockInformation currentState = this.compressedSection.getBlockInformation(inAreaPos.method_10263(), inAreaPos.method_10264(), inAreaPos.method_10260());
        if (!currentState.isAir()) {
            throw new SpaceOccupiedException();
        }
        this.compressedSection.setBlockInformation(inAreaPos.method_10263(), inAreaPos.method_10264(), inAreaPos.method_10260(), blockInformation);
        if (blockInformation.isAir() && !currentState.isAir()) {
            this.statistics.onBlockStateRemoved(currentState);
        } else if (!blockInformation.isAir() && currentState.isAir()) {
            this.statistics.onBlockStateAdded(blockInformation);
        } else if (!blockInformation.isAir() && !currentState.isAir()) {
            this.statistics.onBlockStateReplaced(currentState, blockInformation);
        }
        this.sourceStack.method_7948().method_10566("chiseledData", (class_2520)this.serializeNBT());
    }

    @Override
    public void setInBlockTarget(IBlockInformation blockInformation, class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) throws SpaceOccupiedException {
        if (!inAreaBlockPosOffset.equals((Object)class_2338.field_10980)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.setInAreaTarget(blockInformation, inBlockTarget);
    }

    @Override
    public void clearInAreaTarget(class_243 inAreaTarget) {
        if (inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0 || inAreaTarget.method_10216() >= 1.0 || inAreaTarget.method_10214() >= 1.0 || inAreaTarget.method_10215() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        class_2338 inAreaPos = new class_2338(inAreaTarget.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        IBlockInformation blockState = BlockInformation.AIR;
        IBlockInformation currentState = this.compressedSection.getBlockInformation(inAreaPos.method_10263(), inAreaPos.method_10264(), inAreaPos.method_10260());
        this.compressedSection.setBlockInformation(inAreaPos.method_10263(), inAreaPos.method_10264(), inAreaPos.method_10260(), blockState);
        if (blockState.isAir() && !currentState.isAir()) {
            this.statistics.onBlockStateRemoved(currentState);
        } else if (!blockState.isAir() && currentState.isAir()) {
            this.statistics.onBlockStateAdded(blockState);
        } else if (!blockState.isAir() && !currentState.isAir()) {
            this.statistics.onBlockStateReplaced(currentState, blockState);
        }
        this.sourceStack.method_7948().method_10566("chiseledData", (class_2520)this.serializeNBT());
    }

    @Override
    public void clearInBlockTarget(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)class_2338.field_10980)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.clearInAreaTarget(inBlockTarget);
    }

    @Override
    public void serializeInto(@NotNull class_2540 packetBuffer) {
        this.compressedSection.serializeInto(packetBuffer);
    }

    @Override
    public void deserializeFrom(@NotNull class_2540 packetBuffer) {
        this.compressedSection.deserializeFrom(packetBuffer);
    }

    @Override
    public class_2487 serializeNBT() {
        return (class_2487)this.storageEngine.serializeNBT();
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.storageEngine.deserializeNBT(nbt);
    }

    @Override
    public IStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public class_1799 toBlockStack() {
        if (this.sourceStack.method_7909() instanceof IPatternItem) {
            IBlockInformation primaryState = this.statistics.getPrimaryState();
            class_3614 blockMaterial = primaryState.getBlockState().method_26207();
            class_3614 conversionMaterial = MaterialManager.getInstance().remapMaterialIfNeeded(blockMaterial);
            IRegistryObject<ChiseledBlockItem> convertedItemProvider = ModItems.MATERIAL_TO_ITEM_CONVERSIONS.get(conversionMaterial);
            if (convertedItemProvider == null) {
                convertedItemProvider = ModItems.MATERIAL_TO_ITEM_CONVERSIONS.get(MaterialManager.getInstance().getDefaultMaterial());
            }
            ChiseledBlockItem chiseledBlockItem = (ChiseledBlockItem)convertedItemProvider.get();
            class_1799 blockStack = new class_1799((class_1935)chiseledBlockItem);
            blockStack.method_7980(this.sourceStack.method_7948().method_10553());
            return blockStack;
        }
        return this.sourceStack.method_7972();
    }

    @Override
    public class_1799 toPatternStack() {
        if (this.sourceStack.method_7909() instanceof IPatternItem) {
            return this.sourceStack.method_7972();
        }
        class_1799 singleUsePatternStack = new class_1799((class_1935)ModItems.SINGLE_USE_PATTERN_ITEM.get());
        singleUsePatternStack.method_7980(this.sourceStack.method_7948().method_10553());
        return singleUsePatternStack;
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(positionMutator::mutate).map(blockPos -> new StateEntry(this.compressedSection.getBlockInformation(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), (class_2382)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public void forEachWithPositionMutator(IPositionMutator positionMutator, Consumer<IStateEntryInfo> consumer) {
        BlockPosForEach.forEachInRange(StateEntrySize.current().getBitsPerBlockSide(), blockPos -> {
            class_2382 pos = positionMutator.mutate((class_2382)blockPos);
            consumer.accept(new StateEntry(this.compressedSection.getBlockInformation(pos.method_10263(), pos.method_10264(), pos.method_10260()), pos, this::setInAreaTarget, this::clearInAreaTarget));
        });
    }

    @Override
    public void rotate(class_2350.class_2351 axis, int rotationCount) {
        this.compressedSection.rotate(axis, rotationCount);
        this.statistics.clear();
        BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).forEach(position -> this.statistics.onBlockStateAdded(this.compressedSection.getBlockInformation(position.method_10263(), position.method_10264(), position.method_10260())));
        this.sourceStack.method_7948().method_10566("chiseledData", (class_2520)this.serializeNBT());
    }

    @Override
    public void mirror(class_2350.class_2351 axis) {
        this.compressedSection.mirror(axis);
        this.statistics.clear();
        BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).forEach(position -> this.statistics.onBlockStateAdded(this.compressedSection.getBlockInformation(position.method_10263(), position.method_10264(), position.method_10260())));
        this.sourceStack.method_7948().method_10566("chiseledData", (class_2520)this.serializeNBT());
    }

    public int hashCode() {
        return this.createNewShapeIdentifier().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IAreaAccessor)) {
            return false;
        }
        IAreaAccessor accessor = (IAreaAccessor)obj;
        return this.createNewShapeIdentifier().equals(accessor.createNewShapeIdentifier());
    }

    @Override
    @NotNull
    public class_238 getBoundingBox() {
        return new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    private static final class Statistics
    implements IStatistics {
        private IBlockInformation primaryState = BlockInformation.AIR;
        private final Map<IBlockInformation, Integer> countMap = Maps.newConcurrentMap();

        private Statistics() {
        }

        @Override
        public IBlockInformation getPrimaryState() {
            return this.primaryState;
        }

        @Override
        public boolean isEmpty() {
            return this.countMap.isEmpty() || this.countMap.size() == 1 && this.countMap.containsKey(BlockInformation.AIR);
        }

        @Override
        public Set<IBlockInformation> getContainedStates() {
            return this.countMap.keySet();
        }

        private void clear() {
            this.primaryState = BlockInformation.AIR;
            this.countMap.clear();
        }

        private void onBlockStateAdded(IBlockInformation blockInformation) {
            this.countMap.putIfAbsent(blockInformation, 0);
            this.countMap.computeIfPresent(blockInformation, (state, currentCount) -> currentCount + 1);
            this.updatePrimaryState();
        }

        private void onBlockStateRemoved(IBlockInformation blockInformation) {
            this.countMap.computeIfPresent(blockInformation, (state, currentCount) -> currentCount - 1);
            this.countMap.remove(blockInformation, 0);
            this.updatePrimaryState();
        }

        private void onBlockStateReplaced(IBlockInformation currentInformation, IBlockInformation newInformation) {
            this.countMap.computeIfPresent(currentInformation, (state, currentCount) -> currentCount - 1);
            this.countMap.remove(currentInformation, 0);
            this.countMap.putIfAbsent(newInformation, 0);
            this.countMap.computeIfPresent(newInformation, (state, currentCount) -> currentCount + 1);
            this.updatePrimaryState();
        }

        private void updatePrimaryState() {
            this.primaryState = this.countMap.entrySet().stream().filter(entry -> !((IBlockInformation)entry.getKey()).isAir()).min((o1, o2) -> -1 * ((Integer)o1.getValue() - (Integer)o2.getValue())).map(Map.Entry::getKey).orElse(BlockInformation.AIR);
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 nbt = new class_2487();
            nbt.method_10566("primaryState", this.primaryState.serializeNBT());
            class_2499 blockStateList = new class_2499();
            for (Map.Entry<IBlockInformation, Integer> blockStateIntegerEntry : this.countMap.entrySet()) {
                class_2487 stateNbt = new class_2487();
                stateNbt.method_10566("block_information", blockStateIntegerEntry.getKey().serializeNBT());
                stateNbt.method_10569("count", blockStateIntegerEntry.getValue().intValue());
                blockStateList.add((Object)stateNbt);
            }
            nbt.method_10566("blockStates", (class_2520)blockStateList);
            return nbt;
        }

        @Override
        public void deserializeNBT(class_2487 nbt) {
            this.countMap.clear();
            this.primaryState = new BlockInformation(nbt.method_10562("primaryState"));
            class_2499 blockStateList = nbt.method_10554("blockStates", 10);
            for (int i = 0; i < blockStateList.size(); ++i) {
                class_2487 stateNbt = blockStateList.method_10602(i);
                BlockInformation blockInformation = new BlockInformation(stateNbt.method_10562("block_information"));
                this.countMap.put(blockInformation, stateNbt.method_10550("count"));
            }
        }

        public void initializeFrom(IStateEntryStorage compressedSection) {
            this.clear();
            compressedSection.count(this.countMap::putIfAbsent);
            this.updatePrimaryState();
        }
    }

    private final class LZ4StorageBasedStorageHandler
    implements IStorageHandler<Payload> {
        private LZ4StorageBasedStorageHandler() {
        }

        @Override
        public Payload readPayloadOffThread(class_2487 nbt) {
            return LZ4DataCompressionUtils.decompress(nbt, compoundTag -> {
                SimpleStateEntryStorage storage = new SimpleStateEntryStorage();
                Statistics mutableStatistics = new Statistics();
                storage.deserializeNBT(compoundTag.method_10562("chiseledData"));
                mutableStatistics.deserializeNBT(compoundTag.method_10562("statistics"));
                return new Payload(storage, mutableStatistics);
            });
        }

        @Override
        public void syncPayloadOnGameThread(Payload payload) {
            SingleBlockMultiStateItemStack.this.compressedSection = payload.storage;
            SingleBlockMultiStateItemStack.this.statistics = payload.mutableStatistics;
        }

        @Override
        public class_2487 serializeNBT() {
            return LZ4DataCompressionUtils.compress(compoundTag -> {
                compoundTag.method_10566("chiseledData", SingleBlockMultiStateItemStack.this.compressedSection.serializeNBT());
                compoundTag.method_10566("statistics", (class_2520)SingleBlockMultiStateItemStack.this.statistics.serializeNBT());
            });
        }

        @Override
        public void deserializeNBT(class_2487 nbt) {
            LZ4DataCompressionUtils.decompress(nbt, compoundTag -> {
                SingleBlockMultiStateItemStack.this.compressedSection.deserializeNBT(compoundTag.method_10562("chiseledData"));
                SingleBlockMultiStateItemStack.this.statistics.deserializeNBT(compoundTag.method_10562("statistics"));
            });
        }

        private record Payload(IStateEntryStorage storage, Statistics mutableStatistics) {
        }
    }

    private static final class ShapeIdentifier
    implements IArrayBackedAreaShapeIdentifier {
        private final IStateEntryStorage snapshot;

        private ShapeIdentifier(IStateEntryStorage chunkSection) {
            this.snapshot = chunkSection.createSnapshot();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IArrayBackedAreaShapeIdentifier)) {
                return false;
            }
            IArrayBackedAreaShapeIdentifier that = (IArrayBackedAreaShapeIdentifier)o;
            return Arrays.equals(this.getBackingData(), that.getBackingData()) && this.getPalette().equals(that.getPalette());
        }

        public int hashCode() {
            return this.snapshot.hashCode();
        }

        @Override
        public byte[] getBackingData() {
            return this.snapshot.getRawData();
        }

        @Override
        public List<IBlockInformation> getPalette() {
            return this.snapshot.getContainedPalette();
        }
    }

    private static final class StateEntry
    implements IMutableStateEntryInfo {
        private final IBlockInformation blockInformation;
        private final class_243 startPoint;
        private final class_243 endPoint;
        private final StateSetter stateSetter;
        private final StateClearer stateClearer;

        public StateEntry(IBlockInformation blockInformation, class_2382 startPoint, StateSetter stateSetter, StateClearer stateClearer) {
            this(blockInformation, class_243.method_24954((class_2382)startPoint).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()), class_243.method_24954((class_2382)startPoint).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()).method_1031((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()), stateSetter, stateClearer);
        }

        private StateEntry(IBlockInformation blockInformation, class_243 startPoint, class_243 endPoint, StateSetter stateSetter, StateClearer stateClearer) {
            this.blockInformation = blockInformation;
            this.startPoint = startPoint;
            this.endPoint = endPoint;
            this.stateSetter = stateSetter;
            this.stateClearer = stateClearer;
        }

        @Override
        @NotNull
        public IBlockInformation getBlockInformation() {
            return this.blockInformation;
        }

        @Override
        @NotNull
        public class_243 getStartPoint() {
            return this.startPoint;
        }

        @Override
        @NotNull
        public class_243 getEndPoint() {
            return this.endPoint;
        }

        @Override
        public void setBlockInformation(IBlockInformation blockInformation) throws SpaceOccupiedException {
            this.stateSetter.set(blockInformation, this.getStartPoint());
        }

        @Override
        public void clear() {
            this.stateClearer.accept(this.getStartPoint());
        }
    }
}

