/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.pattern.placement;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.block.IMultiStateBlock;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.pattern.placement.IPatternPlacementType;
import mod.chiselsandbits.api.placement.PlacementResult;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.registrars.ModPatternPlacementTypes;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;

public class RemovalPatternPlacementType
extends AbstractCustomRegistryEntry
implements IPatternPlacementType {
    @Override
    public class_265 buildVoxelShapeForWireframe(IMultiStateSnapshot sourceSnapshot, class_1657 player, class_243 targetedPoint, class_2350 hitFace) {
        class_2338 targetedPosition = hitFace.method_10171() == class_2350.class_2352.field_11060 ? new class_2338(targetedPoint) : new class_2338(targetedPoint).method_10081(hitFace.method_10153().method_10163());
        class_265 targetingShape = BlockPosStreamProvider.getForRange(player.method_5715() ? targetedPoint : class_243.method_24954((class_2382)targetedPosition), player.method_5715() ? targetedPoint.method_1031(0.9999, 0.9999, 0.9999) : class_243.method_24954((class_2382)targetedPosition)).map(position -> player.field_6002.method_8320(position).method_26218((class_1922)player.field_6002, position).method_1096((double)(position.method_10263() - targetedPosition.method_10263()), (double)(position.method_10264() - targetedPosition.method_10264()), (double)(position.method_10260() - targetedPosition.method_10260()))).reduce(class_259.method_1073(), (voxelShape, voxelShape2) -> class_259.method_1082((class_265)voxelShape, (class_265)voxelShape2, (class_247)class_247.field_1366)).method_1097();
        class_243 offSet = player.method_5715() ? new class_243(targetedPoint.method_10216() - (double)targetedPosition.method_10263(), targetedPoint.method_10214() - (double)targetedPosition.method_10264(), targetedPoint.method_10215() - (double)targetedPosition.method_10260()) : class_243.field_1353;
        class_265 ownShape = ((IPatternPlacementType)ModPatternPlacementTypes.PLACEMENT.get()).buildVoxelShapeForWireframe(sourceSnapshot, player, targetedPoint, hitFace).method_1096(offSet.method_10216(), offSet.method_10214(), offSet.method_10215());
        return class_259.method_1072((class_265)targetingShape, (class_265)ownShape, (class_247)class_247.field_16886);
    }

    @Override
    public PlacementResult performPlacement(IMultiStateSnapshot source, class_1750 context, boolean simulate) {
        boolean hasRequiredSpace;
        class_243 targetedPosition = context.method_8036().method_5715() ? context.method_17698() : class_243.method_24954((class_2382)context.method_8037().method_10081(context.method_8038().method_10153().method_10163()));
        IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().covering((class_1936)context.method_8045(), targetedPosition, targetedPosition.method_1031(0.9999, 0.9999, 0.9999));
        boolean isChiseledBlock = BlockPosStreamProvider.getForAccessor(areaMutator).map(pos -> context.method_8045().method_8320(pos)).allMatch(state -> state.method_26204() instanceof IMultiStateBlock);
        if (isChiseledBlock) {
            return PlacementResult.failure(IClientConfiguration::getNotFittingPatternPlacementColor, (class_2561)LocalStrings.PatternPlacementNotASolidBlock.getText());
        }
        boolean isSupported = BlockPosStreamProvider.getForAccessor(areaMutator).map(pos -> {
            class_2680 state = context.method_8045().method_8320(pos);
            class_2586 blockEntity = context.method_8045().method_8321(pos);
            return new BlockInformation(state, IStateVariantManager.getInstance().getStateVariant(state, Optional.ofNullable(blockEntity)));
        }).allMatch(state -> IEligibilityManager.getInstance().canBeChiseled((IBlockInformation)state) || state.isAir());
        if (!isSupported) {
            return PlacementResult.failure(IClientConfiguration::getNotFittingPatternPlacementColor, (class_2561)LocalStrings.PatternPlacementNotASupportedBlock.getText());
        }
        Map<IBlockInformation, Integer> totalRemovedBits = source.stream().filter(s -> !s.getBlockInformation().isAir()).filter(s -> {
            Optional<IStateEntryInfo> o = areaMutator.getInAreaTarget(s.getStartPoint().method_1019(areaMutator.getInWorldStartPoint()));
            return o.filter(os -> !os.getBlockInformation().isAir()).map(os -> !os.getBlockInformation().equals(s.getBlockInformation())).orElse(false);
        }).map(s -> areaMutator.getInAreaTarget(s.getStartPoint().method_1019(areaMutator.getInWorldStartPoint()))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(IStateEntryInfo::getBlockInformation, s -> 1, Integer::sum));
        IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(context.method_8036());
        boolean bl = hasRequiredSpace = context.method_8036().method_7337() || totalRemovedBits.entrySet().stream().allMatch(e -> playerBitInventory.canInsert((IBlockInformation)e.getKey(), (Integer)e.getValue()));
        if (!hasRequiredSpace) {
            return PlacementResult.failure(IClientConfiguration::getMissingBitsOrSpacePatternPlacementColor, (class_2561)LocalStrings.PatternPlacementNoBitSpace.getText());
        }
        if (simulate) {
            return PlacementResult.success();
        }
        try (IBatchMutation ignored = areaMutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(context.method_8036()));){
            source.stream().filter(s -> !s.getBlockInformation().isAir()).forEach(stateEntryInfo -> areaMutator.clearInAreaTarget(stateEntryInfo.getStartPoint()));
        }
        if (!context.method_8036().method_7337()) {
            totalRemovedBits.forEach(playerBitInventory::insertOrDiscard);
        }
        return PlacementResult.success();
    }

    @Override
    public class_243 getTargetedPosition(class_1799 heldStack, class_1657 playerEntity, class_3965 blockRayTraceResult) {
        return class_243.method_24954((class_2382)blockRayTraceResult.method_17777());
    }

    @Override
    @NotNull
    public class_2960 getIcon() {
        return new class_2960("chiselsandbits", "textures/icons/pattern_remove.png");
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.empty();
    }

    @Override
    public class_2561 getDisplayName() {
        return LocalStrings.PatternPlacementModeRemoval.getText();
    }
}

