/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.registrars;

import com.communi.suggestu.scena.core.event.IEvent;
import com.communi.suggestu.scena.core.event.IGameEvents;
import com.communi.suggestu.scena.core.event.IItemEntityPickupEvent;
import com.communi.suggestu.scena.core.event.IPlayerJoinedWorldEvent;
import com.communi.suggestu.scena.core.event.IPlayerLeftClickBlockEvent;
import com.communi.suggestu.scena.core.event.IPlayerLoggedInEvent;
import com.communi.suggestu.scena.core.event.IPlayerRightClickBlockEvent;
import com.communi.suggestu.scena.core.event.IRegisterCommandsEvent;
import com.communi.suggestu.scena.core.event.IServerAboutToStartEvent;
import com.communi.suggestu.scena.core.event.ProcessingResult;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.logic.BitStackPickupHandler;
import mod.chiselsandbits.logic.ChiselingManagerCountDownResetHandler;
import mod.chiselsandbits.logic.CommandRegistrationHandler;
import mod.chiselsandbits.logic.LeftClickInteractionHandler;
import mod.chiselsandbits.logic.MeasuringSynchronisationHandler;
import mod.chiselsandbits.logic.RightClickInteractionHandler;
import mod.chiselsandbits.logic.ServerStartHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    private ModEventHandler() {
        throw new IllegalStateException("Can not instantiate an instance of: ModEventHandler. This is a utility class");
    }

    public static void onModConstruction() {
        LOGGER.info("Registering event handlers");
        IGameEvents.getInstance().getItemEntityPickupEvent().register((IEvent)((IItemEntityPickupEvent)BitStackPickupHandler::pickupItems));
        IGameEvents.getInstance().getPlayerLeftClickEvent().register((IEvent)new IPlayerLeftClickBlockEvent(){

            public IPlayerLeftClickBlockEvent.Result handle(class_1657 player, class_1268 interactionHand, class_1799 itemStack, class_2338 blockPos, class_2350 direction, IPlayerLeftClickBlockEvent.Result result) {
                ClickProcessingState state = LeftClickInteractionHandler.leftClickOnBlock(player, interactionHand, itemStack, blockPos, direction, result.handled(), 1.mapResult(result));
                return new IPlayerLeftClickBlockEvent.Result(state.shouldCancel(), 1.mapResult(state.getNextState()));
            }

            private static ClickProcessingState.ProcessingResult mapResult(IPlayerLeftClickBlockEvent.Result result) {
                return switch (result.result()) {
                    default -> throw new IncompatibleClassChangeError();
                    case ProcessingResult.DENY -> ClickProcessingState.ProcessingResult.DENY;
                    case ProcessingResult.DEFAULT -> ClickProcessingState.ProcessingResult.DEFAULT;
                    case ProcessingResult.ALLOW -> ClickProcessingState.ProcessingResult.ALLOW;
                };
            }

            private static ProcessingResult mapResult(ClickProcessingState.ProcessingResult processingResult) {
                return switch (processingResult) {
                    default -> throw new IncompatibleClassChangeError();
                    case ClickProcessingState.ProcessingResult.DENY -> ProcessingResult.DENY;
                    case ClickProcessingState.ProcessingResult.DEFAULT -> ProcessingResult.DEFAULT;
                    case ClickProcessingState.ProcessingResult.ALLOW -> ProcessingResult.ALLOW;
                };
            }
        });
        IGameEvents.getInstance().getPlayerJoinedWorldEvent().register((IEvent)((IPlayerJoinedWorldEvent)(player, level) -> ChiselingManagerCountDownResetHandler.doResetFor(player)));
        IGameEvents.getInstance().getPlayerLoggedInEvent().register((IEvent)((IPlayerLoggedInEvent)player -> {
            MeasuringSynchronisationHandler.syncToAll();
            ChiselingManagerCountDownResetHandler.doResetFor(player);
        }));
        IGameEvents.getInstance().getRegisterCommandsEvent().register((IEvent)((IRegisterCommandsEvent)CommandRegistrationHandler::registerCommandsTo));
        IGameEvents.getInstance().getPlayerRightClickEvent().register((IEvent)new IPlayerRightClickBlockEvent(){

            public IPlayerRightClickBlockEvent.Result handle(class_1657 player, class_1268 interactionHand, class_1799 itemStack, class_2338 blockPos, class_2350 direction, IPlayerRightClickBlockEvent.Result result) {
                ClickProcessingState state = RightClickInteractionHandler.rightClickOnBlock(player.method_37908(), player, interactionHand, itemStack, blockPos, direction, result.handled(), 2.mapResult(result));
                return new IPlayerRightClickBlockEvent.Result(state.shouldCancel(), 2.mapResult(state.getNextState(), result.result()), 2.mapResult(state.getNextState(), result.useItemResult()), 2.mapResult(state.getNextState(), result.useBlockResult()));
            }

            private static ClickProcessingState.ProcessingResult mapResult(IPlayerRightClickBlockEvent.Result result) {
                return switch (result.result()) {
                    default -> throw new IncompatibleClassChangeError();
                    case ProcessingResult.DENY -> ClickProcessingState.ProcessingResult.DENY;
                    case ProcessingResult.DEFAULT -> ClickProcessingState.ProcessingResult.DEFAULT;
                    case ProcessingResult.ALLOW -> ClickProcessingState.ProcessingResult.ALLOW;
                };
            }

            private static ProcessingResult mapResult(ClickProcessingState.ProcessingResult processingResult, ProcessingResult current) {
                return switch (processingResult) {
                    default -> throw new IncompatibleClassChangeError();
                    case ClickProcessingState.ProcessingResult.DENY -> ProcessingResult.DENY;
                    case ClickProcessingState.ProcessingResult.DEFAULT -> current;
                    case ClickProcessingState.ProcessingResult.ALLOW -> ProcessingResult.ALLOW;
                };
            }
        });
        IGameEvents.getInstance().getServerAboutToStartEvent().register((IEvent)((IServerAboutToStartEvent)minecraftServer -> ServerStartHandler.onServerStart()));
    }
}

