/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.api;

import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import org.vivecraft.utils.math.Quaternion;
import org.vivecraft.utils.math.Vector3;

public class ServerVivePlayer {
    public byte[] hmdData;
    public byte[] controller0data;
    public byte[] controller1data;
    public byte[] draw;
    public float worldScale = 1.0f;
    public float heightscale = 1.0f;
    public byte activeHand = 0;
    public boolean crawling;
    boolean isTeleportMode;
    boolean isReverseHands;
    boolean isVR = true;
    public class_243 offset = new class_243(0.0, 0.0, 0.0);
    public class_3222 player;
    final Vector3 forward = new Vector3(0.0f, 0.0f, -1.0f);

    public ServerVivePlayer(class_3222 player) {
        this.player = player;
    }

    public float getDraw() {
        try {
            if (this.draw != null) {
                ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(this.draw);
                DataInputStream datainputstream = new DataInputStream(bytearrayinputstream);
                float f = datainputstream.readFloat();
                datainputstream.close();
                return f;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0.0f;
    }

    public class_243 getControllerVectorCustom(int controller, Vector3 direction) {
        byte[] abyte = this.controller0data;
        if (controller == 1) {
            abyte = this.controller1data;
        }
        if (this.isSeated()) {
            controller = 0;
        }
        if (abyte != null) {
            ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte);
            DataInputStream datainputstream = new DataInputStream(bytearrayinputstream);
            try {
                boolean flag = datainputstream.readBoolean();
                float f = datainputstream.readFloat();
                float f1 = datainputstream.readFloat();
                float f2 = datainputstream.readFloat();
                float f3 = datainputstream.readFloat();
                float f4 = datainputstream.readFloat();
                float f5 = datainputstream.readFloat();
                float f6 = datainputstream.readFloat();
                Quaternion quaternion = new Quaternion(f3, f4, f5, f6);
                Vector3 vector3 = quaternion.multiply(direction);
                datainputstream.close();
                return new class_243((double)vector3.getX(), (double)vector3.getY(), (double)vector3.getZ());
            }
            catch (IOException ioexception) {
                return this.player.method_5720();
            }
        }
        return this.player.method_5720();
    }

    public class_243 getControllerDir(int controller) {
        return this.getControllerVectorCustom(controller, this.forward);
    }

    public class_243 getHMDDir() {
        try {
            if (this.hmdData != null) {
                ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(this.hmdData);
                DataInputStream datainputstream = new DataInputStream(bytearrayinputstream);
                boolean flag = datainputstream.readBoolean();
                float f = datainputstream.readFloat();
                float f1 = datainputstream.readFloat();
                float f2 = datainputstream.readFloat();
                float f3 = datainputstream.readFloat();
                float f4 = datainputstream.readFloat();
                float f5 = datainputstream.readFloat();
                float f6 = datainputstream.readFloat();
                Quaternion quaternion = new Quaternion(f3, f4, f5, f6);
                Vector3 vector3 = quaternion.multiply(this.forward);
                datainputstream.close();
                return new class_243((double)vector3.getX(), (double)vector3.getY(), (double)vector3.getZ());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.player.method_5720();
    }

    public class_243 getHMDPos(class_1657 player) {
        try {
            if (this.hmdData != null) {
                ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(this.hmdData);
                DataInputStream datainputstream = new DataInputStream(bytearrayinputstream);
                boolean flag = datainputstream.readBoolean();
                float f = datainputstream.readFloat();
                float f1 = datainputstream.readFloat();
                float f2 = datainputstream.readFloat();
                datainputstream.close();
                return new class_243((double)f, (double)f1, (double)f2).method_1019(player.method_19538()).method_1019(this.offset);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return player.method_19538().method_1031(0.0, 1.62, 0.0);
    }

    public class_243 getControllerPos(int c, class_1657 player, boolean realPosition) {
        try {
            if (this.controller0data != null && this.controller0data != null) {
                ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(c == 0 ? this.controller0data : this.controller1data);
                DataInputStream datainputstream = new DataInputStream(bytearrayinputstream);
                boolean flag = datainputstream.readBoolean();
                float f = datainputstream.readFloat();
                float f1 = datainputstream.readFloat();
                float f2 = datainputstream.readFloat();
                datainputstream.close();
                if (this.isSeated() && !realPosition) {
                    class_243 vec3 = this.getHMDDir();
                    vec3 = vec3.method_1024((float)Math.toRadians(c == 0 ? -35.0 : 35.0));
                    vec3 = new class_243(vec3.field_1352, 0.0, vec3.field_1350);
                    vec3 = vec3.method_1029();
                    class_243 vec31 = this.getHMDPos(player).method_1031(vec3.field_1352 * 0.3 * (double)this.worldScale, -0.4 * (double)this.worldScale, vec3.field_1350 * 0.3 * (double)this.worldScale);
                    f = (float)vec31.field_1352;
                    f1 = (float)vec31.field_1351;
                    f2 = (float)vec31.field_1350;
                    return new class_243((double)f, (double)f1, (double)f2);
                }
                return new class_243((double)f, (double)f1, (double)f2).method_1019(player.method_19538()).method_1019(this.offset);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return player.method_19538().method_1031(0.0, 1.62, 0.0);
    }

    public class_243 getControllerPos(int c, class_1657 player) {
        return this.getControllerPos(c, player, false);
    }

    public boolean isVR() {
        return this.isVR;
    }

    public void setVR(boolean vr) {
        this.isVR = vr;
    }

    public boolean isSeated() {
        try {
            if (this.hmdData == null) {
                return false;
            }
            if (this.hmdData.length < 29) {
                return false;
            }
            ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(this.hmdData);
            DataInputStream datainputstream = new DataInputStream(bytearrayinputstream);
            boolean flag = datainputstream.readBoolean();
            datainputstream.close();
            return flag;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public byte[] getUberPacket() {
        class_2540 friendlybytebuf = new class_2540(Unpooled.buffer());
        friendlybytebuf.writeLong(this.player.method_5667().getMostSignificantBits());
        friendlybytebuf.writeLong(this.player.method_5667().getLeastSignificantBits());
        friendlybytebuf.writeBytes(this.hmdData);
        friendlybytebuf.writeBytes(this.controller0data);
        friendlybytebuf.writeBytes(this.controller1data);
        friendlybytebuf.writeFloat(this.worldScale);
        friendlybytebuf.writeFloat(this.heightscale);
        return friendlybytebuf.array();
    }
}

