/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.api;

import net.minecraft.class_243;
import net.minecraft.class_310;
import org.vivecraft.ClientDataHolder;
import org.vivecraft.render.RenderPass;
import org.vivecraft.settings.VRSettings;
import org.vivecraft.utils.Utils;
import org.vivecraft.utils.math.Matrix4f;
import org.vivecraft.utils.math.Vector3;

public class VRData {
    public VRDevicePose hmd;
    public VRDevicePose eye0;
    public VRDevicePose eye1;
    public VRDevicePose c0;
    public VRDevicePose c1;
    public VRDevicePose c2;
    public VRDevicePose h0;
    public VRDevicePose h1;
    public VRDevicePose t0;
    public VRDevicePose t1;
    public VRDevicePose cam;
    public class_243 origin;
    public float rotation_radians;
    public float worldScale;

    public VRData(class_243 origin, float walkMul, float worldScale, float rotation) {
        class_310 minecraft = class_310.method_1551();
        ClientDataHolder dataholder = ClientDataHolder.getInstance();
        this.origin = origin;
        this.worldScale = worldScale;
        this.rotation_radians = rotation;
        class_243 vec3 = dataholder.vr.getCenterEyePosition();
        class_243 vec31 = new class_243(vec3.field_1352 * (double)walkMul, vec3.field_1351, vec3.field_1350 * (double)walkMul);
        this.hmd = new VRDevicePose(this, dataholder.vr.hmdRotation, vec31, dataholder.vr.getHmdVector());
        this.eye0 = new VRDevicePose(this, dataholder.vr.getEyeRotation(RenderPass.LEFT), dataholder.vr.getEyePosition(RenderPass.LEFT).method_1020(vec3).method_1019(vec31), dataholder.vr.getHmdVector());
        this.eye1 = new VRDevicePose(this, dataholder.vr.getEyeRotation(RenderPass.RIGHT), dataholder.vr.getEyePosition(RenderPass.RIGHT).method_1020(vec3).method_1019(vec31), dataholder.vr.getHmdVector());
        this.c0 = new VRDevicePose(this, dataholder.vr.getAimRotation(0), dataholder.vr.getAimSource(0).method_1020(vec3).method_1019(vec31), dataholder.vr.getAimVector(0));
        this.c1 = new VRDevicePose(this, dataholder.vr.getAimRotation(1), dataholder.vr.getAimSource(1).method_1020(vec3).method_1019(vec31), dataholder.vr.getAimVector(1));
        this.h0 = new VRDevicePose(this, dataholder.vr.getHandRotation(0), dataholder.vr.getAimSource(0).method_1020(vec3).method_1019(vec31), dataholder.vr.getHandVector(0));
        this.h1 = new VRDevicePose(this, dataholder.vr.getHandRotation(1), dataholder.vr.getAimSource(1).method_1020(vec3).method_1019(vec31), dataholder.vr.getHandVector(1));
        if (dataholder.vrSettings.seated) {
            this.t0 = this.eye0;
            this.t1 = this.eye1;
        } else {
            Matrix4f matrix4f = this.getSmoothedRotation(0, 0.2f);
            Matrix4f matrix4f1 = this.getSmoothedRotation(1, 0.2f);
            this.t0 = new VRDevicePose(this, matrix4f, dataholder.vr.getAimSource(0).method_1020(vec3).method_1019(vec31), matrix4f.transform(Vector3.forward()).toVector3d());
            this.t1 = new VRDevicePose(this, matrix4f1, dataholder.vr.getAimSource(1).method_1020(vec3).method_1019(vec31), matrix4f1.transform(Vector3.forward()).toVector3d());
        }
        Matrix4f matrix4f2 = Matrix4f.multiply(Matrix4f.rotationY(-rotation), new Matrix4f(ClientDataHolder.getInstance().cameraTracker.getRotation()).transposed());
        float inverseWorldScale = 1.0f / worldScale;
        this.cam = new VRDevicePose(this, matrix4f2, ClientDataHolder.getInstance().cameraTracker.getPosition().method_1020(origin).method_1024(-rotation).method_18805((double)inverseWorldScale, (double)inverseWorldScale, (double)inverseWorldScale).method_1020(vec3).method_1019(vec31), matrix4f2.transform(Vector3.forward()).toVector3d());
        if (dataholder.vr.mrMovingCamActive) {
            this.c2 = new VRDevicePose(this, dataholder.vr.getAimRotation(2), dataholder.vr.getAimSource(2).method_1020(vec3).method_1019(vec31), dataholder.vr.getAimVector(2));
        } else {
            VRSettings vrsettings = ClientDataHolder.getInstance().vrSettings;
            Matrix4f matrix4f3 = new Matrix4f(vrsettings.vrFixedCamrotQuat).transposed();
            class_243 vec32 = new class_243((double)vrsettings.vrFixedCamposX, (double)vrsettings.vrFixedCamposY, (double)vrsettings.vrFixedCamposZ);
            class_243 vec33 = matrix4f3.transform(Vector3.forward()).toVector3d();
            this.c2 = new VRDevicePose(this, matrix4f3, vec32.method_1020(vec3).method_1019(vec31), vec33);
        }
    }

    private Matrix4f getSmoothedRotation(int c, float lenSec) {
        class_310 minecraft = class_310.method_1551();
        ClientDataHolder dataholder = ClientDataHolder.getInstance();
        class_243 vec3 = dataholder.vr.controllerHistory[c].averagePosition(lenSec);
        class_243 vec31 = dataholder.vr.controllerForwardHistory[c].averagePosition(lenSec);
        class_243 vec32 = dataholder.vr.controllerUpHistory[c].averagePosition(lenSec);
        class_243 vec33 = vec31.method_1036(vec32);
        return new Matrix4f((float)vec33.field_1352, (float)vec31.field_1352, (float)vec32.field_1352, (float)vec33.field_1351, (float)vec31.field_1351, (float)vec32.field_1351, (float)vec33.field_1350, (float)vec31.field_1350, (float)vec32.field_1350);
    }

    public VRDevicePose getController(int c) {
        return c == 1 ? this.c1 : (c == 2 ? this.c2 : this.c0);
    }

    public VRDevicePose getHand(int c) {
        return c == 0 ? this.h0 : this.h1;
    }

    public float getBodyYaw() {
        class_243 vec31;
        if (ClientDataHolder.getInstance().vrSettings.seated) {
            return this.hmd.getYaw();
        }
        class_243 vec3 = this.c1.getPosition().method_1020(this.c0.getPosition()).method_1029().method_1024(-1.5707964f);
        if (vec3.method_1026(vec31 = this.hmd.getDirection()) < 0.0) {
            vec3 = vec3.method_22882();
        }
        vec3 = Utils.vecLerp(vec31, vec3, 0.7);
        return (float)Math.toDegrees(Math.atan2(-vec3.field_1352, vec3.field_1350));
    }

    public float getFacingYaw() {
        if (ClientDataHolder.getInstance().vrSettings.seated) {
            return this.hmd.getYaw();
        }
        class_243 vec3 = this.c1.getPosition().method_1020(this.c0.getPosition()).method_1029().method_1024(-1.5707964f);
        return ClientDataHolder.getInstance().vrSettings.reverseHands ? (float)Math.toDegrees(Math.atan2(vec3.field_1352, -vec3.field_1350)) : (float)Math.toDegrees(Math.atan2(-vec3.field_1352, vec3.field_1350));
    }

    public class_243 getHeadPivot() {
        class_243 vec3 = this.hmd.getPosition();
        Vector3 vector3 = this.hmd.getMatrix().transform(new Vector3(0.0f, -0.1f * this.worldScale, 0.1f * this.worldScale));
        return new class_243((double)vector3.getX() + vec3.field_1352, (double)vector3.getY() + vec3.field_1351, (double)vector3.getZ() + vec3.field_1350);
    }

    public class_243 getHeadRear() {
        class_243 vec3 = this.hmd.getPosition();
        Vector3 vector3 = this.hmd.getMatrix().transform(new Vector3(0.0f, -0.2f, 0.2f));
        return new class_243((double)vector3.getX() + vec3.field_1352, (double)vector3.getY() + vec3.field_1351, (double)vector3.getZ() + vec3.field_1350);
    }

    public VRDevicePose getEye(RenderPass pass) {
        switch (pass) {
            case CENTER: {
                return this.hmd;
            }
            case LEFT: {
                return this.eye0;
            }
            case RIGHT: {
                return this.eye1;
            }
            case THIRD: {
                return this.c2;
            }
            case SCOPER: {
                return this.t0;
            }
            case SCOPEL: {
                return this.t1;
            }
            case CAMERA: {
                return this.cam;
            }
        }
        return this.hmd;
    }

    public String toString() {
        return "data:\r\n \t\t origin: " + this.origin + "\r\n \t\t rotation: " + String.format("%.2f", Float.valueOf(this.rotation_radians)) + "\r\n \t\t scale: " + String.format("%.2f", Float.valueOf(this.worldScale)) + "\r\n \t\t hmd " + this.hmd + "\r\n \t\t c0 " + this.c0 + "\r\n \t\t c1 " + this.c1 + "\r\n \t\t c2 " + this.c2;
    }

    protected class_243 vecMult(class_243 in, float factor) {
        return new class_243(in.field_1352 * (double)factor, in.field_1351 * (double)factor, in.field_1350 * (double)factor);
    }

    public class VRDevicePose {
        final VRData data;
        final class_243 pos;
        final class_243 dir;
        final Matrix4f matrix;

        public VRDevicePose(VRData data, Matrix4f matrix, class_243 pos, class_243 dir) {
            this.data = data;
            this.matrix = matrix.transposed().transposed();
            this.pos = new class_243(pos.field_1352, pos.field_1351, pos.field_1350);
            this.dir = new class_243(dir.field_1352, dir.field_1351, dir.field_1350);
        }

        public class_243 getPosition() {
            class_243 vec3 = this.pos.method_1021((double)VRData.this.worldScale);
            vec3 = vec3.method_1024(this.data.rotation_radians);
            return vec3.method_1031(this.data.origin.field_1352, this.data.origin.field_1351, this.data.origin.field_1350);
        }

        public class_243 getDirection() {
            return new class_243(this.dir.field_1352, this.dir.field_1351, this.dir.field_1350).method_1024(this.data.rotation_radians);
        }

        public class_243 getCustomVector(class_243 axis) {
            Vector3 vector3 = this.matrix.transform(new Vector3((float)axis.field_1352, (float)axis.field_1351, (float)axis.field_1350));
            return vector3.toVector3d().method_1024(this.data.rotation_radians);
        }

        public float getYaw() {
            class_243 vec3 = this.getDirection();
            return (float)Math.toDegrees(Math.atan2(-vec3.field_1352, vec3.field_1350));
        }

        public float getPitch() {
            class_243 vec3 = this.getDirection();
            return (float)Math.toDegrees(Math.asin(vec3.field_1351 / vec3.method_1033()));
        }

        public float getRoll() {
            return (float)(-Math.toDegrees(Math.atan2(this.matrix.M[1][0], this.matrix.M[1][1])));
        }

        public Matrix4f getMatrix() {
            Matrix4f matrix4f = Matrix4f.rotationY(VRData.this.rotation_radians);
            return Matrix4f.multiply(matrix4f, this.matrix);
        }

        public String toString() {
            return "Device: pos:" + this.getPosition() + " dir: " + this.getDirection();
        }
    }
}

