/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.gameplay;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1496;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1771;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1823;
import net.minecraft.class_1826;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_4050;
import net.minecraft.class_5819;
import net.minecraft.class_727;
import net.minecraft.class_746;
import org.vivecraft.ClientDataHolder;
import org.vivecraft.PehkuiHelper;
import org.vivecraft.Xplat;
import org.vivecraft.api.ClientNetworkHelper;
import org.vivecraft.api.ItemTags;
import org.vivecraft.api.VRData;
import org.vivecraft.extensions.GameRendererExtension;
import org.vivecraft.extensions.PlayerExtension;
import org.vivecraft.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.gameplay.trackers.Tracker;
import org.vivecraft.gameplay.trackers.VehicleTracker;
import org.vivecraft.settings.VRSettings;

public class VRPlayer {
    class_310 mc = class_310.method_1551();
    ClientDataHolder dh = ClientDataHolder.getInstance();
    public VRData vrdata_room_pre;
    public VRData vrdata_world_pre;
    public VRData vrdata_room_post;
    public VRData vrdata_world_post;
    public VRData vrdata_world_render;
    private long errorPrintTime = class_156.method_658();
    ArrayList<Tracker> trackers = new ArrayList();
    public float worldScale;
    private float rawWorldScale;
    private boolean noTeleportClient;
    private boolean teleportOverride;
    public int teleportWarningTimer;
    public class_243 roomOrigin;
    private boolean isFreeMoveCurrent;
    public double wfMode;
    public int wfCount;
    public int roomScaleMovementDelay;
    boolean initdone;
    public boolean onTick;

    public void registerTracker(Tracker tracker) {
        this.trackers.add(tracker);
    }

    public VRPlayer() {
        this.worldScale = ClientDataHolder.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.WORLD_SCALE).getFloat();
        this.rawWorldScale = ClientDataHolder.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.WORLD_SCALE).getFloat();
        this.noTeleportClient = true;
        this.teleportOverride = false;
        this.teleportWarningTimer = -1;
        this.roomOrigin = new class_243(0.0, 0.0, 0.0);
        this.isFreeMoveCurrent = true;
        this.wfMode = 0.0;
        this.wfCount = 0;
        this.roomScaleMovementDelay = 0;
        this.initdone = false;
        this.vrdata_room_pre = new VRData(new class_243(0.0, 0.0, 0.0), this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        this.vrdata_room_post = new VRData(new class_243(0.0, 0.0, 0.0), this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        this.vrdata_world_post = new VRData(new class_243(0.0, 0.0, 0.0), this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        this.vrdata_world_pre = new VRData(new class_243(0.0, 0.0, 0.0), this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
    }

    public VRData getVRDataWorld() {
        return this.vrdata_world_render != null ? this.vrdata_world_render : this.vrdata_world_pre;
    }

    public static VRPlayer get() {
        return ClientDataHolder.getInstance().vrPlayer;
    }

    public static class_243 room_to_world_pos(class_243 pos, VRData data) {
        class_243 vec3 = new class_243(pos.field_1352 * (double)data.worldScale, pos.field_1351 * (double)data.worldScale, pos.field_1350 * (double)data.worldScale);
        vec3 = vec3.method_1024(data.rotation_radians);
        return vec3.method_1031(data.origin.field_1352, data.origin.field_1351, data.origin.field_1350);
    }

    public static class_243 world_to_room_pos(class_243 pos, VRData data) {
        class_243 vec3 = pos.method_1031(-data.origin.field_1352, -data.origin.field_1351, -data.origin.field_1350);
        vec3 = new class_243(vec3.field_1352 / (double)data.worldScale, vec3.field_1351 / (double)data.worldScale, vec3.field_1350 / (double)data.worldScale);
        return vec3.method_1024(-data.rotation_radians);
    }

    public void postPoll() {
        this.vrdata_room_pre = new VRData(new class_243(0.0, 0.0, 0.0), this.dh.vrSettings.walkMultiplier, 1.0f, 0.0f);
        GuiHandler.processGui();
        KeyboardHandler.processGui();
        RadialHandler.processGui();
    }

    public void preTick() {
        this.onTick = true;
        this.vrdata_world_pre = new VRData(this.roomOrigin, this.dh.vrSettings.walkMultiplier, this.worldScale, (float)Math.toRadians(this.dh.vrSettings.worldRotation));
        float f = this.dh.vrSettings.overrides.getSetting(VRSettings.VrOptions.WORLD_SCALE).getFloat();
        if (((GameRendererExtension)this.mc.field_1773).isInMenuRoom()) {
            this.worldScale = 1.0f;
        } else {
            if (this.wfCount > 0 && !this.mc.method_1493()) {
                if (this.wfCount < 40) {
                    this.rawWorldScale = (float)((double)this.rawWorldScale - this.wfMode);
                    if (this.wfMode > 0.0) {
                        if (this.rawWorldScale < f) {
                            this.rawWorldScale = f;
                        }
                    } else if (this.wfMode < 0.0 && this.rawWorldScale > f) {
                        this.rawWorldScale = f;
                    }
                } else {
                    this.rawWorldScale = (float)((double)this.rawWorldScale + this.wfMode);
                    if (this.wfMode > 0.0) {
                        if (this.rawWorldScale > 20.0f) {
                            this.rawWorldScale = 20.0f;
                        }
                    } else if (this.wfMode < 0.0 && this.rawWorldScale < 0.1f) {
                        this.rawWorldScale = 0.1f;
                    }
                }
                --this.wfCount;
            } else {
                this.rawWorldScale = f;
            }
            this.worldScale = this.rawWorldScale;
            if (Xplat.isModLoaded("pehkui")) {
                this.worldScale *= PehkuiHelper.getPlayerScale((class_1297)this.mc.field_1724, this.mc.method_1488());
                if (this.worldScale > 100.0f) {
                    this.worldScale = 100.0f;
                } else if (this.worldScale < 0.025f) {
                    this.worldScale = 0.025f;
                }
            }
        }
        if (this.dh.vrSettings.seated && !((GameRendererExtension)this.mc.field_1773).isInMenuRoom()) {
            this.dh.vrSettings.worldRotation = this.dh.vr.seatedRot;
        }
    }

    public void postTick() {
        class_310 minecraft = class_310.method_1551();
        ClientDataHolder dataholder = ClientDataHolder.getInstance();
        VRData vrdata = new VRData(this.vrdata_world_pre.origin, dataholder.vrSettings.walkMultiplier, this.vrdata_world_pre.worldScale, this.vrdata_world_pre.rotation_radians);
        VRData vrdata1 = new VRData(this.vrdata_world_pre.origin, dataholder.vrSettings.walkMultiplier, this.worldScale, this.vrdata_world_pre.rotation_radians);
        class_243 vec3 = vrdata1.hmd.getPosition().method_1020(vrdata.hmd.getPosition());
        this.roomOrigin = this.roomOrigin.method_1020(vec3);
        VRData vrdata2 = new VRData(this.roomOrigin, dataholder.vrSettings.walkMultiplier, this.worldScale, this.vrdata_world_pre.rotation_radians);
        float f = dataholder.vrSettings.worldRotation;
        float f1 = (float)Math.toDegrees(this.vrdata_world_pre.rotation_radians);
        this.rotateOriginAround(-f + f1, vrdata2.getHeadPivot());
        this.vrdata_room_post = new VRData(new class_243(0.0, 0.0, 0.0), dataholder.vrSettings.walkMultiplier, 1.0f, 0.0f);
        this.vrdata_world_post = new VRData(this.roomOrigin, dataholder.vrSettings.walkMultiplier, this.worldScale, (float)Math.toRadians(dataholder.vrSettings.worldRotation));
        this.doPermanantLookOverride(minecraft.field_1724, this.vrdata_world_post);
        ClientNetworkHelper.sendVRPlayerPositions(this);
        this.onTick = false;
    }

    public void preRender(float par1) {
        class_310 minecraft = class_310.method_1551();
        ClientDataHolder dataholder = ClientDataHolder.getInstance();
        float f = this.vrdata_world_post.worldScale * par1 + this.vrdata_world_pre.worldScale * (1.0f - par1);
        float f1 = this.vrdata_world_post.rotation_radians;
        float f2 = this.vrdata_world_pre.rotation_radians;
        float f3 = Math.abs(f1 - f2);
        if ((double)f3 > Math.PI) {
            if (f1 > f2) {
                f2 = (float)((double)f2 + Math.PI * 2);
            } else {
                f1 = (float)((double)f1 + Math.PI * 2);
            }
        }
        float f4 = f1 * par1 + f2 * (1.0f - par1);
        class_243 vec3 = new class_243(this.vrdata_world_pre.origin.field_1352 + (this.vrdata_world_post.origin.field_1352 - this.vrdata_world_pre.origin.field_1352) * (double)par1, this.vrdata_world_pre.origin.field_1351 + (this.vrdata_world_post.origin.field_1351 - this.vrdata_world_pre.origin.field_1351) * (double)par1, this.vrdata_world_pre.origin.field_1350 + (this.vrdata_world_post.origin.field_1350 - this.vrdata_world_pre.origin.field_1350) * (double)par1);
        this.vrdata_world_render = new VRData(vec3, dataholder.vrSettings.walkMultiplier, f, f4);
        for (Tracker tracker : this.trackers) {
            if (tracker.getEntryPoint() != Tracker.EntryPoint.SPECIAL_ITEMS) continue;
            tracker.idleTick(minecraft.field_1724);
            if (tracker.isActive(minecraft.field_1724)) {
                tracker.doProcess(minecraft.field_1724);
                continue;
            }
            tracker.reset(minecraft.field_1724);
        }
    }

    public void postRender(float par1) {
    }

    public void setRoomOrigin(double x, double y, double z, boolean reset) {
        if (reset && this.vrdata_world_pre != null) {
            this.vrdata_world_pre.origin = new class_243(x, y, z);
        }
        this.roomOrigin = new class_243(x, y, z);
    }

    public void snapRoomOriginToPlayerEntity(class_746 player, boolean reset, boolean instant) {
        if (!Thread.currentThread().getName().equals("Server thread") && player != null && player.method_19538() != class_243.field_1353) {
            class_310 minecraft = class_310.method_1551();
            ClientDataHolder dataholder = ClientDataHolder.getInstance();
            if (dataholder.sneakTracker.sneakCounter <= 0) {
                VRData vrdata = this.vrdata_world_pre;
                if (instant) {
                    vrdata = new VRData(this.roomOrigin, dataholder.vrSettings.walkMultiplier, this.worldScale, (float)Math.toRadians(dataholder.vrSettings.worldRotation));
                }
                class_243 vec3 = vrdata.getHeadPivot().method_1020(vrdata.origin);
                double d0 = player.method_23317() - vec3.field_1352;
                double d2 = player.method_23321() - vec3.field_1350;
                double d1 = player.method_23318() + ((PlayerExtension)player).getRoomYOffsetFromPose();
                this.setRoomOrigin(d0, d1, d2, reset);
            }
        }
    }

    public float rotDiff_Degrees(float start, float end) {
        double d0 = Math.toRadians(end);
        double d1 = Math.toRadians(start);
        return (float)Math.toDegrees(Math.atan2(Math.sin(d0 - d1), Math.cos(d0 - d1)));
    }

    public void rotateOriginAround(float degrees, class_243 o) {
        class_243 vec3 = this.roomOrigin;
        float f = (float)Math.toRadians(degrees);
        if (f != 0.0f) {
            this.setRoomOrigin(Math.cos(f) * (vec3.field_1352 - o.field_1352) - Math.sin(f) * (vec3.field_1350 - o.field_1350) + o.field_1352, vec3.field_1351, Math.sin(f) * (vec3.field_1352 - o.field_1352) + Math.cos(f) * (vec3.field_1350 - o.field_1350) + o.field_1350, false);
        }
    }

    public void tick(class_746 player, class_310 mc, class_5819 rand) {
        if (((PlayerExtension)player).getInitFromServer()) {
            if (!this.initdone) {
                System.out.println("<Debug info start>");
                System.out.println("Room object: " + this);
                System.out.println("Room origin: " + this.vrdata_world_pre.origin);
                System.out.println("Hmd position room: " + this.vrdata_room_pre.hmd.getPosition());
                System.out.println("Hmd position world: " + this.vrdata_world_pre.hmd.getPosition());
                System.out.println("Hmd Projection Left: " + this.dh.vrRenderer.eyeproj[0]);
                System.out.println("Hmd Projection Right: " + this.dh.vrRenderer.eyeproj[1]);
                System.out.println("<Debug info end>");
                this.initdone = true;
            }
            this.doPlayerMoveInRoom(player);
            for (Tracker tracker : this.trackers) {
                if (tracker.getEntryPoint() != Tracker.EntryPoint.LIVING_UPDATE) continue;
                tracker.idleTick(mc.field_1724);
                if (tracker.isActive(mc.field_1724)) {
                    tracker.doProcess(mc.field_1724);
                    continue;
                }
                tracker.reset(mc.field_1724);
            }
            if (player.method_5765()) {
                class_1308 mob;
                class_1297 entity = mc.field_1724.method_5854();
                if (entity instanceof class_1496) {
                    class_1496 abstracthorse = (class_1496)entity;
                    if (abstracthorse.method_5787() && abstracthorse.method_6725() && !this.dh.horseTracker.isActive(mc.field_1724)) {
                        abstracthorse.field_6283 = this.vrdata_world_pre.getBodyYaw();
                        this.dh.vehicleTracker.rotationCooldown = 10;
                    }
                } else if (entity instanceof class_1308 && (mob = (class_1308)entity).method_5787()) {
                    mob.field_6283 = this.vrdata_world_pre.getBodyYaw();
                    this.dh.vehicleTracker.rotationCooldown = 10;
                }
            }
        }
    }

    public void doPlayerMoveInRoom(class_746 player) {
        block8: {
            VRData vrdata;
            ClientDataHolder dataholder;
            class_310 minecraft;
            block9: {
                block7: {
                    if (this.roomScaleMovementDelay <= 0) break block7;
                    --this.roomScaleMovementDelay;
                    break block8;
                }
                minecraft = class_310.method_1551();
                dataholder = ClientDataHolder.getInstance();
                if (player == null || player.method_5715() || player.method_6113() || dataholder.jumpTracker.isjumping() || dataholder.climbTracker.isGrabbingLadder() || !player.method_5805()) break block8;
                vrdata = new VRData(this.roomOrigin, dataholder.vrSettings.walkMultiplier, this.worldScale, this.vrdata_world_pre.rotation_radians);
                if (!dataholder.vehicleTracker.canRoomscaleDismount(minecraft.field_1724)) break block9;
                class_243 vec35 = minecraft.field_1724.method_5854().method_19538();
                class_243 vec36 = vrdata.getHeadPivot();
                double d6 = Math.sqrt((vec36.field_1352 - vec35.field_1352) * (vec36.field_1352 - vec35.field_1352) + (vec36.field_1350 - vec35.field_1350) * (vec36.field_1350 - vec35.field_1350));
                if (!(d6 > 1.0)) break block8;
                dataholder.sneakTracker.sneakCounter = 5;
                break block8;
            }
            float f = player.method_17681() / 2.0f;
            float f1 = player.method_17682();
            class_243 vec3 = vrdata.getHeadPivot();
            double d0 = vec3.field_1352;
            double d1 = player.method_23318();
            double d2 = vec3.field_1350;
            class_238 aabb = new class_238(d0 - (double)f, d1, d2 - (double)f, d0 + (double)f, d1 + (double)f1, d2 + (double)f);
            class_243 vec31 = null;
            float f2 = 0.0625f;
            boolean flag = minecraft.field_1687.method_8587((class_1297)player, aabb);
            if (flag) {
                player.method_23327(d0, !dataholder.vrSettings.simulateFalling ? d1 : player.method_23318(), d2);
                player.method_5857(new class_238(aabb.field_1323, aabb.field_1322, aabb.field_1321, aabb.field_1320, aabb.field_1322 + (double)f1, aabb.field_1324));
                player.field_6017 = 0.0f;
                this.getEstimatedTorsoPosition(d0, d1, d2);
            } else if ((dataholder.vrSettings.walkUpBlocks && ((PlayerExtension)player).getMuhJumpFactor() == 1.0f || dataholder.climbTracker.isGrabbingLadder() && dataholder.vrSettings.realisticClimbEnabled) && player.field_6017 == 0.0f) {
                float f3;
                double d3;
                class_238 aabb1;
                boolean flag1;
                if (vec31 == null) {
                    vec31 = this.getEstimatedTorsoPosition(d0, d1, d2);
                }
                boolean bl = flag1 = !minecraft.field_1687.method_8587((class_1297)player, aabb1 = new class_238(vec31.field_1352 - (d3 = (double)(f - (f3 = player.method_18377((class_4050)player.method_18376()).field_18067 * 0.45f))), aabb.field_1322, vec31.field_1350 - d3, vec31.field_1352 + d3, aabb.field_1325, vec31.field_1350 + d3));
                if (flag1) {
                    double d4 = vec31.field_1352 - d0;
                    double d5 = vec31.field_1350 - d2;
                    aabb = aabb.method_989(d4, 0.0, d5);
                    int i = 0;
                    if (player.method_6101() && dataholder.vrSettings.realisticClimbEnabled) {
                        i = 6;
                    }
                    for (int j = 0; j <= 10 + i; ++j) {
                        flag = minecraft.field_1687.method_8587((class_1297)player, aabb = aabb.method_989(0.0, 0.1, 0.0));
                        if (!flag) continue;
                        player.method_23327(d0 += d4, d1 += (double)(0.1f * (float)j), d2 += d5);
                        player.method_5857(new class_238(aabb.field_1323, aabb.field_1322, aabb.field_1321, aabb.field_1320, aabb.field_1325, aabb.field_1324));
                        class_243 vec32 = this.roomOrigin.method_1031(d4, (double)(0.1f * (float)j), d5);
                        this.setRoomOrigin(vec32.field_1352, vec32.field_1351, vec32.field_1350, false);
                        class_243 vec33 = player.method_5720();
                        class_243 vec34 = new class_243(vec33.field_1352, 0.0, vec33.field_1350).method_1029();
                        player.field_6017 = 0.0f;
                        ((PlayerExtension)minecraft.field_1724).stepSound(new class_2338(player.method_19538()), player.method_19538());
                        break;
                    }
                }
            }
        }
    }

    public class_243 getEstimatedTorsoPosition(double x, double y, double z) {
        class_746 entity = class_310.method_1551().field_1724;
        class_243 vec3 = entity.method_5720();
        class_243 vec31 = new class_243(vec3.field_1352, 0.0, vec3.field_1350).method_1029();
        float f = (float)vec3.field_1351 * 0.25f;
        return new class_243(x + vec31.field_1352 * (double)f, y + vec31.field_1351 * (double)f, z + vec31.field_1350 * (double)f);
    }

    public void blockDust(double x, double y, double z, int count, class_2338 bp, class_2680 bs, float scale, float velscale) {
        new Random();
        class_310 minecraft = class_310.method_1551();
        for (int i = 0; i < count; ++i) {
            class_727 terrainparticle = new class_727(minecraft.field_1687, x, y, z, 0.0, 0.0, 0.0, bs);
            terrainparticle.method_3075(velscale);
            minecraft.field_1713.method_3058(terrainparticle.method_3087(scale));
        }
    }

    public void updateFreeMove() {
        if (this.dh.teleportTracker.isAiming()) {
            this.isFreeMoveCurrent = false;
        }
        if (this.mc.field_1724.field_3913.field_3905 != 0.0f || this.mc.field_1724.field_3913.field_3907 != 0.0f) {
            this.isFreeMoveCurrent = true;
        }
        this.updateTeleportKeys();
    }

    public boolean getFreeMove() {
        if (this.dh.vrSettings.seated) {
            return this.dh.vrSettings.seatedFreeMove || !this.isTeleportEnabled();
        }
        return this.isFreeMoveCurrent || this.dh.vrSettings.forceStandingFreeMove;
    }

    public String toString() {
        return "VRPlayer: \r\n \t origin: " + this.roomOrigin + "\r\n \t rotation: " + String.format("%.3f", Float.valueOf(ClientDataHolder.getInstance().vrSettings.worldRotation)) + "\r\n \t scale: " + String.format("%.3f", Float.valueOf(this.worldScale)) + "\r\n \t room_pre " + this.vrdata_room_pre + "\r\n \t world_pre " + this.vrdata_world_pre + "\r\n \t world_post " + this.vrdata_world_post + "\r\n \t world_render " + this.vrdata_world_render;
    }

    public class_243 getRightClickLookOverride(class_1657 entity, int c) {
        class_1799 itemstack;
        class_243 vec3;
        block7: {
            block6: {
                vec3 = entity.method_5720();
                if (((GameRendererExtension)this.mc.field_1773).getCrossVec() != null) {
                    vec3 = entity.method_5836(1.0f).method_1020(((GameRendererExtension)this.mc.field_1773).getCrossVec()).method_1029().method_22882();
                }
                class_1799 class_17992 = itemstack = c == 0 ? entity.method_6047() : entity.method_6079();
                if (itemstack.method_7909() instanceof class_1823 || itemstack.method_7909() instanceof class_1771 || itemstack.method_7909() instanceof class_1826 || itemstack.method_7909() instanceof class_1812 || itemstack.method_7909() instanceof class_1753 || itemstack.method_31573(ItemTags.VIVECRAFT_THROW_ITEMS)) break block6;
                if (!(itemstack.method_7909() instanceof class_1764)) break block7;
                class_1764 crossbowitem = (class_1764)itemstack.method_7909();
                if (!class_1764.method_7781((class_1799)itemstack)) break block7;
            }
            VRData vrdata = this.dh.vrPlayer.vrdata_world_pre;
            vec3 = vrdata.getController(c).getDirection();
            class_243 vec31 = this.dh.bowTracker.getAimVector();
            if (this.dh.bowTracker.isNotched() && vec31 != null && vec31.method_1027() > 0.0) {
                vec3 = vec31.method_22882();
            }
            return vec3;
        }
        if (itemstack.method_7909() == class_1802.field_8550 && this.dh.interactTracker.bukkit[c]) {
            vec3 = entity.method_5836(1.0f).method_1020(this.dh.vrPlayer.vrdata_world_pre.getController(c).getPosition()).method_1029().method_22882();
        }
        return vec3;
    }

    public void doPermanantLookOverride(class_746 entity, VRData data) {
        if (entity == null) {
            return;
        }
        if (entity.method_5765()) {
            class_243 vec3 = VehicleTracker.getSteeringDirection(entity);
            if (vec3 != null) {
                entity.method_36457((float)Math.toDegrees(Math.asin(-vec3.field_1351 / vec3.method_1033())));
                entity.method_36456((float)Math.toDegrees(Math.atan2(-vec3.field_1352, vec3.field_1350)));
                entity.method_5847(entity.method_36454());
            }
        } else if (entity.method_6039()) {
            if (entity.method_6058() == class_1268.field_5808) {
                entity.method_36456(data.getController(0).getYaw());
                entity.method_5847(entity.method_36454());
                entity.method_36457(-data.getController(0).getPitch());
            } else {
                entity.method_36456(data.getController(1).getYaw());
                entity.method_5847(entity.method_36454());
                entity.method_36457(-data.getController(1).getPitch());
            }
        } else if (entity.method_5624() && (entity.field_3913.field_3904 || this.mc.field_1690.field_1903.method_1434()) || entity.method_6128() || entity.method_5681() && entity.field_6250 > 0.0f) {
            VRSettings vrsettings = this.dh.vrSettings;
            if (this.dh.vrSettings.vrFreeMoveMode == VRSettings.FreeMove.CONTROLLER) {
                entity.method_36456(data.getController(1).getYaw());
                entity.method_5847(entity.method_36454());
                entity.method_36457(-data.getController(1).getPitch());
            } else {
                entity.method_36456(data.hmd.getYaw());
                entity.method_5847(entity.method_36454());
                entity.method_36457(-data.hmd.getPitch());
            }
        } else if (((GameRendererExtension)this.mc.field_1773).getCrossVec() != null) {
            class_243 playerToCrosshair = entity.method_5836(1.0f).method_1020(((GameRendererExtension)this.mc.field_1773).getCrossVec());
            double what = playerToCrosshair.field_1351 / playerToCrosshair.method_1033();
            if (what > 1.0) {
                what = 1.0;
            }
            if (what < -1.0) {
                what = -1.0;
            }
            float pitch = (float)Math.toDegrees(Math.asin(what));
            float yaw = (float)Math.toDegrees(Math.atan2(playerToCrosshair.field_1352, -playerToCrosshair.field_1350));
            entity.method_36457(pitch);
            entity.method_36456(yaw);
            entity.method_5847(yaw);
        } else {
            entity.method_36456(data.hmd.getYaw());
            entity.method_5847(entity.method_36454());
            entity.method_36457(-data.hmd.getPitch());
        }
    }

    public class_243 AimedPointAtDistance(VRData source, int controller, double distance) {
        class_243 vec3 = source.getController(controller).getPosition();
        class_243 vec31 = source.getController(controller).getDirection();
        return vec3.method_1031(vec31.field_1352 * distance, vec31.field_1351 * distance, vec31.field_1350 * distance);
    }

    public class_239 rayTraceBlocksVR(VRData source, int controller, double blockReachDistance, boolean p_174822_4_) {
        class_243 vec3 = source.getController(controller).getPosition();
        class_243 vec31 = this.AimedPointAtDistance(source, controller, blockReachDistance);
        return this.mc.field_1687.method_17742(new class_3959(vec3, vec31, class_3959.class_3960.field_17559, p_174822_4_ ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, (class_1297)this.mc.field_1724));
    }

    public boolean isTeleportSupported() {
        return !this.noTeleportClient;
    }

    public boolean isTeleportOverridden() {
        return this.teleportOverride;
    }

    public boolean isTeleportEnabled() {
        boolean flag;
        boolean bl = flag = !this.noTeleportClient || this.teleportOverride;
        if (this.dh.vrSettings.seated) {
            return flag;
        }
        return flag && !this.dh.vrSettings.forceStandingFreeMove;
    }

    public void setTeleportSupported(boolean supported) {
        this.noTeleportClient = !supported;
        this.updateTeleportKeys();
    }

    public void setTeleportOverride(boolean override) {
        this.teleportOverride = override;
        this.updateTeleportKeys();
    }

    private void updateTeleportKeys() {
        this.dh.vr.getInputAction(this.dh.vr.keyTeleport).setEnabled(this.isTeleportEnabled());
        this.dh.vr.getInputAction(this.dh.vr.keyTeleportFallback).setEnabled(!this.isTeleportEnabled());
    }
}

