/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.gameplay.trackers;

import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.vivecraft.ClientDataHolder;
import org.vivecraft.api.ClientNetworkHelper;
import org.vivecraft.extensions.PlayerExtension;
import org.vivecraft.gameplay.VRPlayer;
import org.vivecraft.gameplay.trackers.Tracker;
import org.vivecraft.settings.AutoCalibration;

public class JumpTracker
extends Tracker {
    public class_243[] latchStart = new class_243[]{new class_243(0.0, 0.0, 0.0), new class_243(0.0, 0.0, 0.0)};
    public class_243[] latchStartOrigin = new class_243[]{new class_243(0.0, 0.0, 0.0), new class_243(0.0, 0.0, 0.0)};
    public class_243[] latchStartPlayer = new class_243[]{new class_243(0.0, 0.0, 0.0), new class_243(0.0, 0.0, 0.0)};
    private boolean c0Latched = false;
    private boolean c1Latched = false;

    public JumpTracker(class_310 mc, ClientDataHolder dh) {
        super(mc, dh);
    }

    public boolean isClimbeyJump() {
        return !this.isActive(class_310.method_1551().field_1724) ? false : this.isClimbeyJumpEquipped();
    }

    public boolean isClimbeyJumpEquipped() {
        return ClientNetworkHelper.serverAllowsClimbey && ((PlayerExtension)class_310.method_1551().field_1724).isClimbeyJumpEquipped();
    }

    @Override
    public boolean isActive(class_746 p) {
        if (ClientDataHolder.getInstance().vrSettings.seated) {
            return false;
        }
        if (!ClientDataHolder.getInstance().vrPlayer.getFreeMove() && !ClientDataHolder.getInstance().vrSettings.simulateFalling) {
            return false;
        }
        if (!ClientDataHolder.getInstance().vrSettings.realisticJumpEnabled) {
            return false;
        }
        if (p != null && p.method_5805()) {
            if (this.mc.field_1761 == null) {
                return false;
            }
            if (!p.method_5799() && !p.method_5771() && p.method_24828()) {
                return !p.method_5715() && !p.method_5765();
            }
            return false;
        }
        return false;
    }

    public boolean isjumping() {
        return this.c1Latched || this.c0Latched;
    }

    @Override
    public void idleTick(class_746 player) {
        this.dh.vr.getInputAction(this.dh.vr.keyClimbeyJump).setEnabled(this.isClimbeyJumpEquipped() && (this.isActive(player) || this.dh.climbTracker.isClimbeyClimbEquipped() && this.dh.climbTracker.isGrabbingLadder()));
    }

    @Override
    public void reset(class_746 player) {
        this.c1Latched = false;
        this.c0Latched = false;
    }

    @Override
    public void doProcess(class_746 player) {
        if (this.isClimbeyJumpEquipped()) {
            VRPlayer vrplayer = this.dh.vrPlayer;
            boolean[] aboolean = new boolean[2];
            for (int i = 0; i < 2; ++i) {
                aboolean[i] = this.dh.vr.keyClimbeyJump.method_1434();
            }
            boolean flag = false;
            if (!aboolean[0] && this.c0Latched) {
                this.dh.vr.triggerHapticPulse(0, 200);
                flag = true;
            }
            class_243 vec3 = this.dh.vrPlayer.vrdata_room_pre.getController(0).getPosition();
            class_243 vec31 = this.dh.vrPlayer.vrdata_room_pre.getController(1).getPosition();
            class_243 vec32 = vec3.method_1019(vec31).method_1021(0.5);
            if (aboolean[0] && !this.c0Latched) {
                this.latchStart[0] = vec32;
                this.latchStartOrigin[0] = this.dh.vrPlayer.vrdata_world_pre.origin;
                this.latchStartPlayer[0] = this.mc.field_1724.method_19538();
                this.dh.vr.triggerHapticPulse(0, 1000);
            }
            if (!aboolean[1] && this.c1Latched) {
                this.dh.vr.triggerHapticPulse(1, 200);
                flag = true;
            }
            if (aboolean[1] && !this.c1Latched) {
                this.latchStart[1] = vec32;
                this.latchStartOrigin[1] = this.dh.vrPlayer.vrdata_world_pre.origin;
                this.latchStartPlayer[1] = this.mc.field_1724.method_19538();
                this.dh.vr.triggerHapticPulse(1, 1000);
            }
            this.c0Latched = aboolean[0];
            this.c1Latched = aboolean[1];
            int j = 0;
            class_243 vec33 = vec32.method_1020(this.latchStart[j]);
            vec33 = vec33.method_1024(this.dh.vrPlayer.vrdata_world_pre.rotation_radians);
            if (!flag && this.isjumping()) {
                this.dh.vr.triggerHapticPulse(0, 200);
                this.dh.vr.triggerHapticPulse(1, 200);
            }
            if (flag) {
                this.dh.climbTracker.forceActivate = true;
                class_243 vec34 = this.dh.vr.controllerHistory[0].netMovement(0.3).method_1019(this.dh.vr.controllerHistory[1].netMovement(0.3));
                double d0 = (this.dh.vr.controllerHistory[0].averageSpeed(0.3) + this.dh.vr.controllerHistory[1].averageSpeed(0.3)) / 2.0;
                vec34 = vec34.method_1021((double)0.33f * d0);
                float f = 0.66f;
                if (vec34.method_1033() > (double)f) {
                    vec34 = vec34.method_1021((double)f / vec34.method_1033());
                }
                if (player.method_6059(class_1294.field_5913)) {
                    vec34 = vec34.method_1021((double)player.method_6112(class_1294.field_5913).method_5578() + 1.5);
                }
                vec34 = vec34.method_1024(this.dh.vrPlayer.vrdata_world_pre.rotation_radians);
                class_243 vec35 = this.mc.field_1724.method_19538().method_1020(vec33);
                if (vec33.field_1351 < 0.0 && vec34.field_1351 < 0.0) {
                    double d2 = -vec34.field_1352;
                    double d1 = player.method_18798().field_1352 + d2 * 1.25;
                    d2 = -vec34.field_1351;
                    double d3 = -vec34.field_1350;
                    player.method_18800(d1, d2, player.method_18798().field_1350 + d3 * 1.25);
                    player.field_6038 = vec35.field_1352;
                    player.field_5971 = vec35.field_1351;
                    player.field_5989 = vec35.field_1350;
                    vec35 = vec35.method_1019(player.method_18798());
                    player.method_5814(vec35.field_1352, vec35.field_1351, vec35.field_1350);
                    this.dh.vrPlayer.snapRoomOriginToPlayerEntity(player, false, true);
                    this.mc.field_1724.method_7322(0.3f);
                    this.mc.field_1724.method_24830(false);
                } else {
                    this.dh.vrPlayer.snapRoomOriginToPlayerEntity(player, false, true);
                }
            } else if (this.isjumping()) {
                class_243 vec36 = this.latchStartOrigin[0].method_1020(this.latchStartPlayer[0]).method_1019(this.mc.field_1724.method_19538()).method_1020(vec33);
                this.dh.vrPlayer.setRoomOrigin(vec36.field_1352, vec36.field_1351, vec36.field_1350, false);
            }
        } else if (this.dh.vr.hmdPivotHistory.netMovement((double)0.25).field_1351 > 0.1 && this.dh.vr.hmdPivotHistory.latest().field_1351 - (double)AutoCalibration.getPlayerHeight() > (double)this.dh.vrSettings.jumpThreshold) {
            player.method_6043();
        }
    }

    public boolean isBoots(class_1799 i) {
        if (i.method_7960()) {
            return false;
        }
        if (!i.method_7938()) {
            return false;
        }
        if (i.method_7909() != class_1802.field_8370) {
            return false;
        }
        if (!i.method_7985() || !i.method_7969().method_10577("Unbreakable")) {
            return false;
        }
        return i.method_7964().method_10851() instanceof class_2588 && ((class_2588)i.method_7964().method_10851()).method_11022().equals("vivecraft.item.jumpboots") || i.method_7964().getString().equals("Jump Boots");
    }
}

