/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.provider;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1159;
import net.minecraft.class_276;
import net.minecraft.class_279;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_2874;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_4494;
import net.minecraft.class_5321;
import net.minecraft.class_7134;
import net.minecraft.class_757;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryUtil;
import org.vivecraft.ClientDataHolder;
import org.vivecraft.IrisHelper;
import org.vivecraft.VRTextureTarget;
import org.vivecraft.Xplat;
import org.vivecraft.extensions.GameRendererExtension;
import org.vivecraft.extensions.RenderTargetExtension;
import org.vivecraft.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.gameplay.trackers.TelescopeTracker;
import org.vivecraft.mixin.blaze3d.systems.RenderSystemAccessor;
import org.vivecraft.provider.MCVR;
import org.vivecraft.render.RenderConfigException;
import org.vivecraft.render.RenderPass;
import org.vivecraft.render.ShaderHelper;
import org.vivecraft.render.VRShaders;
import org.vivecraft.settings.VRSettings;
import org.vivecraft.utils.LangHelper;

public abstract class VRRenderer {
    public static final String RENDER_SETUP_FAILURE_MESSAGE = "Failed to initialise stereo rendering plugin: ";
    public Map<String, class_279> alphaShaders = new HashMap<String, class_279>();
    public class_276 cameraFramebuffer;
    public class_276 cameraRenderFramebuffer;
    protected int dispLastWidth;
    protected int dispLastHeight;
    public Map<String, class_279> entityShaders = new HashMap<String, class_279>();
    public class_1159[] eyeproj = new class_1159[2];
    public class_276 framebufferEye0;
    public class_276 framebufferEye1;
    public class_276 framebufferMR;
    public class_276 framebufferUndistorted;
    public class_276 framebufferVrRender;
    public class_276 fsaaFirstPassResultFBO;
    public class_276 fsaaLastPassResultFBO;
    protected float[][] hiddenMesheVertecies = new float[2][];
    public class_5321<class_2874> lastDimensionId = class_7134.field_37666;
    public int lastDisplayFBHeight = 0;
    public int lastDisplayFBWidth = 0;
    public boolean lastEnableVsync = true;
    public boolean lastFogFancy = true;
    public boolean lastFogFast = false;
    public int lastGuiScale = 0;
    protected VRSettings.MirrorMode lastMirror;
    public int lastRenderDistanceChunks = -1;
    public long lastWindow = 0L;
    public float lastWorldScale = 0.0f;
    protected int LeftEyeTextureId = -1;
    protected int RightEyeTextureId = -1;
    public int mirrorFBHeight;
    public int mirrorFBWidth;
    protected boolean reinitFramebuffers = true;
    public boolean reinitShadersFlag = false;
    public float renderScale;
    protected class_3545<Integer, Integer> resolution;
    public float ss = -1.0f;
    public class_276 telescopeFramebufferL;
    public class_276 telescopeFramebufferR;
    protected MCVR vr;
    FloatBuffer buffer = MemoryUtil.memAllocFloat((int)16);
    FloatBuffer buffer2 = MemoryUtil.memAllocFloat((int)16);

    public VRRenderer(MCVR vr) {
        this.vr = vr;
    }

    protected void checkGLError(String message) {
        if (GlStateManager._getError() != 0) {
            System.err.println(message);
        }
    }

    public boolean clipPlanesChanged() {
        return false;
    }

    public abstract void createRenderTexture(int var1, int var2);

    public abstract class_1159 getProjectionMatrix(int var1, float var2, float var3);

    public abstract void endFrame() throws RenderConfigException;

    public abstract boolean providesStencilMask();

    protected class_279 createShaderGroup(class_2960 resource, class_276 fb) throws JsonSyntaxException, IOException {
        class_310 minecraft = class_310.method_1551();
        class_279 postchain = new class_279(minecraft.method_1531(), minecraft.method_1478(), fb, resource);
        postchain.method_1259(fb.field_1480, fb.field_1477);
        return postchain;
    }

    public void deleteRenderTextures() {
        if (this.LeftEyeTextureId > 0) {
            RenderSystem.deleteTexture((int)this.LeftEyeTextureId);
        }
        if (this.RightEyeTextureId > 0) {
            RenderSystem.deleteTexture((int)this.RightEyeTextureId);
        }
        this.RightEyeTextureId = -1;
        this.LeftEyeTextureId = -1;
    }

    public void doStencil(boolean inverse) {
        class_310 minecraft = class_310.method_1551();
        ClientDataHolder dataholder = ClientDataHolder.getInstance();
        GL11.glEnable((int)2960);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7681);
        RenderSystem.stencilMask((int)255);
        if (inverse) {
            RenderSystem.clearStencil((int)255);
            RenderSystem.clearDepth((double)0.0);
            RenderSystem.stencilFunc((int)519, (int)0, (int)255);
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        } else {
            RenderSystem.clearStencil((int)0);
            RenderSystem.clearDepth((double)1.0);
            RenderSystem.stencilFunc((int)519, (int)255, (int)255);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        RenderSystem.clear((int)1280, (boolean)false);
        RenderSystem.clearStencil((int)0);
        RenderSystem.clearDepth((double)1.0);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        RenderSystem.disableTexture();
        RenderSystem.disableCull();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        class_276 fb = minecraft.method_1522();
        RenderSystem.viewport((int)0, (int)0, (int)fb.field_1480, (int)fb.field_1477);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((class_1159)class_1159.method_34239((float)0.0f, (float)fb.field_1480, (float)0.0f, (float)fb.field_1477, (float)0.0f, (float)20.0f));
        RenderSystem.getModelViewStack().method_22903();
        RenderSystem.getModelViewStack().method_34426();
        if (inverse) {
            RenderSystem.getModelViewStack().method_22904(0.0, 0.0, -20.0);
        }
        RenderSystem.applyModelViewMatrix();
        int s = GlStateManager._getInteger((int)35725);
        if (dataholder.currentPass == RenderPass.SCOPEL || dataholder.currentPass == RenderPass.SCOPER) {
            this.drawCircle(fb.field_1480, fb.field_1477);
        } else if (dataholder.currentPass == RenderPass.LEFT || dataholder.currentPass == RenderPass.RIGHT) {
            this.drawMask();
        }
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.getModelViewStack().method_22909();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableTexture();
        RenderSystem.enableCull();
        GlStateManager._glUseProgram((int)s);
        RenderSystem.stencilFunc((int)517, (int)255, (int)1);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        RenderSystem.stencilMask((int)0);
        RenderSystem.depthFunc((int)515);
    }

    public void doFSAA(RenderPass eye, boolean hasShaders) {
        if (this.fsaaFirstPassResultFBO == null) {
            this.reinitFrameBuffers("FSAA Setting Changed");
        } else {
            int l;
            int k;
            RenderSystem.disableBlend();
            RenderSystem.backupProjectionMatrix();
            class_1159 matrix4f = new class_1159();
            matrix4f.method_22668();
            RenderSystem.setProjectionMatrix((class_1159)matrix4f);
            RenderSystem.getModelViewStack().method_22903();
            RenderSystem.getModelViewStack().method_22904(0.0, 0.0, (double)-0.7f);
            RenderSystem.applyModelViewMatrix();
            this.fsaaFirstPassResultFBO.method_1230(class_310.field_1703);
            this.fsaaFirstPassResultFBO.method_1235(false);
            RenderSystem.setShaderTexture((int)0, (int)this.framebufferVrRender.method_30277());
            RenderSystem.setShaderTexture((int)1, (int)this.framebufferVrRender.method_30278());
            RenderSystem.activeTexture((int)33985);
            this.framebufferVrRender.method_35610();
            RenderSystem.activeTexture((int)33986);
            RenderSystem.bindTexture((int)((RenderTargetExtension)this.framebufferVrRender).getDepthBufferId());
            RenderSystem.activeTexture((int)33984);
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.clearDepth((double)1.0);
            this.fsaaFirstPassResultFBO.method_35610();
            RenderSystem.clear((int)16640, (boolean)class_310.field_1703);
            RenderSystem.viewport((int)0, (int)0, (int)this.fsaaFirstPassResultFBO.field_1480, (int)this.fsaaFirstPassResultFBO.field_1477);
            VRShaders._Lanczos_texelWidthOffsetUniform.method_1251(1.0f / (3.0f * (float)this.fsaaFirstPassResultFBO.field_1480));
            VRShaders._Lanczos_texelHeightOffsetUniform.method_1251(0.0f);
            VRShaders._Lanczos_modelViewUniform.method_1250(RenderSystem.getModelViewMatrix());
            VRShaders._Lanczos_projectionUniform.method_1250(RenderSystem.getProjectionMatrix());
            for (k = 0; k < RenderSystemAccessor.getShaderTextures().length; ++k) {
                l = RenderSystem.getShaderTexture((int)k);
                VRShaders.lanczosShader.method_34583("Sampler" + k, (Object)l);
            }
            VRShaders.lanczosShader.method_34586();
            RenderSystem.clear((int)16384, (boolean)class_310.field_1703);
            this.drawQuad();
            this.fsaaLastPassResultFBO.method_1230(class_310.field_1703);
            this.fsaaLastPassResultFBO.method_1235(false);
            RenderSystem.activeTexture((int)33985);
            this.fsaaFirstPassResultFBO.method_35610();
            RenderSystem.setShaderTexture((int)0, (int)this.fsaaFirstPassResultFBO.method_30277());
            RenderSystem.activeTexture((int)33986);
            RenderSystem.setShaderTexture((int)1, (int)this.fsaaFirstPassResultFBO.method_30278());
            RenderSystem.bindTexture((int)((RenderTargetExtension)this.fsaaFirstPassResultFBO).getDepthBufferId());
            RenderSystem.activeTexture((int)33984);
            this.checkGLError("posttex");
            RenderSystem.viewport((int)0, (int)0, (int)this.fsaaLastPassResultFBO.field_1480, (int)this.fsaaLastPassResultFBO.field_1477);
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.clearDepth((double)1.0);
            RenderSystem.clear((int)16640, (boolean)class_310.field_1703);
            this.checkGLError("postclear");
            RenderSystem.activeTexture((int)33984);
            this.checkGLError("postact");
            for (k = 0; k < RenderSystemAccessor.getShaderTextures().length; ++k) {
                l = RenderSystem.getShaderTexture((int)k);
                VRShaders.lanczosShader.method_34583("Sampler" + k, (Object)l);
            }
            VRShaders._Lanczos_texelWidthOffsetUniform.method_1251(0.0f);
            VRShaders._Lanczos_texelHeightOffsetUniform.method_1251(1.0f / (3.0f * (float)this.framebufferEye0.field_1477));
            VRShaders.lanczosShader.method_34586();
            this.drawQuad();
            this.checkGLError("postdraw");
            RenderSystem.restoreProjectionMatrix();
            RenderSystem.getModelViewStack().method_22909();
            VRShaders.lanczosShader.method_34585();
            class_310.method_1551().method_1522().method_1235(true);
        }
    }

    private void drawCircle(float width, float height) {
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27381, class_290.field_1592);
        int i = 32;
        float f = width / 2.0f;
        builder.method_22912((double)(width / 2.0f), (double)(width / 2.0f), 0.0).method_1344();
        for (int j = 0; j < i + 1; ++j) {
            float f1 = (float)j / (float)i * (float)Math.PI * 2.0f;
            float f2 = (float)((double)(width / 2.0f) + Math.cos(f1) * (double)f);
            float f3 = (float)((double)(width / 2.0f) + Math.sin(f1) * (double)f);
            builder.method_22912((double)f2, (double)f3, 0.0).method_1344();
        }
        class_286.method_43433((class_287.class_7433)builder.method_1326());
    }

    private void drawMask() {
        class_310 mc = class_310.method_1551();
        ClientDataHolder dh = ClientDataHolder.getInstance();
        float[] verts = this.getStencilMask(dh.currentPass);
        if (verts == null) {
            return;
        }
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27379, class_290.field_1592);
        for (int i = 0; i < verts.length; i += 2) {
            builder.method_22912((double)(verts[i] * dh.vrRenderer.renderScale), (double)(verts[i + 1] * dh.vrRenderer.renderScale), 0.0).method_1344();
        }
        RenderSystem.setShader(class_757::method_34539);
        class_286.method_43433((class_287.class_7433)builder.method_1326());
    }

    private void drawQuad() {
        RenderSystem.setShader(class_757::method_34542);
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        builder.method_22912(-1.0, -1.0, 0.0).method_22913(0.0f, 0.0f).method_1344();
        builder.method_22912(1.0, -1.0, 0.0).method_22913(1.0f, 0.0f).method_1344();
        builder.method_22912(1.0, 1.0, 0.0).method_22913(1.0f, 1.0f).method_1344();
        builder.method_22912(-1.0, 1.0, 0.0).method_22913(0.0f, 1.0f).method_1344();
        class_286.method_43437((class_287.class_7433)builder.method_1326());
    }

    public double getCurrentTimeSecs() {
        return (double)System.nanoTime() / 1.0E9;
    }

    public double getFrameTiming() {
        return this.getCurrentTimeSecs();
    }

    public String getinitError() {
        return this.vr.initStatus;
    }

    public String getLastError() {
        return "";
    }

    public String getName() {
        return "OpenVR";
    }

    public List<RenderPass> getRenderPasses() {
        class_310 minecraft = class_310.method_1551();
        ClientDataHolder dataholder = ClientDataHolder.getInstance();
        ArrayList<RenderPass> list = new ArrayList<RenderPass>();
        list.add(RenderPass.LEFT);
        list.add(RenderPass.RIGHT);
        if (dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.FIRST_PERSON) {
            list.add(RenderPass.CENTER);
        } else if (dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
            if (dataholder.vrSettings.mixedRealityUndistorted && dataholder.vrSettings.mixedRealityUnityLike) {
                list.add(RenderPass.CENTER);
            }
            list.add(RenderPass.THIRD);
        } else if (dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON) {
            list.add(RenderPass.THIRD);
        }
        if (minecraft.field_1724 != null) {
            if (TelescopeTracker.isTelescope(minecraft.field_1724.method_6047()) && TelescopeTracker.isViewing(0)) {
                list.add(RenderPass.SCOPER);
            }
            if (TelescopeTracker.isTelescope(minecraft.field_1724.method_6079()) && TelescopeTracker.isViewing(1)) {
                list.add(RenderPass.SCOPEL);
            }
            if (dataholder.cameraTracker.isVisible()) {
                list.add(RenderPass.CAMERA);
            }
        }
        return list;
    }

    public abstract class_3545<Integer, Integer> getRenderTextureSizes();

    public float[] getStencilMask(RenderPass eye) {
        if (this.hiddenMesheVertecies != null && (eye == RenderPass.LEFT || eye == RenderPass.RIGHT)) {
            return eye == RenderPass.LEFT ? this.hiddenMesheVertecies[0] : this.hiddenMesheVertecies[1];
        }
        return null;
    }

    public boolean isInitialized() {
        return this.vr.initSuccess;
    }

    public void reinitFrameBuffers(String cause) {
        this.reinitFramebuffers = true;
        System.out.println("Reinit Render: " + cause);
    }

    public void setupRenderConfiguration() throws Exception {
        class_310 minecraft = class_310.method_1551();
        ClientDataHolder dataholder = ClientDataHolder.getInstance();
        boolean flag = false;
        if (this.clipPlanesChanged()) {
            this.reinitFrameBuffers("Clip Planes Changed");
        }
        if (minecraft.method_22683().method_4490() != this.lastWindow) {
            this.lastWindow = minecraft.method_22683().method_4490();
            this.reinitFrameBuffers("Window Handle Changed");
        }
        if (this.lastEnableVsync != (Boolean)minecraft.field_1690.method_42433().method_41753()) {
            this.reinitFrameBuffers("VSync Changed");
            this.lastEnableVsync = (Boolean)minecraft.field_1690.method_42433().method_41753();
        }
        if (this.lastMirror != dataholder.vrSettings.displayMirrorMode) {
            if (!Xplat.isModLoaded("iris") && !Xplat.isModLoaded("oculus") || !IrisHelper.isShaderActive()) {
                this.reinitFrameBuffers("Mirror Changed");
            }
            this.lastMirror = dataholder.vrSettings.displayMirrorMode;
        }
        if ((this.framebufferMR == null || this.framebufferUndistorted == null) && (Xplat.isModLoaded("iris") || Xplat.isModLoaded("oculus")) && IrisHelper.isShaderActive()) {
            this.reinitFrameBuffers("Shaders on, but some buffers not initialized");
        }
        if (this.reinitFramebuffers) {
            int i1;
            boolean flag1;
            int j;
            this.reinitShadersFlag = true;
            this.checkGLError("Start Init");
            int i = minecraft.method_22683().method_4480() < 1 ? 1 : minecraft.method_22683().method_4480();
            int n = j = minecraft.method_22683().method_4507() < 1 ? 1 : minecraft.method_22683().method_4507();
            if (class_4494.method_22090().toLowerCase().contains("intel")) {
                throw new RenderConfigException("Incompatible", LangHelper.get("vivecraft.messages.intelgraphics", class_4494.method_22090()));
            }
            if (!this.isInitialized()) {
                throw new RenderConfigException(RENDER_SETUP_FAILURE_MESSAGE + this.getName(), LangHelper.get(this.getinitError(), new Object[0]));
            }
            class_3545<Integer, Integer> tuple = this.getRenderTextureSizes();
            int eyew = (Integer)tuple.method_15442();
            int eyeh = (Integer)tuple.method_15441();
            if (this.framebufferVrRender != null) {
                this.framebufferVrRender.method_1238();
                this.framebufferVrRender = null;
            }
            if (this.framebufferMR != null) {
                this.framebufferMR.method_1238();
                this.framebufferMR = null;
            }
            if (this.framebufferUndistorted != null) {
                this.framebufferUndistorted.method_1238();
                this.framebufferUndistorted = null;
            }
            if (GuiHandler.guiFramebuffer != null) {
                GuiHandler.guiFramebuffer.method_1238();
                GuiHandler.guiFramebuffer = null;
            }
            if (KeyboardHandler.Framebuffer != null) {
                KeyboardHandler.Framebuffer.method_1238();
                KeyboardHandler.Framebuffer = null;
            }
            if (RadialHandler.Framebuffer != null) {
                RadialHandler.Framebuffer.method_1238();
                RadialHandler.Framebuffer = null;
            }
            if (this.telescopeFramebufferL != null) {
                this.telescopeFramebufferL.method_1238();
                this.telescopeFramebufferL = null;
            }
            if (this.telescopeFramebufferR != null) {
                this.telescopeFramebufferR.method_1238();
                this.telescopeFramebufferR = null;
            }
            if (this.cameraFramebuffer != null) {
                this.cameraFramebuffer.method_1238();
                this.cameraFramebuffer = null;
            }
            if (this.cameraRenderFramebuffer != null) {
                this.cameraRenderFramebuffer.method_1238();
                this.cameraRenderFramebuffer = null;
            }
            if (this.fsaaFirstPassResultFBO != null) {
                this.fsaaFirstPassResultFBO.method_1238();
                this.fsaaFirstPassResultFBO = null;
            }
            if (this.fsaaLastPassResultFBO != null) {
                this.fsaaLastPassResultFBO.method_1238();
                this.fsaaLastPassResultFBO = null;
            }
            boolean bl = flag1 = (i1 = 0) > 0;
            if (this.LeftEyeTextureId == -1) {
                this.createRenderTexture(eyew, eyeh);
                if (this.LeftEyeTextureId == -1) {
                    throw new RenderConfigException(RENDER_SETUP_FAILURE_MESSAGE + this.getName(), this.getLastError());
                }
                dataholder.print("Provider supplied render texture IDs: " + this.LeftEyeTextureId + " " + this.RightEyeTextureId);
                dataholder.print("Provider supplied texture resolution: " + eyew + " x " + eyeh);
            }
            this.checkGLError("Render Texture setup");
            if (this.framebufferEye0 == null) {
                this.framebufferEye0 = new VRTextureTarget("L Eye", eyew, eyeh, false, false, this.LeftEyeTextureId, false, true, false);
                dataholder.print(this.framebufferEye0.toString());
                this.checkGLError("Left Eye framebuffer setup");
            }
            if (this.framebufferEye1 == null) {
                this.framebufferEye1 = new VRTextureTarget("R Eye", eyew, eyeh, false, false, this.RightEyeTextureId, false, true, false);
                dataholder.print(this.framebufferEye1.toString());
                this.checkGLError("Right Eye framebuffer setup");
            }
            this.renderScale = (float)Math.sqrt(dataholder.vrSettings.renderScaleFactor);
            i = (int)Math.ceil((float)eyew * this.renderScale);
            j = (int)Math.ceil((float)eyeh * this.renderScale);
            this.framebufferVrRender = new VRTextureTarget("3D Render", i, j, true, false, -1, true, true, dataholder.vrSettings.vrUseStencil);
            dataholder.print(this.framebufferVrRender.toString());
            this.checkGLError("3D framebuffer setup");
            this.mirrorFBWidth = minecraft.method_22683().method_4480();
            this.mirrorFBHeight = minecraft.method_22683().method_4507();
            if (dataholder.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
                this.mirrorFBWidth = minecraft.method_22683().method_4480() / 2;
                if (dataholder.vrSettings.mixedRealityUnityLike) {
                    this.mirrorFBHeight = minecraft.method_22683().method_4507() / 2;
                }
            }
            List<RenderPass> list = this.getRenderPasses();
            for (RenderPass renderpass : list) {
                System.out.println("Passes: " + renderpass.toString());
            }
            if (list.contains((Object)RenderPass.THIRD) || (Xplat.isModLoaded("iris") || Xplat.isModLoaded("oculus")) && IrisHelper.isShaderActive()) {
                this.framebufferMR = new VRTextureTarget("Mixed Reality Render", this.mirrorFBWidth, this.mirrorFBHeight, true, false, -1, true, false, false);
                dataholder.print(this.framebufferMR.toString());
                this.checkGLError("Mixed reality framebuffer setup");
            }
            if (list.contains((Object)RenderPass.CENTER) || (Xplat.isModLoaded("iris") || Xplat.isModLoaded("oculus")) && IrisHelper.isShaderActive()) {
                this.framebufferUndistorted = new VRTextureTarget("Undistorted View Render", this.mirrorFBWidth, this.mirrorFBHeight, true, false, -1, false, false, false);
                dataholder.print(this.framebufferUndistorted.toString());
                this.checkGLError("Undistorted view framebuffer setup");
            }
            GuiHandler.guiFramebuffer = new VRTextureTarget("GUI", minecraft.method_22683().method_4480(), minecraft.method_22683().method_4507(), true, false, -1, false, true, false);
            dataholder.print(GuiHandler.guiFramebuffer.toString());
            this.checkGLError("GUI framebuffer setup");
            KeyboardHandler.Framebuffer = new VRTextureTarget("Keyboard", minecraft.method_22683().method_4480(), minecraft.method_22683().method_4507(), true, false, -1, false, true, false);
            dataholder.print(KeyboardHandler.Framebuffer.toString());
            this.checkGLError("Keyboard framebuffer setup");
            RadialHandler.Framebuffer = new VRTextureTarget("Radial Menu", minecraft.method_22683().method_4480(), minecraft.method_22683().method_4507(), true, false, -1, false, true, false);
            dataholder.print(RadialHandler.Framebuffer.toString());
            this.checkGLError("Radial framebuffer setup");
            int j2 = 720;
            int k2 = 720;
            this.checkGLError("Mirror framebuffer setup");
            this.telescopeFramebufferR = new VRTextureTarget("TelescopeR", j2, k2, true, false, -1, true, false, false);
            dataholder.print(this.telescopeFramebufferR.toString());
            this.checkGLError("TelescopeR framebuffer setup");
            this.telescopeFramebufferR.method_1236(0.0f, 0.0f, 0.0f, 1.0f);
            this.telescopeFramebufferR.method_1230(class_310.field_1703);
            this.telescopeFramebufferL = new VRTextureTarget("TelescopeL", j2, k2, true, false, -1, true, false, false);
            dataholder.print(this.telescopeFramebufferL.toString());
            this.telescopeFramebufferL.method_1236(0.0f, 0.0f, 0.0f, 1.0f);
            this.telescopeFramebufferL.method_1230(class_310.field_1703);
            this.checkGLError("TelescopeL framebuffer setup");
            int j1 = Math.round(1920.0f * dataholder.vrSettings.handCameraResScale);
            int k1 = Math.round(1080.0f * dataholder.vrSettings.handCameraResScale);
            int l1 = j1;
            int i2 = k1;
            this.cameraFramebuffer = new VRTextureTarget("Handheld Camera", j1, k1, true, false, -1, true, false, false);
            dataholder.print(this.cameraFramebuffer.toString());
            this.checkGLError("Camera framebuffer setup");
            this.cameraRenderFramebuffer = new VRTextureTarget("Handheld Camera Render", l1, i2, true, false, -1, true, true, false);
            dataholder.print(this.cameraRenderFramebuffer.toString());
            this.checkGLError("Camera render framebuffer setup");
            ((GameRendererExtension)minecraft.field_1773).setupClipPlanes();
            this.eyeproj[0] = this.getProjectionMatrix(0, ((GameRendererExtension)minecraft.field_1773).getMinClipDistance(), ((GameRendererExtension)minecraft.field_1773).getClipDistance());
            this.eyeproj[1] = this.getProjectionMatrix(1, ((GameRendererExtension)minecraft.field_1773).getMinClipDistance(), ((GameRendererExtension)minecraft.field_1773).getClipDistance());
            if (dataholder.vrSettings.useFsaa) {
                try {
                    this.checkGLError("pre FSAA FBO creation");
                    this.fsaaFirstPassResultFBO = new VRTextureTarget("FSAA Pass1 FBO", eyew, j, true, false, -1, false, false, false);
                    this.fsaaLastPassResultFBO = new VRTextureTarget("FSAA Pass2 FBO", eyew, eyeh, true, false, -1, false, false, false);
                    dataholder.print(this.fsaaFirstPassResultFBO.toString());
                    dataholder.print(this.fsaaLastPassResultFBO.toString());
                    this.checkGLError("FSAA FBO creation");
                    VRShaders.setupFSAA();
                    ShaderHelper.checkGLError("FBO init fsaa shader");
                }
                catch (Exception exception) {
                    dataholder.vrSettings.useFsaa = false;
                    dataholder.vrSettings.saveOptions();
                    System.out.println(exception.getMessage());
                    this.reinitFramebuffers = true;
                    return;
                }
            }
            try {
                minecraft.field_1689 = this.framebufferVrRender;
                VRShaders.setupDepthMask();
                ShaderHelper.checkGLError("init depth shader");
                VRShaders.setupFOVReduction();
                ShaderHelper.checkGLError("init FOV shader");
                ArrayList<class_279> list1 = new ArrayList<class_279>();
                list1.addAll(this.entityShaders.values());
                this.entityShaders.clear();
                class_2960 resourcelocation = new class_2960("shaders/post/entity_outline.json");
                this.entityShaders.put(((RenderTargetExtension)this.framebufferVrRender).getName(), this.createShaderGroup(resourcelocation, this.framebufferVrRender));
                if (list.contains((Object)RenderPass.THIRD)) {
                    this.entityShaders.put(((RenderTargetExtension)this.framebufferMR).getName(), this.createShaderGroup(resourcelocation, this.framebufferMR));
                }
                if (list.contains((Object)RenderPass.CENTER)) {
                    this.entityShaders.put(((RenderTargetExtension)this.framebufferUndistorted).getName(), this.createShaderGroup(resourcelocation, this.framebufferUndistorted));
                }
                this.entityShaders.put(((RenderTargetExtension)this.telescopeFramebufferL).getName(), this.createShaderGroup(resourcelocation, this.telescopeFramebufferL));
                this.entityShaders.put(((RenderTargetExtension)this.telescopeFramebufferR).getName(), this.createShaderGroup(resourcelocation, this.telescopeFramebufferR));
                this.entityShaders.put(((RenderTargetExtension)this.cameraRenderFramebuffer).getName(), this.createShaderGroup(resourcelocation, this.cameraRenderFramebuffer));
                for (class_279 postchain : list1) {
                    postchain.close();
                }
                list1.clear();
                list1.addAll(this.alphaShaders.values());
                this.alphaShaders.clear();
                if (class_310.method_29611()) {
                    class_2960 resourcelocation1 = new class_2960("shaders/post/vrtransparency.json");
                    this.alphaShaders.put(((RenderTargetExtension)this.framebufferVrRender).getName(), this.createShaderGroup(resourcelocation1, this.framebufferVrRender));
                    if (list.contains((Object)RenderPass.THIRD)) {
                        this.alphaShaders.put(((RenderTargetExtension)this.framebufferMR).getName(), this.createShaderGroup(resourcelocation1, this.framebufferMR));
                    }
                    if (list.contains((Object)RenderPass.CENTER)) {
                        this.alphaShaders.put(((RenderTargetExtension)this.framebufferUndistorted).getName(), this.createShaderGroup(resourcelocation1, this.framebufferUndistorted));
                    }
                    this.alphaShaders.put(((RenderTargetExtension)this.telescopeFramebufferL).getName(), this.createShaderGroup(resourcelocation1, this.telescopeFramebufferL));
                    this.alphaShaders.put(((RenderTargetExtension)this.telescopeFramebufferR).getName(), this.createShaderGroup(resourcelocation1, this.telescopeFramebufferR));
                    this.alphaShaders.put(((RenderTargetExtension)this.cameraRenderFramebuffer).getName(), this.createShaderGroup(resourcelocation1, this.cameraRenderFramebuffer));
                }
                for (class_279 postchain1 : list1) {
                    postchain1.close();
                }
                minecraft.field_1773.method_3167(minecraft.method_1560());
            }
            catch (Exception exception1) {
                System.out.println(exception1.getMessage());
                System.exit(-1);
            }
            if (minecraft.field_1755 != null) {
                int l2 = minecraft.method_22683().method_4486();
                int j3 = minecraft.method_22683().method_4502();
                minecraft.field_1755.method_25423(minecraft, l2, j3);
            }
            long i3 = minecraft.method_22683().method_4480() * minecraft.method_22683().method_4507();
            long k3 = i * j * 2;
            if (list.contains((Object)RenderPass.CENTER)) {
                k3 += i3;
            }
            if (list.contains((Object)RenderPass.THIRD)) {
                k3 += i3;
            }
            System.out.println("[Minecrift] New render config:\nOpenVR target width: " + eyew + ", height: " + eyeh + " [" + String.format("%.1f", Float.valueOf((float)(eyew * eyeh) / 1000000.0f)) + " MP]\nRender target width: " + i + ", height: " + j + " [Render scale: " + Math.round(dataholder.vrSettings.renderScaleFactor * 100.0f) + "%, " + String.format("%.1f", Float.valueOf((float)(i * j) / 1000000.0f)) + " MP]\nMain window width: " + minecraft.method_22683().method_4480() + ", height: " + minecraft.method_22683().method_4507() + " [" + String.format("%.1f", Float.valueOf((float)i3 / 1000000.0f)) + " MP]\nTotal shaded pixels per frame: " + String.format("%.1f", Float.valueOf((float)k3 / 1000000.0f)) + " MP (eye stencil not accounted for)");
            this.lastDisplayFBWidth = i;
            this.lastDisplayFBHeight = j;
            this.reinitFramebuffers = false;
            if (Xplat.isModLoaded("iris") || Xplat.isModLoaded("oculus")) {
                IrisHelper.reload();
            }
        }
    }

    public boolean wasDisplayResized() {
        class_310 minecraft = class_310.method_1551();
        int i = minecraft.method_22683().method_4507();
        int j = minecraft.method_22683().method_4480();
        boolean flag = this.dispLastHeight != i || this.dispLastWidth != j;
        this.dispLastHeight = i;
        this.dispLastWidth = j;
        return flag;
    }
}

