/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.provider.openvr_jna;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import jopenvr.HiddenAreaMesh_t;
import jopenvr.HmdMatrix44_t;
import net.minecraft.class_1159;
import net.minecraft.class_3545;
import org.vivecraft.provider.MCVR;
import org.vivecraft.provider.VRRenderer;
import org.vivecraft.provider.openvr_jna.MCOpenVR;
import org.vivecraft.render.RenderConfigException;
import org.vivecraft.render.RenderPass;
import org.vivecraft.utils.Utils;

public class OpenVRStereoRenderer
extends VRRenderer {
    private HiddenAreaMesh_t[] hiddenMeshes = new HiddenAreaMesh_t[2];
    private MCOpenVR openvr;

    public OpenVRStereoRenderer(MCVR vr) {
        super(vr);
        this.openvr = (MCOpenVR)vr;
    }

    @Override
    public class_3545<Integer, Integer> getRenderTextureSizes() {
        if (this.resolution != null) {
            return this.resolution;
        }
        IntByReference intbyreference = new IntByReference();
        IntByReference intbyreference1 = new IntByReference();
        this.openvr.vrsystem.GetRecommendedRenderTargetSize.apply(intbyreference, intbyreference1);
        this.resolution = new class_3545((Object)intbyreference.getValue(), (Object)intbyreference1.getValue());
        System.out.println("OpenVR Render Res " + this.resolution.method_15442() + " x " + this.resolution.method_15441());
        this.ss = this.openvr.getSuperSampling();
        System.out.println("OpenVR Supersampling: " + this.ss);
        for (int i = 0; i < 2; ++i) {
            this.hiddenMeshes[i] = this.openvr.vrsystem.GetHiddenAreaMesh.apply(i, 0);
            this.hiddenMeshes[i].read();
            int j = this.hiddenMeshes[i].unTriangleCount;
            if (j <= 0) {
                System.out.println("No stencil mesh found for eye " + i);
                continue;
            }
            this.hiddenMesheVertecies[i] = new float[this.hiddenMeshes[i].unTriangleCount * 3 * 2];
            new Memory((long)(this.hiddenMeshes[i].unTriangleCount * 3 * 2));
            this.hiddenMeshes[i].pVertexData.getPointer().read(0L, this.hiddenMesheVertecies[i], 0, this.hiddenMesheVertecies[i].length);
            for (int k = 0; k < this.hiddenMesheVertecies[i].length; k += 2) {
                float[] fArray = this.hiddenMesheVertecies[i];
                int n = k;
                fArray[n] = fArray[n] * (float)((Integer)this.resolution.method_15442()).intValue();
                float[] fArray2 = this.hiddenMesheVertecies[i];
                int n2 = k + 1;
                fArray2[n2] = fArray2[n2] * (float)((Integer)this.resolution.method_15441()).intValue();
            }
            System.out.println("Stencil mesh loaded for eye " + i);
        }
        return this.resolution;
    }

    @Override
    public class_1159 getProjectionMatrix(int eyeType, float nearClip, float farClip) {
        if (eyeType == 0) {
            HmdMatrix44_t.ByValue hmdmatrix44_t1 = this.openvr.vrsystem.GetProjectionMatrix.apply(0, nearClip, farClip);
            return Utils.Matrix4fFromOpenVR(hmdmatrix44_t1);
        }
        HmdMatrix44_t.ByValue hmdmatrix44_t = this.openvr.vrsystem.GetProjectionMatrix.apply(1, nearClip, farClip);
        return Utils.Matrix4fFromOpenVR(hmdmatrix44_t);
    }

    @Override
    public String getLastError() {
        return "";
    }

    @Override
    public void createRenderTexture(int lwidth, int lheight) {
        this.LeftEyeTextureId = GlStateManager._genTexture();
        int i = GlStateManager._getInteger((int)32873);
        RenderSystem.bindTexture((int)this.LeftEyeTextureId);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        GlStateManager._texImage2D((int)3553, (int)0, (int)32856, (int)lwidth, (int)lheight, (int)0, (int)6408, (int)5124, null);
        RenderSystem.bindTexture((int)i);
        this.openvr.texType0.handle = Pointer.createConstant((int)this.LeftEyeTextureId);
        this.openvr.texType0.eColorSpace = 1;
        this.openvr.texType0.eType = 1;
        this.openvr.texType0.write();
        this.RightEyeTextureId = GlStateManager._genTexture();
        i = GlStateManager._getInteger((int)32873);
        RenderSystem.bindTexture((int)this.RightEyeTextureId);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        GlStateManager._texImage2D((int)3553, (int)0, (int)32856, (int)lwidth, (int)lheight, (int)0, (int)6408, (int)5124, null);
        RenderSystem.bindTexture((int)i);
        this.openvr.texType1.handle = Pointer.createConstant((int)this.RightEyeTextureId);
        this.openvr.texType1.eColorSpace = 1;
        this.openvr.texType1.eType = 1;
        this.openvr.texType1.write();
    }

    public boolean endFrame(RenderPass eye) {
        return true;
    }

    @Override
    public void endFrame() throws RenderConfigException {
        if (this.openvr.vrCompositor.Submit != null) {
            int i = this.openvr.vrCompositor.Submit.apply(0, this.openvr.texType0, null, 0);
            int j = this.openvr.vrCompositor.Submit.apply(1, this.openvr.texType1, null, 0);
            this.openvr.vrCompositor.PostPresentHandoff.apply();
            if (i + j > 0) {
                throw new RenderConfigException("Compositor Error", "Texture submission error: Left/Right " + OpenVRStereoRenderer.getCompostiorError(i) + "/" + OpenVRStereoRenderer.getCompostiorError(j));
            }
        }
    }

    public static String getCompostiorError(int code) {
        switch (code) {
            case 0: {
                return "None:";
            }
            case 1: {
                return "RequestFailed";
            }
            case 100: {
                return "IncompatibleVersion";
            }
            case 101: {
                return "DoesNotHaveFocus";
            }
            case 102: {
                return "InvalidTexture";
            }
            case 103: {
                return "IsNotSceneApplication";
            }
            case 104: {
                return "TextureIsOnWrongDevice";
            }
            case 105: {
                return "TextureUsesUnsupportedFormat:";
            }
            case 106: {
                return "SharedTexturesNotSupported";
            }
            case 107: {
                return "IndexOutOfRange";
            }
            case 108: {
                return "AlreadySubmitted:";
            }
        }
        return "Unknown";
    }

    @Override
    public boolean providesStencilMask() {
        return true;
    }

    @Override
    public float[] getStencilMask(RenderPass eye) {
        if (this.hiddenMesheVertecies != null && (eye == RenderPass.LEFT || eye == RenderPass.RIGHT)) {
            return eye == RenderPass.LEFT ? this.hiddenMesheVertecies[0] : this.hiddenMesheVertecies[1];
        }
        return null;
    }

    @Override
    public String getName() {
        return "OpenVR";
    }

    @Override
    public boolean isInitialized() {
        return this.vr.initSuccess;
    }

    @Override
    public String getinitError() {
        return this.vr.initStatus;
    }
}

