/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.render;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import net.minecraft.class_243;
import org.vivecraft.render.GLUtils;
import org.vivecraft.utils.lwjgl.Matrix4f;
import org.vivecraft.utils.lwjgl.Quaternion;

public class QuaternionHelper {
    public static final Quaternion IDENTITY_QUATERNION = new Quaternion().setIdentity();

    public static Quaternion clone(Quaternion q1) {
        return new Quaternion(q1.x, q1.y, q1.z, q1.w);
    }

    public static Quaternion pow(Quaternion q1, float power) {
        Quaternion quaternion = QuaternionHelper.clone(q1);
        float f = QuaternionHelper.magnitude(quaternion);
        class_243 vec3 = new class_243((double)quaternion.x, (double)quaternion.y, (double)quaternion.z).method_1029();
        Quaternion quaternion1 = QuaternionHelper.exp(QuaternionHelper.scalarMultiply(new Quaternion((float)vec3.field_1352, (float)vec3.field_1351, (float)vec3.field_1350, 0.0f), (float)((double)power * Math.acos(quaternion.w / f))));
        return QuaternionHelper.scalarMultiply(quaternion1, (float)Math.pow(f, power));
    }

    public static Quaternion mul(Quaternion left, Quaternion right) {
        Quaternion quaternion = IDENTITY_QUATERNION;
        Quaternion.mul(left, right, quaternion);
        return quaternion;
    }

    public static Quaternion exp(Quaternion input) {
        float f = input.w;
        class_243 vec3 = new class_243((double)input.x, (double)input.y, (double)input.z);
        float f1 = (float)(Math.exp(f) * Math.cos(vec3.method_1033()));
        class_243 vec31 = new class_243(Math.exp(f) * vec3.method_1029().field_1352 * (double)((float)Math.sin(vec3.method_1033())), Math.exp(f) * vec3.method_1029().field_1351 * (double)((float)Math.sin(vec3.method_1033())), Math.exp(f) * vec3.method_1029().field_1350 * (double)((float)Math.sin(vec3.method_1033())));
        return new Quaternion((float)vec31.field_1352, (float)vec31.field_1351, (float)vec31.field_1350, f1);
    }

    public static float magnitude(Quaternion input) {
        return (float)Math.sqrt(input.x * input.x + input.y * input.y + input.z * input.z + input.w * input.w);
    }

    public static Quaternion scalarMultiply(Quaternion input, float scalar) {
        return new Quaternion(input.x * scalar, input.y * scalar, input.z * scalar, input.w * scalar);
    }

    public static Quaternion slerp(Quaternion q1, Quaternion q2, float t) {
        Quaternion quaternion = new Quaternion();
        if (QuaternionHelper.isEqual(q1, q2)) {
            return q1;
        }
        float f = q1.x * q2.x + q1.y * q2.y + q1.z * q2.z + q1.w * q2.w;
        if (f < 0.0f) {
            q2 = QuaternionHelper.conjugate(q2);
            f = -f;
        }
        float f1 = 1.0f - t;
        float f2 = 1.0f - t;
        float f3 = t;
        if (1.0f - f > 0.1f) {
            float f4 = (float)Math.acos(f);
            float f5 = (float)Math.sin(f4);
            f2 = (float)Math.sin(f4 * f1) / f5;
            f3 = (float)Math.sin(f4 * t) / f5;
        }
        quaternion.x = f2 * q1.x + f3 * q2.x;
        quaternion.y = f2 * q1.y + f3 * q2.y;
        quaternion.z = f2 * q1.z + f3 * q2.z;
        quaternion.w = f2 * q1.w + f3 * q2.w;
        return quaternion;
    }

    public static Quaternion conjugate(Quaternion q1) {
        return new Quaternion(-q1.x, -q1.y, -q1.z, q1.w);
    }

    public static boolean isEqual(Quaternion q1, Quaternion q2) {
        return q1.x == q2.x && q1.y == q2.y && q1.z == q2.z && q1.w == q2.w;
    }

    public static Quaternion slerp2(Quaternion a, Quaternion b, float t) {
        Quaternion quaternion = new Quaternion();
        float f = a.x * b.x + a.y * b.y + a.z * b.z + a.w * b.w;
        float f1 = 1.0f - t;
        if (f >= 0.95f) {
            quaternion.x = a.x * f1 + b.x * t;
            quaternion.y = a.y * f1 + b.y * t;
            quaternion.z = a.z * f1 + b.z * t;
            quaternion.w = a.w * f1 + b.w * t;
            return quaternion;
        }
        if (f <= -0.99f) {
            quaternion.x = 0.5f * (a.x + b.x);
            quaternion.y = 0.5f * (a.y + b.y);
            quaternion.z = 0.5f * (a.z + b.z);
            quaternion.w = 0.5f * (a.w + b.w);
            return quaternion;
        }
        float f2 = (float)Math.sqrt(1.0f - f * f);
        float f3 = (float)Math.acos(f);
        float f4 = (float)Math.sin(f1 * f3) / f2;
        float f5 = (float)Math.sin(t * f3) / f2;
        quaternion.x = a.x * f4 + b.x * f5;
        quaternion.y = a.y * f4 + b.y * f5;
        quaternion.z = a.z * f4 + b.z * f5;
        quaternion.w = a.w * f4 + b.w * f5;
        return quaternion;
    }

    public static Quaternion slerp1(Quaternion q1, Quaternion q2, float t1) {
        Quaternion quaternion = new Quaternion();
        if (q1.x == q2.x && q1.y == q2.y && q1.z == q2.z && q1.w == q2.w) {
            quaternion.set(q1);
            return quaternion;
        }
        float f = q1.x * q2.x + q1.y * q2.y + q1.z * q2.z + q1.w * q2.w;
        if (f < 0.0f) {
            q2.x = -q2.x;
            q2.y = -q2.y;
            q2.z = -q2.z;
            q2.w = -q2.w;
            f = -f;
        }
        float f1 = 1.0f - t1;
        float f2 = t1;
        if (1.0f - f > 0.1f) {
            float f3 = (float)Math.acos(f);
            float f4 = 1.0f / (float)Math.sin(f3);
            f1 = (float)Math.sin((1.0f - t1) * f3) * f4;
            f2 = (float)Math.sin(t1 * f3) * f4;
        }
        quaternion.x = f1 * q1.x + f2 * q2.x;
        quaternion.y = f1 * q1.y + f2 * q2.y;
        quaternion.z = f1 * q1.z + f2 * q2.z;
        quaternion.w = f1 * q1.w + f2 * q2.w;
        return quaternion;
    }

    public static Matrix4f quatToMatrix4f(Quaternion q) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.m00 = 1.0f - 2.0f * (q.getY() * q.getY() + q.getZ() * q.getZ());
        matrix4f.m01 = 2.0f * (q.getX() * q.getY() + q.getZ() * q.getW());
        matrix4f.m02 = 2.0f * (q.getX() * q.getZ() - q.getY() * q.getW());
        matrix4f.m03 = 0.0f;
        matrix4f.m10 = 2.0f * (q.getX() * q.getY() - q.getZ() * q.getW());
        matrix4f.m11 = 1.0f - 2.0f * (q.getX() * q.getX() + q.getZ() * q.getZ());
        matrix4f.m12 = 2.0f * (q.getZ() * q.getY() + q.getX() * q.getW());
        matrix4f.m13 = 0.0f;
        matrix4f.m20 = 2.0f * (q.getX() * q.getZ() + q.getY() * q.getW());
        matrix4f.m21 = 2.0f * (q.getY() * q.getZ() - q.getX() * q.getW());
        matrix4f.m22 = 1.0f - 2.0f * (q.getX() * q.getX() + q.getY() * q.getY());
        matrix4f.m23 = 0.0f;
        matrix4f.m30 = 0.0f;
        matrix4f.m31 = 0.0f;
        matrix4f.m32 = 0.0f;
        matrix4f.m33 = 1.0f;
        return matrix4f;
    }

    public static FloatBuffer quatToMatrix4fFloatBuf(Quaternion q) {
        FloatBuffer floatbuffer = GLUtils.createFloatBuffer(16);
        Matrix4f matrix4f = QuaternionHelper.quatToMatrix4f(q);
        matrix4f.store(floatbuffer);
        ((Buffer)floatbuffer).flip();
        return floatbuffer;
    }
}

