/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.vivecraft.server.config.BooleanValue;
import org.vivecraft.server.config.DoubleValue;
import org.vivecraft.server.config.IntValue;
import org.vivecraft.server.config.StringValue;

public class ServerConfig {
    public static BooleanValue vrOnly = new BooleanValue("vrOnly", false);
    public static DoubleValue vrOnlyKickDelay = new DoubleValue("vrOnlyKickDelay", 20.0);
    public static BooleanValue printMoney = new BooleanValue("printMoney", false);
    public static StringValue vrOnlyKickMessage = new StringValue("vrOnlyKickMessage", "");
    public static BooleanValue enableJoinMessages = new BooleanValue("enableJoinMessages", true);
    public static StringValue joinMessageVR = new StringValue("joinMessageVR", "");
    public static StringValue joinMessageNonVR = new StringValue("joinMessageNonVR", "");
    public static DoubleValue creeperSwellDistance = new DoubleValue("creeperSwellDistance", 2.0);
    public static BooleanValue vrVsVR = new BooleanValue("vrVsVR", true);
    public static BooleanValue vrVsSeatedVR = new BooleanValue("vrVsSeatedVR", true);
    public static BooleanValue vrVsNonVR = new BooleanValue("vrVsNonVR", true);
    public static BooleanValue seatedVrVsSeatedVR = new BooleanValue("seatedVrVsSeatedVR", true);
    public static BooleanValue seatedVrVsNonVR = new BooleanValue("seatedVrVsNonVR", true);
    public static DoubleValue bowStandingMul = new DoubleValue("bowStandingMul", 2.0);
    public static DoubleValue bowSeatedMul = new DoubleValue("bowSeatedMul", 1.0);
    public static DoubleValue bowStandingHeadshotMul = new DoubleValue("bowStandingHeadshotMul", 3.0);
    public static DoubleValue bowSeatedHeadshotMul = new DoubleValue("bowSeatedHeadshotMul", 2.0);
    public static BooleanValue climbeyEnabled = new BooleanValue("climbeyEnabled", false);
    public static StringValue blockListMode = new StringValue("blockListMode", "");
    public static List<? extends String> blockList;
    public static BooleanValue crawlingEnabled;
    public static BooleanValue teleportEnabled;
    public static BooleanValue teleportLimited;
    public static IntValue teleportLimitUp;
    public static IntValue teleportLimitDown;
    public static IntValue teleportLimitHoriz;
    public static BooleanValue worldScaleLimited;
    public static DoubleValue worldScaleMin;
    public static DoubleValue worldScaleMax;
    static Properties properties;

    public static void loadConfig(MinecraftServer server) {
        properties = new Properties();
        try {
            Path file = server.method_27050(class_5218.field_24188).resolve("serverconfigs").resolve("vivecraft-serverconfig.properties");
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createFile(file, new FileAttribute[0]);
            }
            properties.load(Files.newInputStream(file, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<? extends String> getList(String blockList, List<? extends String> objects) {
        String[] array = properties.getProperty(blockList, "").replace(" ", "").split(",");
        return Arrays.asList(array);
    }

    static boolean getBoolean(String value, Boolean defaultValue) {
        return Boolean.parseBoolean(properties.getProperty(value, String.valueOf(defaultValue)));
    }

    static double getDouble(String value, double defaultValue) {
        return Double.parseDouble(properties.getProperty(value, String.valueOf(defaultValue)));
    }

    static int getInt(String value, int defaultValue) {
        return Integer.parseInt(properties.getProperty(value, String.valueOf(defaultValue)));
    }

    static String getString(String value, String defaultValue) {
        return properties.getProperty(value, String.valueOf(defaultValue));
    }

    static {
        crawlingEnabled = new BooleanValue("crawlingEnabled", false);
        teleportEnabled = new BooleanValue("teleportEnabled", false);
        teleportLimited = new BooleanValue("teleportLimited", true);
        teleportLimitUp = new IntValue("teleportLimitUp", 5);
        teleportLimitDown = new IntValue("teleportLimitDown", 10);
        teleportLimitHoriz = new IntValue("teleportLimitHoriz", 7);
        worldScaleLimited = new BooleanValue("worldScaleLimited", false);
        worldScaleMin = new DoubleValue("worldScaleMin", 5.0);
        worldScaleMax = new DoubleValue("worldScaleMax", 5.0);
    }
}

