/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients.fluid;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.TagUtil;
import net.minecraft.class_1058;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class FluidIngredientHelper<T>
implements IIngredientHelper<T> {
    private final ISubtypeManager subtypeManager;
    private final IColorHelper colorHelper;
    private final IPlatformFluidHelperInternal<T> platformFluidHelper;
    private final IPlatformRegistry<class_3611> registry;
    private final IIngredientTypeWithSubtypes<class_3611, T> fluidType;

    public FluidIngredientHelper(ISubtypeManager subtypeManager, IColorHelper colorHelper, IPlatformFluidHelperInternal<T> platformFluidHelper) {
        this.subtypeManager = subtypeManager;
        this.colorHelper = colorHelper;
        this.platformFluidHelper = platformFluidHelper;
        this.registry = Services.PLATFORM.getRegistry(class_2378.field_25103);
        this.fluidType = platformFluidHelper.getFluidIngredientType();
    }

    @Override
    public IIngredientType<T> getIngredientType() {
        return this.platformFluidHelper.getFluidIngredientType();
    }

    @Override
    public String getDisplayName(T ingredient) {
        class_2561 displayName = this.platformFluidHelper.getDisplayName(ingredient);
        return displayName.getString();
    }

    @Override
    public String getUniqueId(T ingredient, UidContext context) {
        class_3611 fluid = this.fluidType.getBase(ingredient);
        class_2960 registryName = this.getRegistryName(ingredient, fluid);
        StringBuilder result = new StringBuilder().append("fluid:").append(registryName);
        String subtypeInfo = this.subtypeManager.getSubtypeInfo(this.fluidType, ingredient, context);
        if (!subtypeInfo.isEmpty()) {
            result.append(":");
            result.append(subtypeInfo);
        }
        return result.toString();
    }

    @Override
    public String getWildcardId(T ingredient) {
        class_3611 fluid = this.fluidType.getBase(ingredient);
        class_2960 registryName = this.getRegistryName(ingredient, fluid);
        return "fluid:" + registryName;
    }

    @Override
    public Iterable<Integer> getColors(T ingredient) {
        return this.platformFluidHelper.getStillFluidSprite(ingredient).map(fluidStillSprite -> {
            int renderColor = this.platformFluidHelper.getColorTint(ingredient);
            return this.colorHelper.getColors((class_1058)fluidStillSprite, renderColor, 1);
        }).orElseGet(List::of);
    }

    @Override
    public class_2960 getResourceLocation(T ingredient) {
        class_3611 fluid = this.fluidType.getBase(ingredient);
        return this.getRegistryName(ingredient, fluid);
    }

    private class_2960 getRegistryName(T ingredient, class_3611 fluid) {
        return this.registry.getRegistryName(fluid).orElseThrow(() -> {
            String ingredientInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("null registry name for: " + ingredientInfo);
        });
    }

    @Override
    public class_1799 getCheatItemStack(T ingredient) {
        class_3611 fluid = this.fluidType.getBase(ingredient);
        class_1792 filledBucket = fluid.method_15774();
        return new class_1799((class_1935)filledBucket);
    }

    @Override
    public T copyIngredient(T ingredient) {
        return this.platformFluidHelper.copy(ingredient);
    }

    @Override
    public T normalizeIngredient(T ingredient) {
        return this.platformFluidHelper.normalize(ingredient);
    }

    @Override
    @Deprecated
    public Collection<class_2960> getTags(T ingredient) {
        return this.getTagStream(ingredient).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Stream<class_2960> getTagStream(T ingredient) {
        class_3611 fluid = this.fluidType.getBase(ingredient);
        return class_2378.field_11154.method_29113((Object)fluid).flatMap(arg_0 -> ((class_2348)class_2378.field_11154).method_40264(arg_0)).map(class_6880::method_40228).orElse(Stream.of(new class_6862[0])).map(class_6862::comp_327);
    }

    @Override
    public String getErrorInfo(@Nullable T ingredient) {
        if (ingredient == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(ingredient.getClass());
        class_3611 fluid = this.fluidType.getBase(ingredient);
        if (fluid != null) {
            class_2561 displayName = this.platformFluidHelper.getDisplayName(ingredient);
            toStringHelper.add("Fluid", (Object)displayName.getString());
        } else {
            toStringHelper.add("Fluid", (Object)"null");
        }
        toStringHelper.add("Amount", this.platformFluidHelper.getAmount(ingredient));
        this.platformFluidHelper.getTag(ingredient).ifPresent(tag -> toStringHelper.add("Tag", tag));
        return toStringHelper.toString();
    }

    @Override
    public Optional<class_2960> getTagEquivalent(Collection<T> ingredients) {
        return TagUtil.getTagEquivalent(ingredients, this.fluidType::getBase, () -> ((class_2348)class_2378.field_11154).method_40272());
    }
}

