/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.encryption;

import com.aizistral.nochatreports.encryption.Encryption;
import it.unimi.dsi.fastutil.chars.Char2CharArrayMap;
import it.unimi.dsi.fastutil.chars.Char2CharMap;
import it.unimi.dsi.fastutil.chars.Char2CharMaps;
import it.unimi.dsi.fastutil.chars.CharIterator;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Arrays;

public abstract class Encryptor<T extends Encryption> {
    protected static final SecureRandom RANDOM = new SecureRandom();
    protected static final Char2CharMap BASE64R_SHIFTS = Encryptor.createBase64RShifts();
    protected static final Char2CharMap BASE64R_SHIFTS_REVERSE = Encryptor.createBase64RShiftsReverse();

    protected Encryptor() {
    }

    public abstract String encrypt(String var1);

    public abstract String decrypt(String var1);

    public abstract T getAlgorithm();

    public abstract String getKey();

    protected static String shiftBase64R(String string) {
        char[] chars = Encryptor.ensureUTF8(string).toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = BASE64R_SHIFTS.get(chars[i]);
        }
        return new String(chars);
    }

    protected static String unshiftBase64R(String string) {
        char[] chars = Encryptor.ensureUTF8(string).toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = BASE64R_SHIFTS_REVERSE.get(chars[i]);
        }
        return new String(chars);
    }

    protected static byte[] toBytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    protected static String fromBytes(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    protected static String ensureUTF8(String string) {
        return Encryptor.fromBytes(Encryptor.toBytes(string));
    }

    protected static String encodeBase64R(String string) {
        return Encryptor.encodeBase64R(Encryptor.toBytes(string));
    }

    protected static String encodeBase64R(byte[] bytes) {
        return Encryptor.shiftBase64R(Encryptor.fromBytes(Encryption.BASE64_ENCODER.encode(bytes)));
    }

    protected static byte[] encodeBase64RBytes(String string) {
        return Encryptor.toBytes(Encryptor.encodeBase64R(Encryptor.toBytes(string)));
    }

    protected static String decodeBase64R(String string) {
        return Encryptor.fromBytes(Encryptor.decodeBase64RBytes(string));
    }

    protected static byte[] decodeBase64RBytes(String string) {
        return Encryption.BASE64_DECODER.decode(Encryptor.toBytes(Encryptor.unshiftBase64R(string)));
    }

    protected static String encodeBinaryKey(byte[] key) {
        return Encryptor.fromBytes(Encryption.BASE64_ENCODER.encode(key));
    }

    protected static byte[] decodeBinaryKey(String key) throws InvalidKeyException {
        try {
            return Encryption.BASE64_DECODER.decode(Encryptor.toBytes(key));
        }
        catch (Exception ex) {
            throw new InvalidKeyException(ex);
        }
    }

    protected static byte[] mergeBytes(byte[] array1, byte[] array2) {
        byte[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    private static Char2CharMap createBase64RShiftsReverse() {
        Char2CharMap map = Encryptor.createBase64RShifts();
        Char2CharArrayMap reverse = new Char2CharArrayMap(64);
        CharIterator charIterator = map.keySet().iterator();
        while (charIterator.hasNext()) {
            char ch = ((Character)charIterator.next()).charValue();
            reverse.put(map.get(ch), ch);
        }
        return Char2CharMaps.unmodifiable((Char2CharMap)reverse);
    }

    private static Char2CharMap createBase64RShifts() {
        Char2CharArrayMap map = new Char2CharArrayMap(64);
        map.put('A', '!');
        map.put('B', '\"');
        map.put('C', '#');
        map.put('D', '$');
        map.put('E', '%');
        map.put('F', '\u00bc');
        map.put('G', '\'');
        map.put('H', '(');
        map.put('I', ')');
        map.put('J', ',');
        map.put('K', '-');
        map.put('L', '.');
        map.put('M', ':');
        map.put('N', ';');
        map.put('O', '<');
        map.put('P', '=');
        map.put('Q', '>');
        map.put('R', '?');
        map.put('S', '@');
        map.put('T', '[');
        map.put('U', '\\');
        map.put('V', ']');
        map.put('W', '^');
        map.put('X', '_');
        map.put('Y', '`');
        map.put('Z', '{');
        map.put('a', '|');
        map.put('b', '}');
        map.put('c', '~');
        map.put('d', '\u00a1');
        map.put('e', '\u00a2');
        map.put('f', '\u00a3');
        map.put('g', '\u00a4');
        map.put('h', '\u00a5');
        map.put('i', '\u00a6');
        map.put('j', '\u00a8');
        map.put('k', '\u00a9');
        map.put('l', '\u00aa');
        map.put('m', '\u00ab');
        map.put('n', '\u00ac');
        map.put('o', '\u00ae');
        map.put('p', '\u00af');
        map.put('q', '\u00b0');
        map.put('r', '\u00b1');
        map.put('s', '\u00b2');
        map.put('t', '\u00b3');
        map.put('u', '\u00b5');
        map.put('v', '\u00b6');
        map.put('w', '\u00b7');
        map.put('x', '\u00b8');
        map.put('y', '\u00b9');
        map.put('z', '\u00ba');
        map.put('0', '0');
        map.put('1', '1');
        map.put('2', '2');
        map.put('3', '3');
        map.put('4', '4');
        map.put('5', '5');
        map.put('6', '6');
        map.put('7', '7');
        map.put('8', '8');
        map.put('9', '9');
        map.put('+', '+');
        map.put('/', '\u00bb');
        map.put('=', '\u00bf');
        return Char2CharMaps.unmodifiable((Char2CharMap)map);
    }
}

