/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp;

import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterUnsafe;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import net.coderbot.iris.compat.sodium.impl.block_context.BlockContextHolder;
import net.coderbot.iris.compat.sodium.impl.block_context.ContextAwareVertexWriter;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisModelVertexFormats;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.QuadViewTerrain;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.XHFPModelVertexType;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.ExtendedDataHelper;
import net.coderbot.iris.vertices.NormalHelper;
import org.lwjgl.system.MemoryUtil;

public class XHFPModelVertexBufferWriterUnsafe
extends VertexBufferWriterUnsafe
implements ModelVertexSink,
ContextAwareVertexWriter {
    private final QuadViewTerrain.QuadViewTerrainUnsafe quad = new QuadViewTerrain.QuadViewTerrainUnsafe();
    private final Vector3f normal = new Vector3f();
    private BlockContextHolder contextHolder;
    private int vertexCount;
    private float uSum;
    private float vSum;

    public XHFPModelVertexBufferWriterUnsafe(VertexBufferView vertexBufferView) {
        super(vertexBufferView, (BufferVertexType)IrisModelVertexFormats.MODEL_VERTEX_XHFP);
    }

    @Override
    public void copyQuadAndFlipNormal() {
        this.ensureCapacity(4);
        MemoryUtil.memCopy((long)(this.writePointer - 160L), (long)this.writePointer, (long)160L);
        int n = MemoryUtil.memGetInt((long)(this.writePointer + 28L));
        int n2 = NormalHelper.invertPackedNormal(n);
        MemoryUtil.memPutInt((long)(this.writePointer + 28L), (int)n2);
        MemoryUtil.memPutInt((long)(this.writePointer + 28L + 40L), (int)n2);
        MemoryUtil.memPutInt((long)(this.writePointer + 28L + 80L), (int)n2);
        MemoryUtil.memPutInt((long)(this.writePointer + 28L + 120L), (int)n2);
        for (int i = 0; i < 4; ++i) {
            this.advance();
        }
        this.flush();
    }

    public void writeVertex(float f, float f2, float f3, int n, float f4, float f5, int n2, int n3) {
        this.uSum += f4;
        this.vSum += f5;
        this.writeQuadInternal(f, f2, f3, n, f4, f5, n2, this.contextHolder.blockId, this.contextHolder.renderType, n3, this.contextHolder.ignoreMidBlock ? 0 : ExtendedDataHelper.computeMidBlock(f, f2, f3, this.contextHolder.localPosX, this.contextHolder.localPosY, this.contextHolder.localPosZ));
    }

    private void writeQuadInternal(float f, float f2, float f3, int n, float f4, float f5, int n2, short s, short s2, int n3, int n4) {
        long l = this.writePointer;
        ++this.vertexCount;
        MemoryUtil.memPutShort((long)(l + 0L), (short)XHFPModelVertexType.encodePosition(f));
        MemoryUtil.memPutShort((long)(l + 2L), (short)XHFPModelVertexType.encodePosition(f2));
        MemoryUtil.memPutShort((long)(l + 4L), (short)XHFPModelVertexType.encodePosition(f3));
        MemoryUtil.memPutShort((long)(l + 6L), (short)((short)n3));
        MemoryUtil.memPutInt((long)(l + 8L), (int)n);
        MemoryUtil.memPutShort((long)(l + 12L), (short)XHFPModelVertexType.encodeBlockTexture(f4));
        MemoryUtil.memPutShort((long)(l + 14L), (short)XHFPModelVertexType.encodeBlockTexture(f5));
        MemoryUtil.memPutInt((long)(l + 16L), (int)n2);
        MemoryUtil.memPutShort((long)(l + 32L), (short)s);
        MemoryUtil.memPutShort((long)(l + 34L), (short)s2);
        MemoryUtil.memPutInt((long)(l + 36L), (int)n4);
        if (this.vertexCount == 4) {
            this.vertexCount = 0;
            this.uSum *= 0.25f;
            this.vSum *= 0.25f;
            short s3 = XHFPModelVertexType.encodeBlockTexture(this.uSum);
            short s4 = XHFPModelVertexType.encodeBlockTexture(this.vSum);
            MemoryUtil.memPutShort((long)(l + 20L), (short)s3);
            MemoryUtil.memPutShort((long)(l + 20L - 40L), (short)s3);
            MemoryUtil.memPutShort((long)(l + 20L - 80L), (short)s3);
            MemoryUtil.memPutShort((long)(l + 20L - 120L), (short)s3);
            MemoryUtil.memPutShort((long)(l + 22L), (short)s4);
            MemoryUtil.memPutShort((long)(l + 22L - 40L), (short)s4);
            MemoryUtil.memPutShort((long)(l + 22L - 80L), (short)s4);
            MemoryUtil.memPutShort((long)(l + 22L - 120L), (short)s4);
            this.uSum = 0.0f;
            this.vSum = 0.0f;
            this.quad.setup(l, 40);
            NormalHelper.computeFaceNormal(this.normal, this.quad);
            int n5 = NormalHelper.packNormal(this.normal, 0.0f);
            MemoryUtil.memPutInt((long)(l + 28L), (int)n5);
            MemoryUtil.memPutInt((long)(l + 28L - 40L), (int)n5);
            MemoryUtil.memPutInt((long)(l + 28L - 80L), (int)n5);
            MemoryUtil.memPutInt((long)(l + 28L - 120L), (int)n5);
            int n6 = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.quad);
            MemoryUtil.memPutInt((long)(l + 24L), (int)n6);
            MemoryUtil.memPutInt((long)(l + 24L - 40L), (int)n6);
            MemoryUtil.memPutInt((long)(l + 24L - 80L), (int)n6);
            MemoryUtil.memPutInt((long)(l + 24L - 120L), (int)n6);
        }
        this.advance();
    }

    @Override
    public void iris$setContextHolder(BlockContextHolder blockContextHolder) {
        this.contextHolder = blockContextHolder;
    }
}

