/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights;

import dev.lambdaurora.lambdynlights.DynamicLightsMode;
import dev.lambdaurora.lambdynlights.ExplosiveLightingMode;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.shadow.nightconfig.core.file.FileConfig;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import org.jetbrains.annotations.NotNull;

public class DynamicLightsConfig {
    private static final DynamicLightsMode DEFAULT_DYNAMIC_LIGHTS_MODE = DynamicLightsMode.FANCY;
    private static final boolean DEFAULT_ENTITIES_LIGHT_SOURCE = true;
    private static final boolean DEFAULT_BLOCK_ENTITIES_LIGHT_SOURCE = true;
    private static final boolean DEFAULT_WATER_SENSITIVE_CHECK = true;
    private static final ExplosiveLightingMode DEFAULT_CREEPER_LIGHTING_MODE = ExplosiveLightingMode.SIMPLE;
    private static final ExplosiveLightingMode DEFAULT_TNT_LIGHTING_MODE = ExplosiveLightingMode.OFF;
    public static final Path CONFIG_FILE_PATH = Paths.get("config/lambdynlights.toml", new String[0]);
    protected final FileConfig config;
    private final LambDynLights mod;
    private DynamicLightsMode dynamicLightsMode;
    private ExplosiveLightingMode creeperLightingMode;
    private ExplosiveLightingMode tntLightingMode;
    public final SpruceOption dynamicLightsModeOption = new SpruceCyclingOption("lambdynlights.option.mode", amount -> this.setDynamicLightsMode(this.dynamicLightsMode.next()), option -> option.getDisplayText(this.dynamicLightsMode.getTranslatedText()), (class_2561)new class_2588("lambdynlights.tooltip.mode.1").method_10852((class_2561)new class_2585("\n")).method_10852((class_2561)new class_2588("lambdynlights.tooltip.mode.2", new Object[]{DynamicLightsMode.FASTEST.getTranslatedText(), DynamicLightsMode.FAST.getTranslatedText()})).method_10852((class_2561)new class_2585("\n")).method_10852((class_2561)new class_2588("lambdynlights.tooltip.mode.3", new Object[]{DynamicLightsMode.FANCY.getTranslatedText()})));

    public DynamicLightsConfig(@NotNull LambDynLights mod) {
        this.mod = mod;
        this.config = FileConfig.builder(CONFIG_FILE_PATH).concurrent().defaultResource("/lambdynlights.toml").autosave().build();
    }

    public void load() {
        this.config.load();
        String dynamicLightsModeValue = this.config.getOrElse("mode", DEFAULT_DYNAMIC_LIGHTS_MODE.getName());
        this.dynamicLightsMode = DynamicLightsMode.byId(dynamicLightsModeValue).orElse(DEFAULT_DYNAMIC_LIGHTS_MODE);
        this.creeperLightingMode = ExplosiveLightingMode.byId(this.config.getOrElse("light_sources.creeper", DEFAULT_CREEPER_LIGHTING_MODE.getName())).orElse(DEFAULT_CREEPER_LIGHTING_MODE);
        this.tntLightingMode = ExplosiveLightingMode.byId(this.config.getOrElse("light_sources.tnt", DEFAULT_TNT_LIGHTING_MODE.getName())).orElse(DEFAULT_TNT_LIGHTING_MODE);
        this.mod.log("Configuration loaded.");
    }

    public void save() {
        this.config.save();
    }

    public void reset() {
        this.setDynamicLightsMode(DEFAULT_DYNAMIC_LIGHTS_MODE);
        this.setEntitiesLightSource(true);
        this.setBlockEntitiesLightSource(true);
        this.setWaterSensitiveCheck(true);
        this.setCreeperLightingMode(DEFAULT_CREEPER_LIGHTING_MODE);
        this.setTntLightingMode(DEFAULT_TNT_LIGHTING_MODE);
    }

    public DynamicLightsMode getDynamicLightsMode() {
        return this.dynamicLightsMode;
    }

    public void setDynamicLightsMode(@NotNull DynamicLightsMode mode) {
        if (!mode.isEnabled()) {
            this.mod.clearLightSources();
        }
        this.dynamicLightsMode = mode;
        this.config.set("mode", (Object)mode.getName());
    }

    public boolean hasEntitiesLightSource() {
        return this.config.getOrElse("light_sources.entities", Boolean.valueOf(true));
    }

    public void setEntitiesLightSource(boolean enabled) {
        if (!enabled) {
            this.mod.removeEntitiesLightSource();
        }
        this.config.set("light_sources.entities", (Object)enabled);
    }

    public boolean hasBlockEntitiesLightSource() {
        return this.config.getOrElse("light_sources.block_entities", Boolean.valueOf(true));
    }

    public void setBlockEntitiesLightSource(boolean enabled) {
        if (!enabled) {
            this.mod.removeBlockEntitiesLightSource();
        }
        this.config.set("light_sources.block_entities", (Object)enabled);
    }

    public boolean hasWaterSensitiveCheck() {
        return this.config.getOrElse("light_sources.water_sensitive_check", Boolean.valueOf(true));
    }

    public void setWaterSensitiveCheck(boolean waterSensitive) {
        this.config.set("light_sources.water_sensitive_check", (Object)waterSensitive);
    }

    public ExplosiveLightingMode getCreeperLightingMode() {
        return this.creeperLightingMode;
    }

    public void setCreeperLightingMode(@NotNull ExplosiveLightingMode lightingMode) {
        this.creeperLightingMode = lightingMode;
        if (!lightingMode.isEnabled()) {
            this.mod.removeCreeperLightSources();
        }
        this.config.set("light_sources.creeper", (Object)lightingMode.getName());
    }

    public ExplosiveLightingMode getTntLightingMode() {
        return this.tntLightingMode;
    }

    public void setTntLightingMode(@NotNull ExplosiveLightingMode lightingMode) {
        this.tntLightingMode = lightingMode;
        if (!lightingMode.isEnabled()) {
            this.mod.removeTntLightSources();
        }
        this.config.set("light_sources.tnt", (Object)lightingMode.getName());
    }
}

