/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.infohud.IInfoHudRenderer;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_638;

public abstract class TaskPasteSchematicPerChunkBase
extends TaskBase
implements IInfoHudRenderer {
    protected final ArrayListMultimap<class_1923, IntBoundingBox> boxesInChunks = ArrayListMultimap.create();
    protected final List<class_1923> chunks = new ArrayList<class_1923>();
    private final HashSet<class_1923> individualChunks = new HashSet();
    private final Collection<SchematicPlacement> placements;
    private final LayerRange layerRange;
    protected final PositionUtils.ChunkPosComparator comparator;
    protected final boolean changedBlockOnly;
    protected final ReplaceBehavior replace;

    public TaskPasteSchematicPerChunkBase(Collection<SchematicPlacement> placements, LayerRange range, boolean changedBlocksOnly) {
        this.placements = placements;
        this.layerRange = range;
        this.changedBlockOnly = changedBlocksOnly;
        this.comparator = new PositionUtils.ChunkPosComparator();
        this.comparator.setClosestFirst(true);
        this.replace = (ReplaceBehavior)Configs.Generic.PASTE_REPLACE_BEHAVIOR.getOptionListValue();
        this.name = StringUtils.translate((String)"litematica.gui.label.task_name.paste", (Object[])new Object[0]);
    }

    @Override
    public void init() {
        for (SchematicPlacement placement : this.placements) {
            this.addPlacement(placement, this.layerRange);
        }
        this.chunks.addAll(this.individualChunks);
        this.sortChunkList();
        InfoHud.getInstance().addInfoHudRenderer(this, true);
        this.updateInfoHudLines();
    }

    protected void addPlacement(SchematicPlacement placement, LayerRange range) {
        Set<class_1923> touchedChunks = placement.getTouchedChunks();
        for (class_1923 pos : touchedChunks) {
            int count = 0;
            for (IntBoundingBox box : placement.getBoxesWithinChunk(pos.field_9181, pos.field_9180).values()) {
                if ((box = this.getClampedBox(box, range)) == null) continue;
                this.boxesInChunks.put((Object)pos, (Object)box);
                ++count;
            }
            if (count <= 0) continue;
            this.individualChunks.add(pos);
            this.onChunkAddedForHandling(pos, placement);
        }
    }

    @Nullable
    public IntBoundingBox getClampedBox(IntBoundingBox box, LayerRange range) {
        return this.getClampedArea(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ, range);
    }

    @Nullable
    public IntBoundingBox getClampedArea(class_2338 posMin, class_2338 posMax, LayerRange range) {
        return this.getClampedArea(posMin.method_10263(), posMin.method_10264(), posMin.method_10260(), posMax.method_10263(), posMax.method_10264(), posMax.method_10260(), range);
    }

    @Nullable
    public IntBoundingBox getClampedArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, LayerRange range) {
        if (!range.intersectsBox(minX, minY, minZ, maxX, maxY, maxZ)) {
            return null;
        }
        switch (range.getAxis()) {
            case field_11048: {
                int clampedMinX = Math.max(minX, range.getLayerMin());
                int clampedMaxX = Math.min(maxX, range.getLayerMax());
                return IntBoundingBox.createProper((int)clampedMinX, (int)minY, (int)minZ, (int)clampedMaxX, (int)maxY, (int)maxZ);
            }
            case field_11052: {
                int clampedMinY = Math.max(minY, range.getLayerMin());
                int clampedMaxY = Math.min(maxY, range.getLayerMax());
                return IntBoundingBox.createProper((int)minX, (int)clampedMinY, (int)minZ, (int)maxX, (int)clampedMaxY, (int)maxZ);
            }
            case field_11051: {
                int clampedMinZ = Math.max(minZ, range.getLayerMin());
                int clampedMaxZ = Math.min(maxZ, range.getLayerMax());
                return IntBoundingBox.createProper((int)minX, (int)minY, (int)clampedMinZ, (int)maxX, (int)maxY, (int)clampedMaxZ);
            }
        }
        return null;
    }

    protected void onChunkAddedForHandling(class_1923 pos, SchematicPlacement placement) {
    }

    @Override
    public boolean canExecute() {
        return !this.chunks.isEmpty() && this.mc.field_1687 != null && this.mc.field_1724 != null && SchematicWorldHandler.getSchematicWorld() != null;
    }

    protected boolean canProcessChunk(class_1923 pos, WorldSchematic worldSchematic, class_638 worldClient) {
        if (!worldSchematic.getChunkProvider().method_12123(pos.field_9181, pos.field_9180) || DataManager.getSchematicPlacementManager().hasPendingRebuildFor(pos)) {
            return false;
        }
        return this.areSurroundingChunksLoaded(pos, worldClient, 1);
    }

    protected void sortChunkList() {
        if (this.chunks.size() > 0) {
            if (this.mc.field_1724 != null) {
                this.comparator.setReferencePosition(this.mc.field_1724.method_24515());
                this.chunks.sort(this.comparator);
            }
            this.onChunkListSorted();
        }
    }

    protected void onChunkListSorted() {
    }

    protected void updateInfoHudLines() {
        ArrayList<String> hudLines = new ArrayList<String>();
        String pre = GuiBase.TXT_WHITE + GuiBase.TXT_BOLD;
        String title = StringUtils.translate((String)"litematica.gui.label.schematic_paste.missing_chunks", (Object[])new Object[]{this.chunks.size()});
        hudLines.add(String.format("%s%s%s", pre, title, GuiBase.TXT_RST));
        int maxLines = Math.min(this.chunks.size(), Configs.InfoOverlays.INFO_HUD_MAX_LINES.getIntegerValue());
        for (int i = 0; i < maxLines; ++i) {
            class_1923 pos = this.chunks.get(i);
            hudLines.add(String.format("cx: %5d, cz: %5d (x: %d, z: %d)", pos.field_9181, pos.field_9180, pos.field_9181 << 4, pos.field_9180 << 4));
        }
        this.infoHudLines = hudLines;
    }
}

