/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3614;

public class SchematicPlacingUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean placeToWorldWithinChunk(class_1937 world, class_1923 chunkPos, SchematicPlacement schematicPlacement, ReplaceBehavior replace, boolean notifyNeighbors) {
        LitematicaSchematic schematic = schematicPlacement.getSchematic();
        Set<String> regionsTouchingChunk = schematicPlacement.getRegionsTouchingChunk(chunkPos.field_9181, chunkPos.field_9180);
        class_2338 origin = schematicPlacement.getOrigin();
        boolean allSuccess = true;
        try {
            if (!notifyNeighbors) {
                WorldUtils.setShouldPreventBlockUpdates(world, true);
            }
            for (String regionName : regionsTouchingChunk) {
                LitematicaBlockStateContainer container = schematic.getSubRegionContainer(regionName);
                if (container == null) {
                    allSuccess = false;
                    continue;
                }
                SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(regionName);
                if (!placement.isEnabled()) continue;
                Map<class_2338, class_2487> blockEntityMap = schematic.getBlockEntityMapForRegion(regionName);
                if (!SchematicPlacingUtils.placeBlocksWithinChunk(world, chunkPos, regionName, container, blockEntityMap, origin, schematicPlacement, placement, replace, notifyNeighbors)) {
                    allSuccess = false;
                    Litematica.logger.warn("Invalid/missing schematic data in schematic '{}' for sub-region '{}'", (Object)schematic.getMetadata().getName(), (Object)regionName);
                }
                List<LitematicaSchematic.EntityInfo> entityList = schematic.getEntityListForRegion(regionName);
                if (schematicPlacement.ignoreEntities() || placement.ignoreEntities() || entityList == null) continue;
                SchematicPlacingUtils.placeEntitiesToWorldWithinChunk(world, chunkPos, entityList, origin, schematicPlacement, placement);
            }
        }
        finally {
            WorldUtils.setShouldPreventBlockUpdates(world, false);
        }
        return allSuccess;
    }

    public static boolean placeBlocksWithinChunk(class_1937 world, class_1923 chunkPos, String regionName, LitematicaBlockStateContainer container, Map<class_2338, class_2487> blockEntityMap, class_2338 origin, SchematicPlacement schematicPlacement, SubRegionPlacement placement, ReplaceBehavior replace, boolean notifyNeighbors) {
        int x;
        int z;
        int y;
        IntBoundingBox bounds = schematicPlacement.getBoxWithinChunkForRegion(regionName, chunkPos.field_9181, chunkPos.field_9180);
        class_2338 regionSize = schematicPlacement.getSchematic().getAreaSize(regionName);
        if (bounds == null || container == null || blockEntityMap == null || regionSize == null) {
            return false;
        }
        class_2338 regionPos = placement.getPos();
        class_2338 posEndRel = new class_2338((class_2382)PositionUtils.getRelativeEndPositionFromAreaSize((class_2382)regionSize)).method_10081((class_2382)regionPos);
        class_2338 posMinRel = PositionUtils.getMinCorner(regionPos, posEndRel);
        class_2338 regionPosTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        class_2338 boxMinRel = new class_2338(bounds.minX - origin.method_10263() - regionPosTransformed.method_10263(), 0, bounds.minZ - origin.method_10260() - regionPosTransformed.method_10260());
        class_2338 boxMaxRel = new class_2338(bounds.maxX - origin.method_10263() - regionPosTransformed.method_10263(), 0, bounds.maxZ - origin.method_10260() - regionPosTransformed.method_10260());
        boxMinRel = PositionUtils.getReverseTransformedBlockPos(boxMinRel, placement.getMirror(), placement.getRotation());
        boxMaxRel = PositionUtils.getReverseTransformedBlockPos(boxMaxRel, placement.getMirror(), placement.getRotation());
        boxMinRel = PositionUtils.getReverseTransformedBlockPos(boxMinRel, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        boxMaxRel = PositionUtils.getReverseTransformedBlockPos(boxMaxRel, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        boxMinRel = boxMinRel.method_10059((class_2382)posMinRel.method_10059((class_2382)regionPos));
        boxMaxRel = boxMaxRel.method_10059((class_2382)posMinRel.method_10059((class_2382)regionPos));
        class_2338 posMin = PositionUtils.getMinCorner(boxMinRel, boxMaxRel);
        class_2338 posMax = PositionUtils.getMaxCorner(boxMinRel, boxMaxRel);
        int startX = posMin.method_10263();
        int startZ = posMin.method_10260();
        int endX = posMax.method_10263();
        int endZ = posMax.method_10260();
        boolean startY = false;
        int endY = Math.abs(regionSize.method_10264()) - 1;
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        if (startX < 0 || startZ < 0 || endX >= container.getSize().method_10263() || endZ >= container.getSize().method_10260()) {
            System.out.printf("DEBUG ============= OUT OF BOUNDS - region: %s, sx: %d, sz: %d, ex: %d, ez: %d - size x: %d z: %d =============\n", regionName, startX, startZ, endX, endZ, container.getSize().method_10263(), container.getSize().method_10260());
            return false;
        }
        class_2470 rotationCombined = schematicPlacement.getRotation().method_10501(placement.getRotation());
        class_2415 mirrorMain = schematicPlacement.getMirror();
        class_2680 barrier = class_2246.field_10499.method_9564();
        class_2415 mirrorSub = placement.getMirror();
        boolean ignoreInventories = Configs.Generic.PASTE_IGNORE_INVENTORY.getBooleanValue();
        if (mirrorSub != class_2415.field_11302 && (schematicPlacement.getRotation() == class_2470.field_11463 || schematicPlacement.getRotation() == class_2470.field_11465)) {
            mirrorSub = mirrorSub == class_2415.field_11301 ? class_2415.field_11300 : class_2415.field_11301;
        }
        for (y = 0; y <= endY; ++y) {
            for (z = startZ; z <= endZ; ++z) {
                for (x = startX; x <= endX; ++x) {
                    class_2586 te;
                    class_2680 state = container.get(x, y, z);
                    if (state.method_26204() == class_2246.field_10369) continue;
                    posMutable.method_10103(x, y, z);
                    class_2487 teNBT = blockEntityMap.get(posMutable);
                    posMutable.method_10103(posMinRel.method_10263() + x - regionPos.method_10263(), posMinRel.method_10264() + y - regionPos.method_10264(), posMinRel.method_10260() + z - regionPos.method_10260());
                    class_2338 pos = PositionUtils.getTransformedPlacementPosition((class_2338)posMutable, schematicPlacement, placement);
                    pos = pos.method_10081((class_2382)regionPosTransformed).method_10081((class_2382)origin);
                    class_2680 stateOld = world.method_8320(pos);
                    if (replace == ReplaceBehavior.NONE && stateOld.method_26207() != class_3614.field_15959 || replace == ReplaceBehavior.WITH_NON_AIR && state.method_26207() == class_3614.field_15959) continue;
                    if (mirrorMain != class_2415.field_11302) {
                        state = state.method_26185(mirrorMain);
                    }
                    if (mirrorSub != class_2415.field_11302) {
                        state = state.method_26185(mirrorSub);
                    }
                    if (rotationCombined != class_2470.field_11467) {
                        state = state.method_26186(rotationCombined);
                    }
                    if ((te = world.method_8321(pos)) != null) {
                        if (te instanceof class_1263) {
                            ((class_1263)te).method_5448();
                        }
                        world.method_8652(pos, barrier, 20);
                    }
                    if (!world.method_8652(pos, state, 18) || teNBT == null || (te = world.method_8321(pos)) == null) continue;
                    teNBT = teNBT.method_10553();
                    teNBT.method_10569("x", pos.method_10263());
                    teNBT.method_10569("y", pos.method_10264());
                    teNBT.method_10569("z", pos.method_10260());
                    if (ignoreInventories) {
                        teNBT.method_10551("Items");
                    }
                    try {
                        te.method_11014(teNBT);
                        if (!ignoreInventories || !(te instanceof class_1263)) continue;
                        ((class_1263)te).method_5448();
                        continue;
                    }
                    catch (Exception e) {
                        Litematica.logger.warn("Failed to load BlockEntity data for {} @ {}", (Object)state, (Object)pos);
                    }
                }
            }
        }
        if (notifyNeighbors) {
            for (y = 0; y <= endY; ++y) {
                for (z = startZ; z <= endZ; ++z) {
                    for (x = startX; x <= endX; ++x) {
                        posMutable.method_10103(posMinRel.method_10263() + x - regionPos.method_10263(), posMinRel.method_10264() + y - regionPos.method_10264(), posMinRel.method_10260() + z - regionPos.method_10260());
                        class_2338 pos = PositionUtils.getTransformedPlacementPosition((class_2338)posMutable, schematicPlacement, placement).method_10081((class_2382)origin);
                        world.method_8408(pos, world.method_8320(pos).method_26204());
                    }
                }
            }
        }
        return true;
    }

    public static void placeEntitiesToWorldWithinChunk(class_1937 world, class_1923 chunkPos, List<LitematicaSchematic.EntityInfo> entityList, class_2338 origin, SchematicPlacement schematicPlacement, SubRegionPlacement placement) {
        class_2338 regionPos = placement.getPos();
        if (entityList == null) {
            return;
        }
        class_2338 regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        int offX = regionPosRelTransformed.method_10263() + origin.method_10263();
        int offY = regionPosRelTransformed.method_10264() + origin.method_10264();
        int offZ = regionPosRelTransformed.method_10260() + origin.method_10260();
        double minX = chunkPos.field_9181 << 4;
        double minZ = chunkPos.field_9180 << 4;
        double maxX = (chunkPos.field_9181 << 4) + 16;
        double maxZ = (chunkPos.field_9180 << 4) + 16;
        class_2470 rotationCombined = schematicPlacement.getRotation().method_10501(placement.getRotation());
        class_2415 mirrorMain = schematicPlacement.getMirror();
        class_2415 mirrorSub = placement.getMirror();
        if (mirrorSub != class_2415.field_11302 && (schematicPlacement.getRotation() == class_2470.field_11463 || schematicPlacement.getRotation() == class_2470.field_11465)) {
            mirrorSub = mirrorSub == class_2415.field_11301 ? class_2415.field_11300 : class_2415.field_11301;
        }
        for (LitematicaSchematic.EntityInfo info : entityList) {
            class_1297 entity = EntityUtils.createEntityAndPassengersFromNBT(info.nbt, world);
            if (entity == null) continue;
            class_243 pos = info.posVec;
            pos = PositionUtils.getTransformedPosition(pos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
            pos = PositionUtils.getTransformedPosition(pos, placement.getMirror(), placement.getRotation());
            double x = pos.field_1352 + (double)offX;
            double y = pos.field_1351 + (double)offY;
            double z = pos.field_1350 + (double)offZ;
            if (!(x >= minX) || !(x < maxX) || !(z >= minZ) || !(z < maxZ)) continue;
            SchematicPlacingUtils.rotateEntity(entity, x, y, z, rotationCombined, mirrorMain, mirrorSub);
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
        }
    }

    public static void rotateEntity(class_1297 entity, double x, double y, double z, class_2470 rotationCombined, class_2415 mirrorMain, class_2415 mirrorSub) {
        float rotationYaw = entity.method_36454();
        if (mirrorMain != class_2415.field_11302) {
            rotationYaw = entity.method_5763(mirrorMain);
        }
        if (mirrorSub != class_2415.field_11302) {
            rotationYaw = entity.method_5763(mirrorSub);
        }
        if (rotationCombined != class_2470.field_11467) {
            rotationYaw += entity.method_36454() - entity.method_5832(rotationCombined);
        }
        entity.method_5808(x, y, z, rotationYaw, entity.method_36455());
        EntityUtils.setEntityRotations(entity, rotationYaw, entity.method_36455());
    }
}

