/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetLabel;
import fi.dy.masa.malilib.render.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_4587;

public abstract class WidgetContainer
extends WidgetBase {
    protected final List<WidgetBase> subWidgets = new ArrayList<WidgetBase>();
    @Nullable
    protected WidgetBase hoveredSubWidget = null;

    public WidgetContainer(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    protected <T extends WidgetBase> T addWidget(T widget) {
        this.subWidgets.add(widget);
        return widget;
    }

    protected <T extends ButtonBase> T addButton(T button, IButtonActionListener listener) {
        button.setActionListener(listener);
        this.addWidget(button);
        return button;
    }

    protected void addLabel(int x, int y, int width, int height, int textColor, String ... lines) {
        if (lines != null && lines.length >= 1) {
            if (width == -1) {
                for (String line : lines) {
                    width = Math.max(width, this.getStringWidth(line));
                }
            }
            WidgetLabel label = new WidgetLabel(x, y, width, height, textColor, lines);
            this.addWidget(label);
        }
    }

    @Override
    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean handled = false;
        if (this.isMouseOver(mouseX, mouseY)) {
            if (!this.subWidgets.isEmpty()) {
                for (WidgetBase widget : this.subWidgets) {
                    if (!widget.isMouseOver(mouseX, mouseY) || !widget.onMouseClicked(mouseX, mouseY, mouseButton)) continue;
                    handled = true;
                }
            }
            if (!handled) {
                handled = this.onMouseClickedImpl(mouseX, mouseY, mouseButton);
            }
        }
        return handled;
    }

    @Override
    public void onMouseReleased(int mouseX, int mouseY, int mouseButton) {
        if (!this.subWidgets.isEmpty()) {
            for (WidgetBase widget : this.subWidgets) {
                widget.onMouseReleased(mouseX, mouseY, mouseButton);
            }
        }
        this.onMouseReleasedImpl(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean onMouseScrolled(int mouseX, int mouseY, double mouseWheelDelta) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (!this.subWidgets.isEmpty()) {
                for (WidgetBase widget : this.subWidgets) {
                    if (!widget.onMouseScrolled(mouseX, mouseY, mouseWheelDelta)) continue;
                    return true;
                }
            }
            return this.onMouseScrolledImpl(mouseX, mouseY, mouseWheelDelta);
        }
        return false;
    }

    @Override
    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        boolean handled = false;
        if (!this.subWidgets.isEmpty()) {
            for (WidgetBase widget : this.subWidgets) {
                if (!widget.onKeyTyped(keyCode, scanCode, modifiers)) continue;
                handled = true;
            }
        }
        if (!handled) {
            handled = this.onKeyTypedImpl(keyCode, scanCode, modifiers);
        }
        return handled;
    }

    @Override
    public boolean onCharTyped(char charIn, int modifiers) {
        boolean handled = false;
        if (!this.subWidgets.isEmpty()) {
            for (WidgetBase widget : this.subWidgets) {
                if (!widget.onCharTyped(charIn, modifiers)) continue;
                handled = true;
            }
        }
        if (!handled) {
            handled = this.onCharTypedImpl(charIn, modifiers);
        }
        return handled;
    }

    @Override
    public void render(int mouseX, int mouseY, boolean selected, class_4587 matrixStack) {
        this.drawSubWidgets(mouseX, mouseY, matrixStack);
    }

    @Override
    public void postRenderHovered(int mouseX, int mouseY, boolean selected, class_4587 matrixStack) {
        this.drawHoveredSubWidget(mouseX, mouseY, matrixStack);
    }

    protected void drawSubWidgets(int mouseX, int mouseY, class_4587 matrixStack) {
        this.hoveredSubWidget = null;
        if (!this.subWidgets.isEmpty()) {
            for (WidgetBase widget : this.subWidgets) {
                widget.render(mouseX, mouseY, false, matrixStack);
                if (!widget.isMouseOver(mouseX, mouseY)) continue;
                this.hoveredSubWidget = widget;
            }
        }
    }

    protected void drawHoveredSubWidget(int mouseX, int mouseY, class_4587 matrixStack) {
        if (this.hoveredSubWidget != null) {
            this.hoveredSubWidget.postRenderHovered(mouseX, mouseY, false, matrixStack);
            RenderUtils.disableDiffuseLighting();
        }
    }
}

