/*
 * Decompiled with CFR 0.152.
 */
package supercoder79.cavebiomes.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import supercoder79.cavebiomes.api.CaveDecorator;
import supercoder79.cavebiomes.world.decorator.CaveDecorators;
import supercoder79.cavebiomes.world.layer.LayerGenerator;

public class MapCaveBiomesCommand {
    public static final Map<CaveDecorator, Integer> COLORS = new HashMap<CaveDecorator, Integer>();

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> {
            LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"mapcavebiomes").requires(source -> source.method_9259(2));
            builder.executes(context -> MapCaveBiomesCommand.execute((class_2168)context.getSource()));
            dispatcher.register(builder);
        });
        COLORS.put(CaveDecorators.NONE, 0xEEEEEE);
        COLORS.put(CaveDecorators.WATER, 13243);
        COLORS.put(CaveDecorators.LAVA, 0xDD6600);
        COLORS.put(CaveDecorators.LUSH, 65331);
        COLORS.put(CaveDecorators.OBSIDIAN, 0x333333);
        COLORS.put(CaveDecorators.MAGMA, 0xDD9900);
        COLORS.put(CaveDecorators.COBBLESTONE, 0x777777);
        COLORS.put(CaveDecorators.GRAVEL, 0x999999);
        COLORS.put(CaveDecorators.SANDSTONE, 16118436);
        COLORS.put(CaveDecorators.ANDESITE, 14077664);
        COLORS.put(CaveDecorators.DIORITE, 14737626);
        COLORS.put(CaveDecorators.GRANITE, 14722942);
        COLORS.put(CaveDecorators.COBWEB, 0xC4C4C4);
        COLORS.put(CaveDecorators.FULL_OBSIDIAN, 0);
        COLORS.put(CaveDecorators.MUSHROOM, 8223555);
        COLORS.put(CaveDecorators.COAL, 6842724);
        COLORS.put(CaveDecorators.IRON, 10198140);
        COLORS.put(CaveDecorators.GOLD, 14402048);
        COLORS.put(CaveDecorators.REDSTONE, 15073368);
        COLORS.put(CaveDecorators.LAPIS, 2949849);
        COLORS.put(CaveDecorators.DIAMOND, 65535);
    }

    private static int execute(class_2168 source) {
        BufferedImage img = new BufferedImage(2048, 2048, 1);
        long seed = source.method_9225().method_8412();
        for (int x = -1024; x < 1024; ++x) {
            if (x % 256 == 0) {
                source.method_9226((class_2561)new class_2585((double)(x + 1024) / 2048.0 * 100.0 + "%"), false);
            }
            for (int z = -1024; z < 1024; ++z) {
                CaveDecorator decorator = LayerGenerator.getDecorator(seed, x, z);
                int color = COLORS.getOrDefault(decorator, 0xFFFFFF);
                img.setRGB(x + 1024, z + 1024, color);
            }
        }
        Path p = Paths.get("cavebiomemap.png", new String[0]);
        try {
            ImageIO.write((RenderedImage)img, "png", p.toAbsolutePath().toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        source.method_9226((class_2561)new class_2585("Mapped cave biomes!"), false);
        return 0;
    }
}

