/*
 * Decompiled with CFR 0.152.
 */
package supercoder79.cavebiomes.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import supercoder79.cavebiomes.world.layer.WaterGenerator;

public class MapWaterCommand {
    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> {
            LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"mapwater").requires(source -> source.method_9259(2));
            builder.executes(context -> MapWaterCommand.execute((class_2168)context.getSource()));
            dispatcher.register(builder);
        });
    }

    private static int execute(class_2168 source) {
        BufferedImage img = new BufferedImage(2048, 2048, 1);
        long seed = source.method_9225().method_8412();
        for (int x = -1024; x < 1024; ++x) {
            if (x % 256 == 0) {
                source.method_9226((class_2561)new class_2585((double)(x + 1024) / 2048.0 * 100.0 + "%"), false);
            }
            for (int z = -1024; z < 1024; ++z) {
                int sample = WaterGenerator.getSample(seed, x, z);
                int borderHeight = (sample & 0xFF00) >> 8;
                int waterHeight = sample & 0xFF;
                img.setRGB(x + 1024, z + 1024, sample > 0 ? MapWaterCommand.getIntFromColor(borderHeight > 0 ? 128 + borderHeight * 2 : 0, 0, waterHeight * 8) : 0xADADAD);
            }
        }
        Path p = Paths.get("watermap.png", new String[0]);
        try {
            ImageIO.write((RenderedImage)img, "png", p.toAbsolutePath().toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        source.method_9226((class_2561)new class_2585("Mapped water!"), false);
        return 0;
    }

    private static int getIntFromColor(int red, int green, int blue) {
        red = red << 16 & 0xFF0000;
        green = green << 8 & 0xFF00;
        return 0xFF000000 | red | green | (blue &= 0xFF);
    }
}

