/*
 * Decompiled with CFR 0.152.
 */
package supercoder79.cavebiomes.util;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3233;
import net.minecraft.class_3341;
import net.minecraft.class_3612;

public class FloodFill {
    public static void floodFill(class_3233 world, Random random, class_2338 pos, Set<class_2338> carvedPositions) {
        long start = System.currentTimeMillis();
        class_1923 chunkPos = new class_1923(pos);
        class_3341 box = new class_3341(chunkPos.method_8326() - 14, 1, chunkPos.method_8328() - 14, chunkPos.method_8327() + 14, 512, chunkPos.method_8329() + 14);
        HashSet<class_2338> filled = new HashSet<class_2338>();
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        class_2338 startPos = FloodFill.findStart(world, pos, box);
        boolean bounded = FloodFill.tryFloodFill(world, startPos, box, filled, mutablePos);
        if (bounded) {
            Set<class_2338> lowestFilled = new HashSet<class_2338>(filled);
            int y = 1;
            int max = random.nextInt(6) + random.nextInt(6) + 2;
            HashSet<class_2338> possibleFilled = new HashSet<class_2338>();
            while (FloodFill.tryFloodFill(world, startPos.method_10086(y), box, possibleFilled, mutablePos)) {
                filled.addAll(possibleFilled);
                possibleFilled.clear();
                if (++y <= max) continue;
            }
            while (!lowestFilled.isEmpty()) {
                lowestFilled = FloodFill.tryDownFill(world, lowestFilled, mutablePos);
                filled.addAll(lowestFilled);
            }
            for (class_2338 filledPos : filled) {
                world.method_8652(filledPos, class_2246.field_10382.method_9564(), 2);
                world.method_8405().method_8676(filledPos, (Object)class_3612.field_15910, 0);
            }
        }
    }

    private static boolean tryFloodFill(class_3233 world, class_2338 startPos, class_3341 box, Set<class_2338> filled, class_2338.class_2339 mutablePos) {
        if (!FloodFill.isFloodFillable(world.method_8320(startPos))) {
            return false;
        }
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        filled.add(startPos);
        queue.addFirst(startPos);
        while (!queue.isEmpty()) {
            class_2338 posAt = (class_2338)queue.removeFirst();
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2680 stateAt;
                mutablePos.method_10101((class_2382)posAt).method_10098(direction);
                if (filled.contains(mutablePos) || !FloodFill.isFloodFillable(stateAt = world.method_8320((class_2338)mutablePos))) continue;
                if (box.method_14662((class_2382)mutablePos)) {
                    class_2338 posNext = mutablePos.method_10062();
                    queue.addFirst(posNext);
                    filled.add(posNext);
                    continue;
                }
                return false;
            }
        }
        return !filled.isEmpty();
    }

    private static Set<class_2338> tryDownFill(class_3233 world, Set<class_2338> lowestFilled, class_2338.class_2339 mutablePos) {
        HashSet<class_2338> nextLowestFilled = new HashSet<class_2338>();
        for (class_2338 pos : lowestFilled) {
            mutablePos.method_10101((class_2382)pos).method_10100(0, -1, 0);
            class_2680 state = world.method_8320((class_2338)mutablePos);
            if (!FloodFill.isFloodFillable(state)) continue;
            nextLowestFilled.add(mutablePos.method_10062());
        }
        return nextLowestFilled;
    }

    private static boolean isFloodFillable(class_2680 state) {
        return state.method_26215() || state.method_26207().method_15800() && state.method_26204() != class_2246.field_10164;
    }

    private static class_2338 findStart(class_3233 world, class_2338 base, class_3341 box) {
        if (world.method_8320(base).method_26225()) {
            return base;
        }
        class_2338.class_2339 mutable = base.method_25503();
        while (mutable.method_10264() > 11 && !world.method_8320(mutable.method_10074()).method_26225()) {
            mutable.method_10098(class_2350.field_11033);
        }
        HashSet<class_2338> positions = new HashSet<class_2338>();
        FloodFill.lower(world, mutable.method_10062(), box, 0, positions);
        class_2338 ret = base.method_10062();
        for (class_2338 position : positions) {
            if (position.method_10264() >= ret.method_10264()) continue;
            ret = position.method_10062();
        }
        return ret;
    }

    private static void lower(class_3233 world, class_2338 pos, class_3341 box, int depth, Set<class_2338> visited) {
        int newDepth = depth + 1;
        if (!box.method_14662((class_2382)pos)) {
            return;
        }
        visited.add(pos);
        if (newDepth == 512) {
            return;
        }
        if (pos.method_10264() <= 10) {
            return;
        }
        class_2338 down = pos.method_10074();
        if (world.method_8320(down).method_26215() && !visited.contains(down)) {
            FloodFill.lower(world, down, box, newDepth, visited);
        } else {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338 local = pos.method_10093(direction);
                if (!world.method_8320(local).method_26215() || visited.contains(local)) continue;
                FloodFill.lower(world, local, box, newDepth, visited);
            }
        }
    }
}

