/*
 * Decompiled with CFR 0.152.
 */
package supercoder79.cavebiomes.world.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import supercoder79.cavebiomes.config.ConfigData;
import supercoder79.cavebiomes.mixin.GenerationSettingsAccessor;
import supercoder79.cavebiomes.world.feature.AddCaveBiomesFeature;
import supercoder79.cavebiomes.world.feature.LocalWaterLevelsFeature;
import supercoder79.cavebiomes.world.feature.MobSpawnerFeature;
import supercoder79.cavebiomes.world.feature.OreNoduleFeature;
import supercoder79.cavebiomes.world.feature.TreasureChestFeature;

public final class CaveBiomesFeatures {
    public static final AddCaveBiomesFeature CAVE_BIOMES = new AddCaveBiomesFeature();
    public static final LocalWaterLevelsFeature LOCAL_WATER_LEVELS = new LocalWaterLevelsFeature();
    public static final OreNoduleFeature ORE_NODULE = new OreNoduleFeature();
    public static final TreasureChestFeature CAVERN_CHEST = new TreasureChestFeature(0, TreasureChestFeature.Type.CAVERN);
    public static final TreasureChestFeature SPELUNKERS_CHEST = new TreasureChestFeature(1, TreasureChestFeature.Type.SPELUNKERS);
    public static final TreasureChestFeature NETHER_CHEST = new TreasureChestFeature(2, TreasureChestFeature.Type.NETHER);
    public static final MobSpawnerFeature CAVE_SPAWNER = new MobSpawnerFeature(3, 50, class_1299.field_6051, class_1299.field_6079);
    public static final MobSpawnerFeature RARE_CAVE_SPAWNER = new MobSpawnerFeature(4, 35, class_1299.field_6137, class_1299.field_6137, class_1299.field_6084, class_1299.field_6079, class_1299.field_6125);
    public static final Predicate<class_1959> OVERWORLD = biome -> {
        class_1959.class_1961 category = biome.method_8688();
        return category != class_1959.class_1961.field_9366 && category != class_1959.class_1961.field_9360;
    };
    public static final Predicate<class_1959> NETHER = biome -> {
        class_1959.class_1961 category = biome.method_8688();
        return category == class_1959.class_1961.field_9366;
    };

    private CaveBiomesFeatures() {
    }

    public static void addEnabledFeatures(ConfigData config) {
        CaveBiomesFeatures.registerFeature("cavern_chest", CAVERN_CHEST);
        CaveBiomesFeatures.registerFeature("spelunkers_chest", SPELUNKERS_CHEST);
        CaveBiomesFeatures.registerFeature("nether_chest", NETHER_CHEST);
        CaveBiomesFeatures.registerFeature("cave_spawner", CAVE_SPAWNER);
        CaveBiomesFeatures.registerFeature("rare_cave_spawner", RARE_CAVE_SPAWNER);
        CaveBiomesFeatures.registerFeature("cave_biomes", CAVE_BIOMES);
        CaveBiomesFeatures.registerFeature("local_water_levels", LOCAL_WATER_LEVELS);
        CaveBiomesFeatures.registerFeature("ore_nodule", ORE_NODULE);
    }

    private static <C extends class_3037, F extends class_3031<C>, T extends class_2975<C, F>> void addFeatureTo(class_2893.class_2895 step, T feature, Predicate<class_1959> predicate) {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> server.method_30611().method_30530(class_2378.field_25114).forEach(biome -> {
            if (predicate.test((class_1959)biome)) {
                CaveBiomesFeatures.addFeature(biome, step, feature);
            }
        }));
    }

    private static void registerFeature(String id, class_3031<?> feature) {
        class_2378.method_10230((class_2378)class_2378.field_11138, (class_2960)new class_2960("cavebiomes", id), feature);
    }

    public static void addFeature(class_1959 biome, class_2893.class_2895 step, class_2975<?, ?> feature) {
        List featureSteps = biome.method_30970().method_30983();
        ArrayList newFeatures = new ArrayList();
        for (class_2893.class_2895 featureStep : class_2893.class_2895.values()) {
            ArrayList<Supplier<class_2975>> features;
            int index = featureStep.ordinal();
            ArrayList<Supplier<Object>> arrayList = features = index < featureSteps.size() ? new ArrayList<Supplier<class_2975>>((Collection)featureSteps.get(index)) : new ArrayList();
            if (step == featureStep) {
                features.add(() -> feature);
            }
            newFeatures.add(features);
        }
        ((GenerationSettingsAccessor)biome.method_30970()).setFeatures(newFeatures);
    }
}

