/*
 * Decompiled with CFR 0.152.
 */
package supercoder79.cavebiomes.world.layer;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import net.minecraft.class_1923;
import net.minecraft.class_3532;
import supercoder79.cavebiomes.util.LayerRandom;

public abstract class CaveLayer {
    protected final long worldSeed;
    protected final int salt;
    private final ThreadLocal<Cache> cache;

    public CaveLayer(long worldSeed, int salt) {
        this.worldSeed = worldSeed;
        this.salt = salt;
        this.cache = ThreadLocal.withInitial(this::initializeCache);
    }

    public int sample(int x, int z) {
        return this.cache.get().get(x, z);
    }

    protected int choose(LayerRandom random, int a, int b, int c, int d) {
        int i = random.nextInt(4);
        if (i == 0) {
            return a;
        }
        if (i == 1) {
            return b;
        }
        return i == 2 ? c : d;
    }

    protected int choose(LayerRandom random, int a, int b) {
        return random.nextInt(2) == 0 ? a : b;
    }

    protected abstract int operate(LayerRandom var1, int var2, int var3);

    protected Cache initializeCache() {
        return new Cache(256);
    }

    protected class Cache {
        protected final long[] keys;
        protected final int[] values;
        protected final int mask;

        protected Cache(int size) {
            size = class_3532.method_15339((int)size);
            this.mask = size - 1;
            this.keys = new long[size];
            Arrays.fill(this.keys, Long.MIN_VALUE);
            this.values = new int[size];
        }

        public final int get(int x, int z) {
            int sampled;
            long key = this.key(x, z);
            int idx = this.hash(key) & this.mask;
            if (this.keys[idx] == key) {
                return this.values[idx];
            }
            this.values[idx] = sampled = this.getValueForSample(x, z);
            this.keys[idx] = key;
            return sampled;
        }

        protected int getValueForSample(int x, int z) {
            LayerRandom random = new LayerRandom(CaveLayer.this.worldSeed);
            random.setPosSeed(x, z, CaveLayer.this.salt);
            return CaveLayer.this.operate(random, x, z);
        }

        protected final int hash(long key) {
            return (int)HashCommon.mix((long)key);
        }

        protected final long key(int x, int z) {
            return class_1923.method_8331((int)x, (int)z);
        }
    }
}

