/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import ru.bclib.util.WeightedList;

public class BonemealAPI {
    private static final Map<class_2960, Map<class_2248, WeightedList<class_2248>>> WATER_GRASS_BIOMES = Maps.newHashMap();
    private static final Map<class_2960, Map<class_2248, WeightedList<class_2248>>> LAND_GRASS_BIOMES = Maps.newHashMap();
    private static final Map<class_2248, WeightedList<class_2248>> WATER_GRASS_TYPES = Maps.newHashMap();
    private static final Map<class_2248, WeightedList<class_2248>> LAND_GRASS_TYPES = Maps.newHashMap();
    private static final Set<class_2248> SPREADABLE_BLOCKS = Sets.newHashSet();

    public static void addSpreadableBlock(class_2248 block) {
        SPREADABLE_BLOCKS.add(block);
    }

    public static boolean isSpreadable(class_2248 block) {
        return SPREADABLE_BLOCKS.contains(block);
    }

    public static void addLandGrass(class_2248 plant, class_2248 ... terrain) {
        for (class_2248 block : terrain) {
            BonemealAPI.addLandGrass(block, plant, 1.0f);
        }
    }

    public static void addLandGrass(class_2960 biome, class_2248 plant, class_2248 ... terrain) {
        for (class_2248 block : terrain) {
            BonemealAPI.addLandGrass(biome, block, plant, 1.0f);
        }
    }

    public static void addLandGrass(class_2248 terrain, class_2248 plant, float chance) {
        WeightedList<Object> list = LAND_GRASS_TYPES.get(terrain);
        if (list == null) {
            list = new WeightedList();
            LAND_GRASS_TYPES.put(terrain, list);
        }
        list.add(plant, chance);
    }

    public static void addLandGrass(class_2960 biome, class_2248 terrain, class_2248 plant, float chance) {
        WeightedList<class_2248> list;
        HashMap map = LAND_GRASS_BIOMES.get(biome);
        if (map == null) {
            map = Maps.newHashMap();
            LAND_GRASS_BIOMES.put(biome, map);
        }
        if ((list = (WeightedList<class_2248>)map.get(terrain)) == null) {
            list = new WeightedList<class_2248>();
            map.put(terrain, list);
        }
        list.add(plant, chance);
    }

    public static void addWaterGrass(class_2248 plant, class_2248 ... terrain) {
        for (class_2248 block : terrain) {
            BonemealAPI.addWaterGrass(block, plant, 1.0f);
        }
    }

    public static void addWaterGrass(class_2960 biome, class_2248 plant, class_2248 ... terrain) {
        for (class_2248 block : terrain) {
            BonemealAPI.addWaterGrass(biome, block, plant, 1.0f);
        }
    }

    public static void addWaterGrass(class_2248 terrain, class_2248 plant, float chance) {
        WeightedList<Object> list = WATER_GRASS_TYPES.get(terrain);
        if (list == null) {
            list = new WeightedList();
            WATER_GRASS_TYPES.put(terrain, list);
        }
        list.add(plant, chance);
    }

    public static void addWaterGrass(class_2960 biome, class_2248 terrain, class_2248 plant, float chance) {
        WeightedList<class_2248> list;
        HashMap map = WATER_GRASS_BIOMES.get(biome);
        if (map == null) {
            map = Maps.newHashMap();
            WATER_GRASS_BIOMES.put(biome, map);
        }
        if ((list = (WeightedList<class_2248>)map.get(terrain)) == null) {
            list = new WeightedList<class_2248>();
            map.put(terrain, list);
        }
        list.add(plant, chance);
    }

    public static class_2248 getLandGrass(class_2960 biomeID, class_2248 terrain, Random random) {
        Map<class_2248, WeightedList<class_2248>> map = LAND_GRASS_BIOMES.get(biomeID);
        WeightedList<class_2248> list = null;
        if (map != null) {
            list = map.get(terrain);
            if (list == null) {
                list = LAND_GRASS_TYPES.get(terrain);
            }
        } else {
            list = LAND_GRASS_TYPES.get(terrain);
        }
        return list == null ? null : list.get(random);
    }

    public static class_2248 getWaterGrass(class_2960 biomeID, class_2248 terrain, Random random) {
        Map<class_2248, WeightedList<class_2248>> map = LAND_GRASS_BIOMES.get(biomeID);
        WeightedList<class_2248> list = null;
        if (map != null) {
            list = map.get(terrain);
            if (list == null) {
                list = LAND_GRASS_TYPES.get(terrain);
            }
        } else {
            list = LAND_GRASS_TYPES.get(terrain);
        }
        return list == null ? null : list.get(random);
    }
}

