/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import ru.bclib.BCLib;
import ru.bclib.api.DataFixerAPI;

public class WorldDataAPI {
    private static final Map<String, class_2487> TAGS = Maps.newHashMap();
    private static final List<String> MODS = Lists.newArrayList();
    private static File dataDir;

    public static void load(File dataDir) {
        WorldDataAPI.dataDir = dataDir;
        ((Stream)MODS.stream().parallel()).forEach(modID -> {
            File file = new File(dataDir, modID + ".nbt");
            class_2487 root = new class_2487();
            TAGS.put((String)modID, root);
            if (file.exists()) {
                try {
                    root = class_2507.method_30613((File)file);
                }
                catch (IOException e) {
                    BCLib.LOGGER.error("World data loading failed", e);
                }
            } else {
                Optional optional = FabricLoader.getInstance().getModContainer(modID);
                if (optional.isPresent()) {
                    ModContainer modContainer = (ModContainer)optional.get();
                    if (BCLib.isDevEnvironment()) {
                        root.method_10582("version", "63.63.63");
                    } else {
                        root.method_10582("version", modContainer.getMetadata().getVersion().toString());
                    }
                    WorldDataAPI.saveFile(modID);
                }
            }
        });
    }

    public static void registerModCache(String modID) {
        MODS.add(modID);
    }

    public static class_2487 getRootTag(String modID) {
        class_2487 root = TAGS.get(modID);
        if (root == null) {
            root = new class_2487();
            TAGS.put(modID, root);
        }
        return root;
    }

    public static class_2487 getCompoundTag(String modID, String path) {
        String[] parts = path.split("\\.");
        class_2487 tag = WorldDataAPI.getRootTag(modID);
        for (String part : parts) {
            if (tag.method_10545(part)) {
                tag = tag.method_10562(part);
                continue;
            }
            class_2487 t = new class_2487();
            tag.method_10566(part, (class_2520)t);
            tag = t;
        }
        return tag;
    }

    public static void saveFile(String modID) {
        try {
            class_2507.method_30614((class_2487)WorldDataAPI.getRootTag(modID), (File)new File(dataDir, modID + ".nbt"));
        }
        catch (IOException e) {
            BCLib.LOGGER.error("World data saving failed", e);
        }
    }

    public static String getModVersion(String modID) {
        return WorldDataAPI.getRootTag(modID).method_10558("version");
    }

    public static int getIntModVersion(String modID) {
        return DataFixerAPI.getModVersion(WorldDataAPI.getModVersion(modID));
    }
}

