/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.config;

import org.jetbrains.annotations.Nullable;
import ru.bclib.config.Config;
import ru.bclib.config.ConfigKeeper;
import ru.bclib.config.ConfigKey;

public class PathConfig
extends Config {
    public PathConfig(String modID, String group) {
        super(modID, group);
    }

    @Override
    protected void registerEntries() {
    }

    protected ConfigKey createKey(String category, String key) {
        return new ConfigKey(key, category.split("\\."));
    }

    protected ConfigKey createKey(String key) {
        return this.createKey("", key);
    }

    @Nullable
    public <T, E extends ConfigKeeper.Entry<T>> E getEntry(String category, String key, Class<E> type) {
        return this.getEntry(this.createKey(category, key), type);
    }

    @Nullable
    public <T, E extends ConfigKeeper.Entry<T>> T getDefault(String category, String key, Class<E> type) {
        return this.getDefault(this.createKey(category, key), type);
    }

    public String getString(String category, String key, String defaultValue) {
        return this.getString(this.createKey(category, key), defaultValue);
    }

    public String getString(String category, String key) {
        return this.getString(this.createKey(category, key));
    }

    public boolean setString(String category, String key, String value) {
        return this.setString(this.createKey(category, key), value);
    }

    public int getInt(String category, String key, int defaultValue) {
        return this.getInt(this.createKey(category, key), defaultValue);
    }

    public int getInt(String category, String key) {
        return this.getInt(this.createKey(category, key));
    }

    public boolean setInt(String category, String key, int value) {
        return this.setInt(this.createKey(category, key), value);
    }

    public boolean setRangedInt(String category, String key, int value) {
        return this.setRanged(this.createKey(category, key), value, ConfigKeeper.IntegerRange.class);
    }

    public boolean setRangedFloat(String category, String key, float value) {
        return this.setRanged(this.createKey(category, key), Float.valueOf(value), ConfigKeeper.FloatRange.class);
    }

    public float getFloat(String category, String key, float defaultValue) {
        return this.getFloat(this.createKey(category, key), defaultValue);
    }

    public float getFloat(String category, String key) {
        return this.getFloat(this.createKey(category, key));
    }

    public boolean setFloat(String category, String key, float value) {
        return this.setFloat(this.createKey(category, key), value);
    }

    public boolean getBoolean(String category, String key, boolean defaultValue) {
        return this.getBoolean(this.createKey(category, key), defaultValue);
    }

    public boolean getBoolean(String category, String key) {
        return this.getBoolean(this.createKey(category, key));
    }

    public boolean setBoolean(String category, String key, boolean value) {
        return this.setBoolean(this.createKey(category, key), value);
    }

    public String getStringRoot(String key, String defaultValue) {
        return this.getString(this.createKey(key), defaultValue);
    }

    public String getStringRoot(String key) {
        return this.getString(this.createKey(key));
    }

    public boolean setStringRoot(String key, String value) {
        return this.setString(this.createKey(key), value);
    }

    public int getIntRoot(String key, int defaultValue) {
        return this.getInt(this.createKey(key), defaultValue);
    }

    public int getIntRoot(String key) {
        return this.getInt(this.createKey(key));
    }

    public boolean setIntRoot(String key, int value) {
        return this.setInt(this.createKey(key), value);
    }

    public boolean setRangedIntRoot(String key, int value) {
        return this.setRanged(this.createKey(key), value, ConfigKeeper.IntegerRange.class);
    }

    public boolean setRangedFloatRoot(String key, float value) {
        return this.setRanged(this.createKey(key), Float.valueOf(value), ConfigKeeper.FloatRange.class);
    }

    public float getFloatRoot(String key, float defaultValue) {
        return this.getFloat(this.createKey(key), defaultValue);
    }

    public float getFloatRoot(String key) {
        return this.getFloat(this.createKey(key));
    }

    public boolean setFloatRoot(String key, float value) {
        return this.setFloat(this.createKey(key), value);
    }

    public boolean getBooleanRoot(String key, boolean defaultValue) {
        return this.getBoolean(this.createKey(key), defaultValue);
    }

    public boolean getBooleanRoot(String key) {
        return this.getBoolean(this.createKey(key));
    }

    public boolean setBooleanRoot(String key, boolean value) {
        return this.setBoolean(this.createKey(key), value);
    }
}

