/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.recipes;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3956;
import ru.bclib.BCLib;
import ru.bclib.config.PathConfig;
import ru.bclib.recipes.BCLRecipeManager;

public class GridRecipe {
    private static final GridRecipe INSTANCE = new GridRecipe();
    private class_2960 id;
    private class_1935 output;
    private String group;
    private class_3956<?> type;
    private boolean shaped;
    private String[] shape;
    private Map<Character, class_1856> materialKeys = Maps.newHashMap();
    private int count;
    private boolean exist = true;

    private GridRecipe() {
    }

    public static GridRecipe make(String modID, String name, class_1935 output) {
        GridRecipe.INSTANCE.id = new class_2960(modID, name);
        GridRecipe.INSTANCE.output = output;
        GridRecipe.INSTANCE.group = "";
        GridRecipe.INSTANCE.type = class_3956.field_17545;
        GridRecipe.INSTANCE.shaped = true;
        GridRecipe.INSTANCE.shape = new String[]{"#"};
        GridRecipe.INSTANCE.materialKeys.clear();
        GridRecipe.INSTANCE.count = 1;
        GridRecipe.INSTANCE.exist = BCLRecipeManager.exists(output);
        return INSTANCE;
    }

    public GridRecipe checkConfig(PathConfig config) {
        this.exist |= config.getBoolean("grid", this.id.method_12832(), true);
        return this;
    }

    public GridRecipe setGroup(String group) {
        this.group = group;
        return this;
    }

    public GridRecipe setShape(String ... shape) {
        this.shape = shape;
        return this;
    }

    public GridRecipe setList(String shape) {
        this.shape = new String[]{shape};
        this.shaped = false;
        return this;
    }

    public GridRecipe addMaterial(char key, class_3494<class_1792> value) {
        return this.addMaterial(key, class_1856.method_8106(value));
    }

    public GridRecipe addMaterial(char key, class_1799 ... value) {
        return this.addMaterial(key, class_1856.method_26964(Arrays.stream(value)));
    }

    public GridRecipe addMaterial(char key, class_1935 ... values) {
        for (class_1935 item : values) {
            this.exist &= BCLRecipeManager.exists(item);
        }
        return this.addMaterial(key, class_1856.method_8091((class_1935[])values));
    }

    private GridRecipe addMaterial(char key, class_1856 value) {
        this.materialKeys.put(Character.valueOf(key), value);
        return this;
    }

    public GridRecipe setOutputCount(int count) {
        this.count = count;
        return this;
    }

    private class_2371<class_1856> getMaterials(int width, int height) {
        class_2371 materials = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
        int pos = 0;
        for (String line : this.shape) {
            for (int i = 0; i < width; ++i) {
                char c = line.charAt(i);
                class_1856 material = this.materialKeys.get(Character.valueOf(c));
                materials.set(pos++, (Object)(material == null ? class_1856.field_9017 : material));
            }
        }
        return materials;
    }

    public void build() {
        if (this.exist) {
            int height = this.shape.length;
            int width = this.shape[0].length();
            class_1799 result = new class_1799(this.output, this.count);
            class_2371<class_1856> materials = this.getMaterials(width, height);
            class_1869 recipe = this.shaped ? new class_1869(this.id, this.group, width, height, materials, result) : new class_1867(this.id, this.group, result, materials);
            BCLRecipeManager.addRecipe(this.type, recipe);
        } else {
            BCLib.LOGGER.debug("Recipe {} couldn't be added", this.id);
        }
    }
}

