/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.recipes;

import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3956;
import net.minecraft.class_5357;
import ru.bclib.BCLib;
import ru.bclib.config.PathConfig;
import ru.bclib.recipes.BCLRecipeManager;

public class SmithingTableRecipe {
    private static final SmithingTableRecipe BUILDER = new SmithingTableRecipe();
    private static final class_3956<class_5357> TYPE = class_3956.field_25388;
    private class_2960 id;
    private class_1856 base;
    private class_1856 addition;
    private class_1799 result;
    private boolean alright;
    private boolean exist;

    public static SmithingTableRecipe create(String modID, String name) {
        return SmithingTableRecipe.create(new class_2960(modID, name));
    }

    public static SmithingTableRecipe create(class_2960 id) {
        SmithingTableRecipe.BUILDER.id = id;
        SmithingTableRecipe.BUILDER.base = null;
        SmithingTableRecipe.BUILDER.addition = null;
        SmithingTableRecipe.BUILDER.result = null;
        SmithingTableRecipe.BUILDER.alright = true;
        return BUILDER;
    }

    private SmithingTableRecipe() {
    }

    public SmithingTableRecipe checkConfig(PathConfig config) {
        this.exist |= config.getBoolean("smithing", this.id.method_12832(), true);
        return this;
    }

    public SmithingTableRecipe setResult(class_1935 item) {
        return this.setResult(item, 1);
    }

    public SmithingTableRecipe setResult(class_1935 item, int count) {
        this.alright &= BCLRecipeManager.exists(item);
        this.result = new class_1799(item, count);
        return this;
    }

    public SmithingTableRecipe setBase(class_1935 ... items) {
        this.alright &= BCLRecipeManager.exists(items);
        this.base = class_1856.method_8091((class_1935[])items);
        return this;
    }

    public SmithingTableRecipe setBase(class_3494<class_1792> tag) {
        this.base = class_1856.method_8106(tag);
        return this;
    }

    public SmithingTableRecipe setAddition(class_1935 ... items) {
        this.alright &= BCLRecipeManager.exists(items);
        this.addition = class_1856.method_8091((class_1935[])items);
        return this;
    }

    public SmithingTableRecipe setAddition(class_3494<class_1792> tag) {
        this.addition = class_1856.method_8106(tag);
        return this;
    }

    public void build() {
        if (!this.exist) {
            return;
        }
        if (this.base == null) {
            BCLib.LOGGER.warning("Base input for Smithing recipe can't be 'null', recipe {} will be ignored!", this.id);
            return;
        }
        if (this.addition == null) {
            BCLib.LOGGER.warning("Addition input for Smithing recipe can't be 'null', recipe {} will be ignored!", this.id);
            return;
        }
        if (this.result == null) {
            BCLib.LOGGER.warning("Result for Smithing recipe can't be 'null', recipe {} will be ignored!", this.id);
            return;
        }
        if (BCLRecipeManager.getRecipe(TYPE, this.id) != null) {
            BCLib.LOGGER.warning("Can't add Smithing recipe! Id {} already exists!", this.id);
            return;
        }
        if (!this.alright) {
            BCLib.LOGGER.debug("Can't add Smithing recipe {}! Ingeredients or output not exists.", this.id);
            return;
        }
        BCLRecipeManager.addRecipe(TYPE, new class_5357(this.id, this.base, this.addition, this.result));
    }
}

