/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3494;

public class TagHelper {
    private static final Map<class_2960, Set<class_2960>> TAGS_BLOCK = Maps.newConcurrentMap();
    private static final Map<class_2960, Set<class_2960>> TAGS_ITEM = Maps.newConcurrentMap();

    public static void addTag(class_3494.class_5123<class_2248> tag, class_2248 ... blocks) {
        class_2960 tagID = tag.method_26791();
        Set set = TAGS_BLOCK.computeIfAbsent(tagID, k -> Sets.newHashSet());
        for (class_2248 block : blocks) {
            class_2960 id = class_2378.field_11146.method_10221((Object)block);
            if (id == class_2378.field_11146.method_10137()) continue;
            set.add(id);
        }
    }

    public static void addTag(class_3494.class_5123<class_1792> tag, class_1935 ... items) {
        class_2960 tagID = tag.method_26791();
        Set set = TAGS_ITEM.computeIfAbsent(tagID, k -> Sets.newHashSet());
        for (class_1935 item : items) {
            class_2960 id = class_2378.field_11142.method_10221((Object)item.method_8389());
            if (id == class_2378.field_11142.method_10137()) continue;
            set.add(id);
        }
    }

    @SafeVarargs
    public static void addTags(class_1935 item, class_3494.class_5123<class_1792> ... tags) {
        for (class_3494.class_5123<class_1792> tag : tags) {
            TagHelper.addTag(tag, item);
        }
    }

    @SafeVarargs
    public static void addTags(class_2248 block, class_3494.class_5123<class_2248> ... tags) {
        for (class_3494.class_5123<class_2248> tag : tags) {
            TagHelper.addTag(tag, block);
        }
    }

    public static class_3494.class_3495 apply(class_3494.class_3495 builder, Set<class_2960> ids) {
        ids.forEach(value -> builder.method_26784(value, "Better End Code"));
        return builder;
    }

    public static Map<class_2960, class_3494.class_3495> apply(String entry, Map<class_2960, class_3494.class_3495> tagsMap) {
        Map<class_2960, Set<class_2960>> endTags = null;
        if (entry.equals("block")) {
            endTags = TAGS_BLOCK;
        } else if (entry.equals("item")) {
            endTags = TAGS_ITEM;
        }
        if (endTags != null) {
            endTags.forEach((id, ids) -> TagHelper.apply(tagsMap.computeIfAbsent((class_2960)id, key -> class_3494.class_3495.method_26778()), ids));
        }
        return tagsMap;
    }
}

