/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.world.generator;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_2919;
import ru.bclib.noise.OpenSimplexNoise;
import ru.bclib.util.MHelper;
import ru.bclib.world.biomes.BCLBiome;
import ru.bclib.world.generator.BiomeChunk;
import ru.bclib.world.generator.BiomePicker;

public class BiomeMap {
    private static final class_2919 RANDOM = new class_2919();
    private final Map<class_1923, BiomeChunk> maps = Maps.newHashMap();
    private final int size;
    private final int sizeXZ;
    private final int depth;
    private final OpenSimplexNoise noiseX;
    private final OpenSimplexNoise noiseZ;
    private final BiomePicker picker;
    private final long seed;

    public BiomeMap(long seed, int size, BiomePicker picker) {
        this.maps.clear();
        RANDOM.setSeed(seed);
        this.noiseX = new OpenSimplexNoise(RANDOM.nextLong());
        this.noiseZ = new OpenSimplexNoise(RANDOM.nextLong());
        this.sizeXZ = size;
        this.depth = (int)Math.ceil(Math.log(size) / Math.log(2.0)) - 2;
        this.size = 1 << this.depth;
        this.picker = picker;
        this.seed = seed;
    }

    public long getSeed() {
        return this.seed;
    }

    public void clearCache() {
        if (this.maps.size() > 32) {
            this.maps.clear();
        }
    }

    private BCLBiome getRawBiome(int bx, int bz) {
        class_1923 cpos;
        BiomeChunk chunk;
        double x = (double)bx * (double)this.size / (double)this.sizeXZ;
        double z = (double)bz * (double)this.size / (double)this.sizeXZ;
        double nx = x;
        double nz = z;
        double px = (double)bx * 0.2;
        double pz = (double)bz * 0.2;
        for (int i = 0; i < this.depth; ++i) {
            nx = (x + this.noiseX.eval(px, pz)) / 2.0;
            nz = (z + this.noiseZ.eval(px, pz)) / 2.0;
            x = nx;
            z = nz;
            px = px / 2.0 + (double)i;
            pz = pz / 2.0 + (double)i;
        }
        bx = MHelper.floor(x);
        bz = MHelper.floor(z);
        if ((bx & 0xF) == 15) {
            x += (double)(bz / 2 & 1);
        }
        if ((bz & 0xF) == 15) {
            z += (double)(bx / 2 & 1);
        }
        if ((chunk = this.maps.get(cpos = new class_1923(MHelper.floor(x / 16.0), MHelper.floor(z / 16.0)))) == null) {
            RANDOM.method_12659(cpos.field_9181, cpos.field_9180);
            chunk = new BiomeChunk(this, (Random)RANDOM, this.picker);
            this.maps.put(cpos, chunk);
        }
        return chunk.getBiome(MHelper.floor(x), MHelper.floor(z));
    }

    public BCLBiome getBiome(int x, int z) {
        BCLBiome biome = this.getRawBiome(x, z);
        if (biome.hasEdge() || biome.hasParentBiome() && biome.getParentBiome().hasEdge()) {
            int d;
            BCLBiome search = biome;
            if (biome.hasParentBiome()) {
                search = biome.getParentBiome();
            }
            boolean edge = !search.isSame(this.getRawBiome(x + (d = (int)Math.ceil((float)search.getEdgeSize() / 4.0f) << 2), z));
            edge = edge || !search.isSame(this.getRawBiome(x - d, z));
            edge = edge || !search.isSame(this.getRawBiome(x, z + d));
            edge = edge || !search.isSame(this.getRawBiome(x, z - d));
            edge = edge || !search.isSame(this.getRawBiome(x - 1, z - 1));
            edge = edge || !search.isSame(this.getRawBiome(x - 1, z + 1));
            edge = edge || !search.isSame(this.getRawBiome(x + 1, z - 1));
            boolean bl = edge = edge || !search.isSame(this.getRawBiome(x + 1, z + 1));
            if (edge) {
                biome = search.getEdge();
            }
        }
        return biome;
    }
}

