/*
 * Decompiled with CFR 0.152.
 */
package com.slomaxonical.architectspalette.common.blocks.abyssaline;

import com.slomaxonical.architectspalette.common.blocks.abyssaline.IAbyssalineChargeable;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class AbyssalineHelper {
    public static final int CHARGE_LIGHT = 1;
    private static final int RECURSION_MAX = 12;

    public static boolean needsPostProcessing(class_2680 stateIn, class_1922 reader, class_2338 pos) {
        return ((IAbyssalineChargeable)stateIn.method_26204()).isCharged(stateIn);
    }

    public static boolean allowsMobSpawning(class_2680 stateIn, class_1922 reader, class_2338 pos, class_1299<?> entity) {
        return !((IAbyssalineChargeable)stateIn.method_26204()).isCharged(stateIn);
    }

    public static boolean isAbyssaline(class_2680 stateIn) {
        return stateIn.method_26204() instanceof IAbyssalineChargeable;
    }

    public static boolean getCharged(class_2680 stateIn) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return false;
        }
        IAbyssalineChargeable block = (IAbyssalineChargeable)stateIn.method_26204();
        return block.isCharged(stateIn);
    }

    public static boolean getOutputsFrom(class_2680 stateIn, class_2350 faceIn) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return false;
        }
        IAbyssalineChargeable block = (IAbyssalineChargeable)stateIn.method_26204();
        return block.outputsChargeFrom(stateIn, faceIn);
    }

    public static boolean getAcceptsCharge(class_2680 stateIn, class_2350 faceIn) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return false;
        }
        IAbyssalineChargeable block = (IAbyssalineChargeable)stateIn.method_26204();
        return block.acceptsChargeFrom(stateIn, faceIn);
    }

    public static boolean getPushesPower(class_2680 stateIn) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return false;
        }
        return ((IAbyssalineChargeable)stateIn.method_26204()).pushesPower(stateIn);
    }

    public static boolean getPullsPower(class_2680 stateIn, class_2350 faceIn) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return false;
        }
        return ((IAbyssalineChargeable)stateIn.method_26204()).pullsPowerFrom(stateIn, faceIn);
    }

    public static boolean isValidConnection(class_2680 unpoweredState, class_2680 poweringState, class_2350 unpoweredFace) {
        return (AbyssalineHelper.getAcceptsCharge(unpoweredState, unpoweredFace) || AbyssalineHelper.getPushesPower(poweringState)) && (AbyssalineHelper.getOutputsFrom(poweringState, unpoweredFace.method_10153()) || AbyssalineHelper.getCharged(poweringState) && AbyssalineHelper.getPullsPower(unpoweredState, unpoweredFace));
    }

    @Nullable
    public static class_2680 getChargedState(class_2680 stateIn, boolean charge) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return null;
        }
        return ((IAbyssalineChargeable)stateIn.method_26204()).getStateWithCharge(stateIn, charge);
    }

    @Nullable
    public static class_2680 getStateWithChargeDirection(class_2680 stateIn, class_2350 faceOut) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return null;
        }
        return ((IAbyssalineChargeable)stateIn.method_26204()).getStateWithChargeDirection(stateIn, faceOut);
    }

    public static boolean createsChargeLoop(class_2680 startState, class_1936 world, class_2338 pos) {
        class_2338.class_2339 accumulator = new class_2338(0, 0, 0).method_25503();
        return AbyssalineHelper.checkForLoop(startState, world, pos, 12, accumulator, startState);
    }

    private static boolean checkForLoop(class_2680 startState, class_1936 world, class_2338 pos, int tries, class_2338.class_2339 accumulator, class_2680 chainStarter) {
        class_2350 facing;
        if (!(startState.method_26204() instanceof IAbyssalineChargeable)) {
            return false;
        }
        IAbyssalineChargeable startBlock = (IAbyssalineChargeable)startState.method_26204();
        class_2338 offset = startBlock.getSourceOffset(startState);
        class_2338 nextPos = pos.method_10081((class_2382)offset);
        if (nextPos == pos) {
            return false;
        }
        if (AbyssalineHelper.isAllZero((class_2338)accumulator.method_10100(offset.method_10263(), offset.method_10264(), offset.method_10260()))) {
            return true;
        }
        if (AbyssalineHelper.isMagnitudeOne((class_2338)accumulator) && tries < 12 && AbyssalineHelper.isValidConnection(AbyssalineHelper.getStateWithChargeDirection(chainStarter, facing = AbyssalineHelper.directionFromOffset((class_2338)accumulator)), world.method_8320(pos.method_10093(facing)), facing)) {
            return true;
        }
        class_2680 nextState = world.method_8320(nextPos);
        if (!AbyssalineHelper.getCharged(nextState)) {
            return true;
        }
        if (--tries > 0) {
            return AbyssalineHelper.checkForLoop(nextState, world, nextPos, tries, accumulator, chainStarter);
        }
        return false;
    }

    private static boolean isAllZero(class_2338 pos) {
        return pos.method_10264() == 0 && pos.method_10263() == 0 && pos.method_10260() == 0;
    }

    private static boolean isMagnitudeOne(class_2338 pos) {
        return Math.abs(pos.method_10264()) + Math.abs(pos.method_10263()) + Math.abs(pos.method_10260()) == 1;
    }

    private static class_2350 directionFromOffset(class_2338 pos) {
        int x = Math.abs(pos.method_10263());
        int y = Math.abs(pos.method_10264());
        int z = Math.abs(pos.method_10260());
        int max = Math.max(Math.max(x, y), z);
        if (x == max) {
            return pos.method_10263() > 0 ? class_2350.field_11034 : class_2350.field_11039;
        }
        if (y == max) {
            return pos.method_10264() > 0 ? class_2350.field_11036 : class_2350.field_11033;
        }
        return pos.method_10260() > 0 ? class_2350.field_11035 : class_2350.field_11043;
    }

    public static class_2680 getStateWithNeighborCharge(class_2680 stateIn, class_1936 world, class_2338 pos) {
        class_2350 source = null;
        boolean powered = false;
        for (class_2350 side : class_2350.values()) {
            class_2338 offset = pos.method_10093(side);
            class_2680 state = world.method_8320(offset);
            if (!AbyssalineHelper.isValidConnection(stateIn, state, side) || AbyssalineHelper.createsChargeLoop(AbyssalineHelper.getStateWithChargeDirection(stateIn, side), world, pos)) continue;
            source = side;
            powered = true;
            break;
        }
        if (source != null) {
            return AbyssalineHelper.getChargedState(AbyssalineHelper.getStateWithChargeDirection(stateIn, source), powered);
        }
        return AbyssalineHelper.getChargedState(stateIn, false);
    }

    public static void abyssalineTick(class_2680 state, class_3218 worldIn, class_2338 pos) {
        worldIn.method_8652(pos, AbyssalineHelper.getStateWithNeighborCharge(state, (class_1936)worldIn, pos), 7);
    }

    public static void abyssalineNeighborUpdate(IAbyssalineChargeable thiz, class_2680 stateIn, class_1937 worldIn, class_2338 pos, class_2248 neighborBlock, class_2338 neighborPos) {
        boolean interested;
        boolean bl = interested = !thiz.isCharged(stateIn) && neighborBlock instanceof IAbyssalineChargeable || !AbyssalineHelper.isValidConnection(stateIn, worldIn.method_8320(pos.method_10081((class_2382)thiz.getSourceOffset(stateIn))), thiz.getSourceDirection(stateIn));
        if (neighborPos.equals((Object)pos.method_10081((class_2382)thiz.getSourceOffset(stateIn))) || interested) {
            worldIn.method_8397().method_8676(pos, (Object)((class_2248)thiz), 1);
        }
    }
}

