/*
 * Decompiled with CFR 0.152.
 */
package me.benfah.doorsofinfinity.dimension;

import java.util.function.Function;
import java.util.function.IntPredicate;
import me.benfah.doorsofinfinity.block.InfinityBlock;
import me.benfah.doorsofinfinity.block.entity.InfinityDoorBlockEntity;
import me.benfah.doorsofinfinity.config.DOFConfig;
import me.benfah.doorsofinfinity.init.DOFBlocks;
import me.benfah.doorsofinfinity.init.DOFDimensions;
import me.benfah.doorsofinfinity.utils.MCUtils;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class InfinityDimHelper {
    public static PersonalDimension getEmptyPersonalDimension() {
        class_3218 infinityDim = MCUtils.getServer().method_3847(DOFDimensions.INFINITY_DIM);
        class_2338 basePos = new class_2338(0, 3, 0);
        int offset = 0;
        while (!infinityDim.method_8320(basePos.method_10069(offset * 200, 0, 0)).method_26215()) {
            ++offset;
        }
        return new PersonalDimension(offset, infinityDim);
    }

    public static PersonalDimension getPersonalDimension(int id, int upgrades) {
        class_3218 infinityDim = MCUtils.getServer().method_3847(DOFDimensions.INFINITY_DIM);
        return new PersonalDimension(id, upgrades, infinityDim);
    }

    public PersonalDimension getPersonalDimensionAt(class_2338 pos) {
        return new PersonalDimension(pos.method_10263() / 200, MCUtils.getServer().method_3847(DOFDimensions.INFINITY_DIM));
    }

    public static class_3218 getInfinityDimension() {
        return MCUtils.getServer().method_3847(DOFDimensions.INFINITY_DIM);
    }

    public static class PersonalDimension {
        private static int INNER_SIZE = DOFConfig.getInstance().dimensionSize;
        private static int WALL_THICKNESS = 2;
        private static int UPGRADE_MULTIPLIER = 8;
        private int dimId;
        private class_3218 world;
        private int upgrades = 0;

        public PersonalDimension(int dimOffset, int upgrades, class_3218 world) {
            this(dimOffset, world);
            this.upgrades = upgrades;
        }

        public PersonalDimension(int dimOffset, class_3218 world) {
            this.dimId = dimOffset;
            this.world = world;
        }

        public class_243 getBasePosition() {
            return new class_243((double)(200 * this.dimId), 3.0, 0.0);
        }

        public int getDimensionOffset() {
            return this.dimId;
        }

        public class_243 getPlayerPosCentered() {
            class_2338 playerPos = this.getPlayerPos();
            return new class_243((double)playerPos.method_10263(), (double)playerPos.method_10264(), (double)playerPos.method_10260()).method_1031(0.5, 0.0, 0.5);
        }

        public int getInnerSize() {
            return INNER_SIZE + this.getUpgrades() * UPGRADE_MULTIPLIER;
        }

        public int getUpgrades() {
            return this.upgrades;
        }

        public boolean upgrade() {
            if (this.upgrades >= DOFConfig.getInstance().maxUpgrades) {
                return false;
            }
            int prevInnerSize = this.getInnerSize();
            InfinityDoorBlockEntity linkedBlockEntity = this.getBlockEntity().getSyncEntity();
            linkedBlockEntity.deleteLocalPortal();
            linkedBlockEntity.deleteSyncPortal();
            ++linkedBlockEntity.installedUpgrades;
            this.upgrades = linkedBlockEntity.installedUpgrades;
            this.generateCube(this.getBasePosition(), prevInnerSize, WALL_THICKNESS, vec -> {
                if (vec.method_10264() >= WALL_THICKNESS) {
                    return class_2246.field_10124.method_9564();
                }
                return (class_2680)DOFBlocks.GENERATED_INFINITY_BLOCK.method_9564().method_11657(InfinityBlock.COLOR, (Comparable)((Object)InfinityBlock.Color.WHITE));
            });
            this.generateCube(this.getBasePosition(), this.getInnerSize(), WALL_THICKNESS, vec -> {
                if (vec.method_10264() >= WALL_THICKNESS) {
                    return DOFBlocks.GENERATED_INFINITY_BLOCK.method_9564();
                }
                return (class_2680)DOFBlocks.GENERATED_INFINITY_BLOCK.method_9564().method_11657(InfinityBlock.COLOR, (Comparable)((Object)InfinityBlock.Color.WHITE));
            });
            linkedBlockEntity.placeSyncedDoor((class_1937)this.world, this.getPlayerPos());
            return true;
        }

        private InfinityDoorBlockEntity getBlockEntity() {
            return (InfinityDoorBlockEntity)this.world.method_8321(this.getPlayerPos());
        }

        public class_2338 getPlayerPos() {
            return new class_2338(this.getBasePosition().method_1031(Math.floor(this.getInnerSize() / 2) + (double)WALL_THICKNESS, 3.0, (double)(this.getInnerSize() + WALL_THICKNESS)));
        }

        public void generate() {
            this.generateCube(this.getBasePosition(), this.getInnerSize(), WALL_THICKNESS, vec -> {
                if (vec.method_10264() >= WALL_THICKNESS) {
                    return DOFBlocks.GENERATED_INFINITY_BLOCK.method_9564();
                }
                return (class_2680)DOFBlocks.GENERATED_INFINITY_BLOCK.method_9564().method_11657(InfinityBlock.COLOR, (Comparable)((Object)InfinityBlock.Color.WHITE));
            });
            this.resetDoor();
        }

        private void resetDoor() {
            class_2338 spawnPos = this.getPlayerPos();
            this.world.method_8501(spawnPos, class_2246.field_10124.method_9564());
            this.world.method_8501(spawnPos.method_10084(), class_2246.field_10124.method_9564());
        }

        public void generateCube(class_243 basePosition, int innerSize, int wallThickness, Function<class_2382, class_2680> stateFunction) {
            for (int i = 0; i < innerSize + wallThickness * 2; ++i) {
                for (int j = 0; j < innerSize + wallThickness * 2; ++j) {
                    for (int k = 0; k < innerSize + wallThickness * 2; ++k) {
                        class_2680 state;
                        class_2338 pos = new class_2338(basePosition.field_1352 + (double)i, basePosition.field_1351 + (double)j, basePosition.field_1350 + (double)k);
                        IntPredicate allowed = a -> a <= wallThickness - 1 || a >= innerSize + wallThickness;
                        if (!allowed.test(i) && !allowed.test(j) && !allowed.test(k) || (state = stateFunction.apply(new class_2382(i, j, k))) == null) continue;
                        this.world.method_8501(pos, state);
                    }
                }
            }
        }
    }
}

