/*
 * Decompiled with CFR 0.152.
 */
package com.aqupd.grizzlybear.entities;

import com.aqupd.grizzlybear.Main;
import com.aqupd.grizzlybear.ai.GrizzlyBearFishGoal;
import com.aqupd.grizzlybear.utils.AqConfig;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1391;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1428;
import net.minecraft.class_1429;
import net.minecraft.class_1463;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4019;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4801;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;

public class GrizzlyBearEntity
extends class_1429
implements class_5354 {
    private static final class_2940<Boolean> WARNING;
    private float lastWarningAnimationProgress;
    private float warningAnimationProgress;
    private int warningSoundCooldown;
    private static final class_4801 ANGER_TIME_RANGE;
    private static final class_1856 LOVINGFOOD;
    private int angerTime;
    private UUID targetUuid;
    private static double health;
    private static double speed;
    private static double follow;
    private static double damage;
    private static int angermin;
    private static int angermax;
    private static boolean friendly;

    public GrizzlyBearEntity(class_1299<? extends GrizzlyBearEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)Main.GRIZZLYBEAR.method_5883((class_1937)world);
    }

    public boolean method_6481(class_1799 stack) {
        return LOVINGFOOD.method_8093(stack);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        boolean bl = this.method_6481(player.method_5998(hand));
        if (!bl && !player.method_21823()) {
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        return super.method_5992(player, hand);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new AttackGoal());
        this.field_6201.method_6277(1, (class_1352)new GrizzlyBearEscapeDangerGoal());
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.0, false, LOVINGFOOD));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.25));
        this.field_6201.method_6277(5, (class_1352)new GrizzlyBearFishGoal(this, 1.0, 20));
        this.field_6201.method_6277(5, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new GrizzlyBearRevengeGoal());
        if (!friendly) {
            this.field_6185.method_6277(2, (class_1352)new FollowPlayersGoal());
            this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, arg_0 -> ((GrizzlyBearEntity)this).method_29515(arg_0)));
            this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_4019.class, 10, true, true, null));
            this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1463.class, 10, true, true, null));
            this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1428.class, 10, true, true, null));
            this.field_6185.method_6277(5, (class_1352)new class_5398((class_1308)this, false));
        }
    }

    public static class_5132.class_5133 createGrizzlyBearAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, health).method_26868(class_5134.field_23717, follow).method_26868(class_5134.field_23719, speed).method_26868(class_5134.field_23721, damage);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.method_29512((class_3218)this.field_6002, tag);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        this.method_29517(tag);
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_24503(this.field_5974));
    }

    public void method_29514(int ticks) {
        this.angerTime = ticks;
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void method_29513(@Nullable UUID uuid) {
        this.targetUuid = uuid;
    }

    public UUID method_29508() {
        return this.targetUuid;
    }

    protected class_3414 method_5994() {
        return this.method_6109() ? Main.GRIZZLY_BEAR_AMBIENT_BABY : Main.GRIZZLY_BEAR_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return Main.GRIZZLY_BEAR_HURT;
    }

    protected class_3414 method_6002() {
        return Main.GRIZZLY_BEAR_DEATH;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(Main.GRIZZLY_BEAR_STEP, 0.15f, 1.0f);
    }

    protected void playWarningSound() {
        if (this.warningSoundCooldown <= 0) {
            this.method_5783(Main.GRIZZLY_BEAR_WARNING, 1.0f, this.method_6017());
            this.warningSoundCooldown = 40;
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(WARNING, (Object)false);
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6002.field_9236) {
            if (this.warningAnimationProgress != this.lastWarningAnimationProgress) {
                this.method_18382();
            }
            this.lastWarningAnimationProgress = this.warningAnimationProgress;
            this.warningAnimationProgress = this.isWarning() ? class_3532.method_15363((float)(this.warningAnimationProgress + 1.0f), (float)0.0f, (float)6.0f) : class_3532.method_15363((float)(this.warningAnimationProgress - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundCooldown > 0) {
            --this.warningSoundCooldown;
        }
        if (!this.field_6002.field_9236) {
            this.method_29510((class_3218)this.field_6002, true);
        }
    }

    public class_4048 method_18377(class_4050 pose) {
        if (this.warningAnimationProgress > 0.0f) {
            float f = this.warningAnimationProgress / 6.0f;
            float g = 1.0f + f;
            return super.method_18377(pose).method_19539(1.0f, g);
        }
        return super.method_18377(pose);
    }

    public boolean method_6121(class_1297 target) {
        boolean bl = target.method_5643(class_1282.method_5511((class_1309)this), (float)((int)this.method_26825(class_5134.field_23721)));
        if (bl) {
            this.method_5723((class_1309)this, target);
        }
        return bl;
    }

    public boolean isWarning() {
        return (Boolean)this.field_6011.method_12789(WARNING);
    }

    public void setWarning(boolean warning) {
        this.field_6011.method_12778(WARNING, (Object)warning);
    }

    @Environment(value=EnvType.CLIENT)
    public float getWarningAnimationProgress(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.lastWarningAnimationProgress, (float)this.warningAnimationProgress) / 6.0f;
    }

    protected float method_6120() {
        return 0.98f;
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        if (entityData == null) {
            entityData = new class_1296.class_4697(1.0f);
        }
        return super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
    }

    static {
        health = AqConfig.INSTANCE.getDoubleProperty("entity.health");
        speed = AqConfig.INSTANCE.getDoubleProperty("entity.speed");
        follow = AqConfig.INSTANCE.getDoubleProperty("entity.follow");
        damage = AqConfig.INSTANCE.getDoubleProperty("entity.damage");
        angermin = AqConfig.INSTANCE.getNumberProperty("entity.angertimemin");
        angermax = AqConfig.INSTANCE.getNumberProperty("entity.angertimemax");
        friendly = AqConfig.INSTANCE.getBooleanProperty("entity.friendlytoplayer");
        WARNING = class_2945.method_12791(GrizzlyBearEntity.class, (class_2941)class_2943.field_13323);
        ANGER_TIME_RANGE = class_4802.method_24505((int)angermin, (int)angermax);
        LOVINGFOOD = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8429, class_1802.field_8209, class_1802.field_16998});
    }

    class AttackGoal
    extends class_1366 {
        public AttackGoal() {
            super((class_1314)GrizzlyBearEntity.this, 1.25, true);
        }

        protected void method_6288(class_1309 target, double squaredDistance) {
            double d = this.method_6289(target);
            if (squaredDistance <= d && this.method_28347()) {
                this.method_28346();
                this.field_6503.method_6121((class_1297)target);
                GrizzlyBearEntity.this.setWarning(false);
            } else if (squaredDistance <= d * 2.0) {
                if (this.method_28347()) {
                    GrizzlyBearEntity.this.setWarning(false);
                    this.method_28346();
                }
                if (this.method_28348() <= 10) {
                    GrizzlyBearEntity.this.setWarning(true);
                    GrizzlyBearEntity.this.playWarningSound();
                }
            } else {
                this.method_28346();
                GrizzlyBearEntity.this.setWarning(false);
            }
        }

        public void method_6270() {
            GrizzlyBearEntity.this.setWarning(false);
            super.method_6270();
        }

        protected double method_6289(class_1309 entity) {
            return 4.0f + entity.method_17681();
        }
    }

    class GrizzlyBearEscapeDangerGoal
    extends class_1374 {
        public GrizzlyBearEscapeDangerGoal() {
            super((class_1314)GrizzlyBearEntity.this, 2.0);
        }

        public boolean method_6264() {
            return (GrizzlyBearEntity.this.method_6109() || GrizzlyBearEntity.this.method_5809()) && super.method_6264();
        }
    }

    class GrizzlyBearRevengeGoal
    extends class_1399 {
        public GrizzlyBearRevengeGoal() {
            super((class_1314)GrizzlyBearEntity.this, new Class[0]);
        }

        public void method_6269() {
            super.method_6269();
            if (GrizzlyBearEntity.this.method_6109()) {
                this.method_6317();
                this.method_6270();
            }
        }

        protected void method_6319(class_1308 mob, class_1309 target) {
            if (mob instanceof GrizzlyBearEntity && !mob.method_6109()) {
                super.method_6319(mob, target);
            }
        }
    }

    class FollowPlayersGoal
    extends class_1400<class_1657> {
        public FollowPlayersGoal() {
            super((class_1308)GrizzlyBearEntity.this, class_1657.class, 20, true, true, null);
        }

        public boolean method_6264() {
            if (!GrizzlyBearEntity.this.method_6109() && super.method_6264()) {
                List list = GrizzlyBearEntity.this.field_6002.method_18467(GrizzlyBearEntity.class, GrizzlyBearEntity.this.method_5829().method_1009(8.0, 4.0, 8.0));
                for (GrizzlyBearEntity grizzlyBearEntity : list) {
                    if (!grizzlyBearEntity.method_6109()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double method_6326() {
            return super.method_6326() * 0.5;
        }
    }
}

