/*
 * Decompiled with CFR 0.152.
 */
package uk.me.desert_island.rer.rei_stuff;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeDisplay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_176;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_638;
import uk.me.desert_island.rer.RERUtils;
import uk.me.desert_island.rer.RoughlyEnoughResources;
import uk.me.desert_island.rer.client.ClientLootCache;
import uk.me.desert_island.rer.rei_stuff.LootCategory;
import uk.me.desert_island.rer.rei_stuff.LootOutput;

@Environment(value=EnvType.CLIENT)
public abstract class LootDisplay
implements RecipeDisplay {
    public EntryStack inputStack;
    public class_2960 lootTableId;
    public class_176 contextType;
    public List<LootOutput> outputs = null;
    public static final NumberFormat FORMAT = new DecimalFormat("#.##");
    public static final NumberFormat FORMAT_MORE = new DecimalFormat("#.####");

    public List<List<EntryStack>> getInputEntries() {
        return Collections.singletonList(Collections.singletonList(this.inputStack));
    }

    public abstract class_2960 getLocation();

    public List<EntryStack> getOutputEntries() {
        ArrayList stacks = Lists.newArrayList();
        for (LootOutput output : this.getOutputs()) {
            stacks.add(output.original);
        }
        return stacks;
    }

    public List<EntryStack> getFlattenedOutputEntries() {
        ArrayList stacks = Lists.newArrayList();
        for (List<EntryStack> entry : this.getFullOutputEntries()) {
            if (entry.isEmpty()) {
                stacks.add(EntryStack.empty());
                continue;
            }
            stacks.add(entry.get(0));
        }
        return stacks;
    }

    public List<List<EntryStack>> getFullOutputEntries() {
        ArrayList stacks = Lists.newArrayList();
        for (LootOutput output : this.getOutputs()) {
            stacks.add(output.output);
        }
        return stacks;
    }

    public class_2960 getRecipeCategory() {
        return LootCategory.CATEGORY_ID;
    }

    public List<LootOutput> munchLootEntryAlternativesJson(JsonObject object) {
        ArrayList<LootOutput> outputs = new ArrayList<LootOutput>();
        JsonArray children = object.get("children").getAsJsonArray();
        for (JsonElement child : children) {
            outputs.addAll(this.munchLootEntryJson(child.getAsJsonObject()));
        }
        if (object.getAsJsonObject().has("conditions")) {
            for (JsonElement conditionElement : object.getAsJsonObject().get("conditions").getAsJsonArray()) {
                this.munchLootCondition(conditionElement, outputs);
            }
        }
        if (object.getAsJsonObject().has("functions")) {
            ArrayList<LootOutput> newOutputs = new ArrayList<LootOutput>();
            for (JsonElement functionElement : object.getAsJsonObject().get("functions").getAsJsonArray()) {
                List<LootOutput> list = this.munchLootFunctions(functionElement, outputs);
                if (list == null) continue;
                newOutputs.addAll(list);
            }
            outputs.addAll(newOutputs);
        }
        return outputs;
    }

    public List<LootOutput> munchLootEntryItemJson(JsonObject object) {
        class_1792 item = (class_1792)class_2378.field_11142.method_10223(new class_2960(object.get("name").getAsString()));
        EntryStack stack = EntryStack.create((class_1935)item);
        LootOutput output = new LootOutput();
        output.output = Lists.newArrayList((Object[])new EntryStack[]{stack});
        output.original = stack.copy();
        ArrayList<LootOutput> outputs = new ArrayList<LootOutput>();
        outputs.add(output);
        return outputs;
    }

    public void munchLootCondition(JsonElement conditionElement, List<LootOutput> outputs) {
        JsonObject conditionObject = conditionElement.getAsJsonObject();
        String kind = new class_2960(conditionObject.get("condition").getAsString()).toString();
        if (kind.equals("minecraft:inverted")) {
            for (LootOutput output : outputs) {
                output.nowInverted = !output.nowInverted;
                output.lastInverted = false;
            }
            if (conditionObject.has("term")) {
                this.munchLootCondition((JsonElement)conditionObject.get("term").getAsJsonObject(), outputs);
            }
            if (conditionObject.has("terms")) {
                for (JsonElement alternateCondition : conditionObject.get("terms").getAsJsonArray()) {
                    this.munchLootCondition(alternateCondition, outputs);
                }
            }
            for (LootOutput output : outputs) {
                output.nowInverted = !output.nowInverted;
                output.lastInverted = false;
            }
        } else if (kind.equals("minecraft:alternative")) {
            if (conditionObject.has("term")) {
                this.munchLootCondition((JsonElement)conditionObject.get("term").getAsJsonObject(), outputs);
            }
            if (conditionObject.has("terms")) {
                for (JsonElement alternateCondition : conditionObject.get("terms").getAsJsonArray()) {
                    this.munchLootCondition(alternateCondition, outputs);
                }
            }
        } else if (kind.equals("minecraft:killed_by_player")) {
            for (LootOutput output : outputs) {
                output.addExtraText(class_1074.method_4662((String)"rer.condition.killedByPlayer", (Object[])new Object[0]));
            }
        } else if (!kind.equals("minecraft:survives_explosion")) {
            if (kind.equals("minecraft:entity_properties") && conditionObject.has("predicate") && conditionObject.get("predicate").getAsJsonObject().has("flags") && conditionObject.get("predicate").getAsJsonObject().get("flags").getAsJsonObject().has("is_on_fire") && conditionObject.get("predicate").getAsJsonObject().get("flags").getAsJsonObject().get("is_on_fire").getAsBoolean() && conditionObject.has("entity") && conditionObject.get("entity").getAsString().equals("this")) {
                for (LootOutput output : outputs) {
                    output.addExtraText(class_1074.method_4662((String)"rer.condition.onFire", (Object[])new Object[0]));
                }
            } else if (!(kind.equals("minecraft:block_state_property") || kind.equals("minecraft:entity_properties") || kind.equals("minecraft:damage_source_properties"))) {
                if (kind.equals("minecraft:match_tool") && conditionObject.has("predicate") && conditionObject.get("predicate").getAsJsonObject().has("enchantments")) {
                    for (JsonElement enchantmentElement : conditionObject.get("predicate").getAsJsonObject().get("enchantments").getAsJsonArray()) {
                        JsonObject enchantmentObject = enchantmentElement.getAsJsonObject();
                        String enchantmentString = enchantmentObject.get("enchantment").getAsString();
                        class_1887 enchantment = (class_1887)class_2378.field_11160.method_10223(new class_2960(enchantmentString));
                        if (enchantment == null) continue;
                        for (LootOutput output : outputs) {
                            output.addExtraText(class_1074.method_4662((String)"rer.condition.enchantment", (Object[])new Object[]{class_1074.method_4662((String)enchantment.method_8184(), (Object[])new Object[0]).toLowerCase()}));
                        }
                    }
                } else if (kind.equals("minecraft:random_chance") && conditionObject.has("chance")) {
                    double chance = conditionObject.get("chance").getAsDouble() * 100.0;
                    for (LootOutput output : outputs) {
                        output.addExtraText(class_1074.method_4662((String)"rer.condition.chance", (Object[])new Object[]{FORMAT.format(chance)}));
                    }
                } else if (kind.equals("minecraft:random_chance_with_looting") && conditionObject.has("chance")) {
                    double chance = conditionObject.get("chance").getAsDouble() * 100.0;
                    for (LootOutput output : outputs) {
                        output.addExtraText(class_1074.method_4662((String)"rer.condition.chance.looting", (Object[])new Object[]{FORMAT.format(chance)}));
                    }
                } else if (kind.equals("minecraft:match_tool") && conditionObject.has("predicate") && conditionObject.get("predicate").getAsJsonObject().has("item")) {
                    String itemId = conditionObject.get("predicate").getAsJsonObject().get("item").getAsString();
                    class_1792 item = (class_1792)class_2378.field_11142.method_10223(new class_2960(itemId));
                    for (LootOutput output : outputs) {
                        output.addExtraText(class_1074.method_4662((String)"rer.condition.item", (Object[])new Object[]{item.method_7848().getString().toLowerCase()}));
                    }
                } else if (kind.equals("minecraft:table_bonus")) {
                    double chance = conditionObject.get("chances").getAsJsonArray().get(0).getAsDouble() * 100.0;
                    for (LootOutput output : outputs) {
                        output.addExtraText(class_1074.method_4662((String)"rer.condition.chance", (Object[])new Object[]{FORMAT.format(chance)}));
                    }
                } else {
                    RERUtils.LOGGER.debug("Don't know how to deal with condition of type %s (%s)", kind, conditionObject);
                }
            }
        }
    }

    public List<LootOutput> munchLootEntryJson(JsonObject object) {
        String type = new class_2960(object.get("type").getAsString()).toString();
        ArrayList<LootOutput> outputs = new ArrayList<LootOutput>();
        switch (type) {
            case "minecraft:item": {
                outputs.addAll(this.munchLootEntryItemJson(object));
                break;
            }
            case "minecraft:alternatives": {
                outputs.addAll(this.munchLootEntryAlternativesJson(object));
                break;
            }
            case "minecraft:empty": {
                break;
            }
            case "minecraft:loot_table": {
                String json = ClientLootCache.ID_TO_LOOT.get(new class_2960(object.get("name").getAsString()));
                if (json == null) break;
                outputs.addAll(this.munchLootSupplierJson((JsonElement)RoughlyEnoughResources.GSON.fromJson(json, JsonElement.class)));
                break;
            }
            case "minecraft:tag": {
                class_3494 tag = class_3489.method_15106().method_30210(new class_2960(object.get("name").getAsString()));
                if (tag == null) break;
                outputs.addAll(tag.method_15138().stream().map(item -> {
                    EntryStack stack = EntryStack.create((class_1935)item);
                    LootOutput output = new LootOutput();
                    output.output = Lists.newArrayList((Object[])new EntryStack[]{stack});
                    output.original = stack.copy();
                    return output;
                }).collect(Collectors.toList()));
                break;
            }
            default: {
                RERUtils.LOGGER.debug("Don't know how to deal with entry of type %s (%s)", type, object);
            }
        }
        if (object.has("conditions")) {
            for (JsonElement conditionElement : object.get("conditions").getAsJsonArray()) {
                this.munchLootCondition(conditionElement, outputs);
            }
        }
        if (object.has("functions")) {
            ArrayList<LootOutput> newOutputs = new ArrayList<LootOutput>();
            for (JsonElement functionElement : object.get("functions").getAsJsonArray()) {
                List<LootOutput> list = this.munchLootFunctions(functionElement, outputs);
                if (list == null) continue;
                newOutputs.addAll(list);
            }
            outputs.addAll(newOutputs);
        }
        return outputs;
    }

    private List<LootOutput> munchLootFunctions(JsonElement lootFunction, List<LootOutput> outputs) {
        JsonObject functionObject = lootFunction.getAsJsonObject();
        String kind = new class_2960(functionObject.get("function").getAsString()).toString();
        boolean createNew = false;
        ArrayList<LootOutput> newOutputs = null;
        if (functionObject.has("conditions")) {
            newOutputs = new ArrayList<LootOutput>();
            for (LootOutput lootOutput : outputs) {
                newOutputs.add(lootOutput.copy());
            }
        }
        if (kind.equals("minecraft:set_count") && functionObject.has("count") && functionObject.get("count").isJsonPrimitive()) {
            int count = functionObject.get("count").getAsInt();
            for (LootOutput output : outputs) {
                for (EntryStack entryStack : output.output) {
                    entryStack.setAmount(count);
                }
                output.setCountText(String.valueOf(count));
            }
            createNew = true;
        } else if (kind.equals("minecraft:set_count") && functionObject.has("count") && functionObject.get("count").isJsonObject()) {
            String type = new class_2960(functionObject.get("count").getAsJsonObject().get("type").getAsString()).toString();
            if (type.equalsIgnoreCase("minecraft:uniform")) {
                int n = class_3532.method_15375((float)functionObject.get("count").getAsJsonObject().get("min").getAsFloat());
                int max = class_3532.method_15375((float)functionObject.get("count").getAsJsonObject().get("max").getAsFloat());
                int no = max - n + 1;
                for (LootOutput output : outputs) {
                    EntryStack first = output.output.get(0);
                    while (output.output.size() < no) {
                        output.output.add(first.copy());
                    }
                    for (int i = 0; i < no; ++i) {
                        output.output.get(i).setAmount(n + i);
                    }
                    output.setCountText(class_1074.method_4662((String)"rer.loot.range", (Object[])new Object[]{n, max}));
                }
                createNew = true;
            }
        } else if (kind.equals("minecraft:limit_count") && functionObject.has("limit") && functionObject.get("limit").isJsonObject()) {
            Integer min = functionObject.get("limit").getAsJsonObject().has("min") ? Integer.valueOf(functionObject.get("limit").getAsJsonObject().get("min").getAsInt()) : null;
            Integer n = functionObject.get("limit").getAsJsonObject().has("max") ? Integer.valueOf(functionObject.get("limit").getAsJsonObject().get("max").getAsInt()) : null;
            for (LootOutput output : outputs) {
                for (EntryStack stack : output.output) {
                    if (min != null) {
                        int amount;
                        int n2 = amount = stack.isEmpty() ? 0 : stack.getAmount();
                        if (amount < min) {
                            stack.setAmount(min.intValue());
                        }
                    }
                    if (n == null || stack.getAmount() <= n) continue;
                    stack.setAmount(n.intValue());
                }
                if (output.output.isEmpty()) {
                    output.output.add(EntryStack.empty());
                }
                if (min != null) {
                    output.addExtraTextCount(class_1074.method_4662((String)"rer.function.atLeast", (Object[])new Object[]{min}));
                }
                if (n == null) continue;
                output.addExtraTextCount(class_1074.method_4662((String)"rer.function.atMost", (Object[])new Object[]{n}));
            }
            if (min != null || n != null) {
                createNew = true;
            }
        } else if (!(kind.equals("minecraft:copy_nbt") || kind.equals("minecraft:copy_name") || kind.equals("minecraft:explosion_decay") || kind.equals("minecraft:set_contents") || kind.equals("minecraft:copy_state"))) {
            if (kind.equals("minecraft:set_nbt") && functionObject.has("tag")) {
                try {
                    class_2487 tag = class_2522.method_10718((String)class_3518.method_15265((JsonObject)functionObject, (String)"tag"));
                    for (LootOutput output : outputs) {
                        for (int i = 0; i < output.output.size(); ++i) {
                            EntryStack entryStack = output.output.get(i).copy();
                            if (!entryStack.isEmpty() && entryStack.getType() == EntryStack.Type.ITEM) {
                                entryStack.getItemStack().method_7948().method_10543(tag);
                            }
                            output.output.set(i, entryStack);
                        }
                        EntryStack stack = output.original.copy();
                        if (!stack.isEmpty() && stack.getType() == EntryStack.Type.ITEM) {
                            stack.getItemStack().method_7948().method_10543(tag);
                        }
                        output.original = stack;
                    }
                    createNew = true;
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            } else if (kind.equals("minecraft:apply_bonus") && functionObject.has("enchantment")) {
                String enchantmentString = functionObject.get("enchantment").getAsString();
                class_1887 class_18872 = (class_1887)class_2378.field_11160.method_10223(new class_2960(enchantmentString));
                if (class_18872 != null) {
                    for (LootOutput output : outputs) {
                        output.addExtraTextCount(class_1074.method_4662((String)"rer.function.bonus.enchant", (Object[])new Object[]{class_1074.method_4662((String)class_18872.method_8184(), (Object[])new Object[0]).toLowerCase()}));
                    }
                    createNew = true;
                }
            } else if (kind.equals("minecraft:looting_enchant")) {
                for (LootOutput lootOutput : outputs) {
                    lootOutput.addExtraTextCount(class_1074.method_4662((String)"rer.function.bonus.enchant", (Object[])new Object[]{class_1074.method_4662((String)class_1893.field_9110.method_8184(), (Object[])new Object[0]).toLowerCase()}));
                }
                createNew = true;
            } else if (kind.equals("minecraft:furnace_smelt")) {
                for (LootOutput lootOutput : outputs) {
                    lootOutput.original = this.smelt(lootOutput.original);
                    for (int i = 0; i < lootOutput.output.size(); ++i) {
                        lootOutput.output.set(i, this.smelt(lootOutput.output.get(i)));
                    }
                }
                createNew = true;
            } else {
                RERUtils.LOGGER.debug("Don't know how to deal with function of type %s (%s)", kind, functionObject);
            }
        }
        if (functionObject.has("conditions")) {
            for (JsonElement jsonElement : functionObject.get("conditions").getAsJsonArray()) {
                this.munchLootCondition(jsonElement, outputs);
            }
        }
        if (functionObject.has("functions")) {
            ArrayList<LootOutput> newNewOutputs = new ArrayList<LootOutput>();
            for (JsonElement functionElement : functionObject.get("functions").getAsJsonArray()) {
                List<LootOutput> list = this.munchLootFunctions(functionElement, outputs);
                if (list == null) continue;
                newNewOutputs.addAll(list);
            }
            outputs.addAll(newNewOutputs);
        }
        return createNew ? newOutputs : null;
    }

    private EntryStack smelt(EntryStack stack) {
        class_1799 itemStack;
        if (stack.isEmpty() || stack.getType() != EntryStack.Type.ITEM) {
            return stack.copy();
        }
        class_638 world = class_310.method_1551().field_1687;
        Optional optional = world.method_8433().method_8132(class_3956.field_17546, (class_1263)new class_1277(new class_1799[]{stack.getItemStack()}), (class_1937)world);
        if (optional.isPresent() && !(itemStack = ((class_3861)optional.get()).method_8110()).method_7960()) {
            EntryStack entryStack = EntryStack.create((class_1799)itemStack.method_7972());
            entryStack.setAmount(stack.getAmount());
            return entryStack;
        }
        return stack.copy();
    }

    public List<LootOutput> munchLootPoolJson(JsonObject poolObject) {
        ArrayList<LootOutput> outputs = new ArrayList<LootOutput>();
        JsonArray entries = poolObject.getAsJsonObject().get("entries").getAsJsonArray();
        for (JsonElement entryElement : entries) {
            JsonObject entryObject = entryElement.getAsJsonObject();
            outputs.addAll(this.munchLootEntryJson(entryObject));
        }
        if (poolObject.getAsJsonObject().has("conditions")) {
            for (JsonElement conditionElement : poolObject.getAsJsonObject().get("conditions").getAsJsonArray()) {
                this.munchLootCondition(conditionElement, outputs);
            }
        }
        if (poolObject.getAsJsonObject().has("functions")) {
            ArrayList<LootOutput> newOutputs = new ArrayList<LootOutput>();
            for (JsonElement functionElement : poolObject.getAsJsonObject().get("functions").getAsJsonArray()) {
                List<LootOutput> list = this.munchLootFunctions(functionElement, outputs);
                if (list == null) continue;
                newOutputs.addAll(list);
            }
            outputs.addAll(newOutputs);
        }
        return outputs;
    }

    public List<LootOutput> munchLootSupplierJson(JsonElement jsonSupplier) {
        ArrayList<LootOutput> outputs = new ArrayList<LootOutput>();
        if (!jsonSupplier.getAsJsonObject().has("pools")) {
            return outputs;
        }
        JsonArray pools = jsonSupplier.getAsJsonObject().get("pools").getAsJsonArray();
        for (JsonElement poolElement : pools) {
            JsonObject poolObject = poolElement.getAsJsonObject();
            outputs.addAll(this.munchLootPoolJson(poolObject));
        }
        return outputs;
    }

    public List<LootOutput> getOutputs() {
        String json = ClientLootCache.ID_TO_LOOT.get(this.lootTableId);
        if (json == null) {
            return Collections.emptyList();
        }
        if (this.outputs == null || FabricLoader.getInstance().isDevelopmentEnvironment()) {
            this.outputs = this.munchLootSupplierJson((JsonElement)RoughlyEnoughResources.GSON.fromJson(json, JsonElement.class));
        }
        return this.outputs;
    }
}

