/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.apace100.origins.power.CooldownPower;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.VariableIntPower;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2172;
import net.minecraft.class_2588;
import net.minecraft.class_267;

public class PowerOperation
implements ArgumentType<Operation> {
    public static final SimpleCommandExceptionType INVALID_OPERATION = new SimpleCommandExceptionType((Message)new class_2588("arguments.operation.invalid"));
    public static final SimpleCommandExceptionType DIVISION_ZERO_EXCEPTION = new SimpleCommandExceptionType((Message)new class_2588("arguments.operation.div0"));

    public static PowerOperation operation() {
        return new PowerOperation();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9253((String[])new String[]{"=", "+=", "-=", "*=", "/=", "%=", "<", ">", "><"}, (SuggestionsBuilder)builder);
    }

    public Operation parse(StringReader stringReader) throws CommandSyntaxException {
        String stringOperator;
        if (!stringReader.canRead()) {
            throw INVALID_OPERATION.create();
        }
        int i = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            stringReader.skip();
        }
        switch (stringOperator = stringReader.getString().substring(i, stringReader.getCursor())) {
            case "=": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        ((VariableIntPower)power).setValue(score.method_1126());
                    } else if (power instanceof CooldownPower) {
                        ((CooldownPower)power).setCooldown(score.method_1126());
                    }
                };
            }
            case "+=": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        ((VariableIntPower)power).setValue(((VariableIntPower)power).getValue() + score.method_1126());
                    } else if (power instanceof CooldownPower) {
                        ((CooldownPower)power).modify(score.method_1126());
                    }
                };
            }
            case "-=": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        ((VariableIntPower)power).setValue(((VariableIntPower)power).getValue() - score.method_1126());
                    } else if (power instanceof CooldownPower) {
                        ((CooldownPower)power).modify(-score.method_1126());
                    }
                };
            }
            case "*=": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        ((VariableIntPower)power).setValue(((VariableIntPower)power).getValue() * score.method_1126());
                    } else if (power instanceof CooldownPower) {
                        ((CooldownPower)power).setCooldown(((CooldownPower)power).getRemainingTicks() * score.method_1126());
                    }
                };
            }
            case "/=": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        VariableIntPower resource = (VariableIntPower)power;
                        int r = resource.getValue();
                        int s = score.method_1126();
                        if (s == 0) {
                            throw DIVISION_ZERO_EXCEPTION.create();
                        }
                        resource.setValue(Math.floorDiv(r, s));
                    } else if (power instanceof CooldownPower) {
                        CooldownPower cooldownPower = (CooldownPower)power;
                        int c = cooldownPower.getRemainingTicks();
                        int s = score.method_1126();
                        if (s == 0) {
                            throw DIVISION_ZERO_EXCEPTION.create();
                        }
                        cooldownPower.setCooldown(Math.floorDiv(c, s));
                    }
                };
            }
            case "%=": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        VariableIntPower resource = (VariableIntPower)power;
                        int r = resource.getValue();
                        int s = score.method_1126();
                        if (s == 0) {
                            throw DIVISION_ZERO_EXCEPTION.create();
                        }
                        resource.setValue(Math.floorMod(r, s));
                    } else if (power instanceof CooldownPower) {
                        CooldownPower cooldownPower = (CooldownPower)power;
                        int c = cooldownPower.getRemainingTicks();
                        int s = score.method_1126();
                        if (s == 0) {
                            throw DIVISION_ZERO_EXCEPTION.create();
                        }
                        cooldownPower.setCooldown(Math.floorMod(c, s));
                    }
                };
            }
            case "<": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        VariableIntPower resource = (VariableIntPower)power;
                        resource.setValue(Math.min(resource.getValue(), score.method_1126()));
                    } else if (power instanceof CooldownPower) {
                        CooldownPower cooldownPower = (CooldownPower)power;
                        cooldownPower.setCooldown(Math.min(cooldownPower.getRemainingTicks(), score.method_1126()));
                    }
                };
            }
            case ">": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        VariableIntPower resource = (VariableIntPower)power;
                        resource.setValue(Math.max(resource.getValue(), score.method_1126()));
                    } else if (power instanceof CooldownPower) {
                        CooldownPower cooldownPower = (CooldownPower)power;
                        cooldownPower.setCooldown(Math.max(cooldownPower.getRemainingTicks(), score.method_1126()));
                    }
                };
            }
            case "><": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        VariableIntPower resource = (VariableIntPower)power;
                        int v = score.method_1126();
                        score.method_1128(resource.getValue());
                        resource.setValue(v);
                    } else if (power instanceof CooldownPower) {
                        CooldownPower cooldownPower = (CooldownPower)power;
                        int v = score.method_1126();
                        score.method_1128(cooldownPower.getRemainingTicks());
                        cooldownPower.setCooldown(v);
                    }
                };
            }
        }
        throw INVALID_OPERATION.create();
    }

    public static interface Operation {
        public void apply(Power var1, class_267 var2) throws CommandSyntaxException;
    }
}

