/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.component;

import com.google.common.collect.Lists;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.ValueModifyingPower;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.util.AttributeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_2960;

public interface OriginComponent
extends AutoSyncedComponent,
ServerTickingComponent {
    public boolean hasOrigin(OriginLayer var1);

    public boolean hasAllOrigins();

    public HashMap<OriginLayer, Origin> getOrigins();

    public Origin getOrigin(OriginLayer var1);

    public boolean hadOriginBefore();

    public boolean hasPower(PowerType<?> var1);

    public <T extends Power> T getPower(PowerType<T> var1);

    public List<Power> getPowers();

    public <T extends Power> List<T> getPowers(Class<T> var1);

    public <T extends Power> List<T> getPowers(Class<T> var1, boolean var2);

    public void setOrigin(OriginLayer var1, Origin var2);

    public void sync();

    public static void sync(class_1657 player) {
        ModComponents.ORIGIN.sync((Object)player);
    }

    public static <T extends Power> void withPower(class_1297 entity, Class<T> powerClass, Predicate<T> power, Consumer<T> with) {
        if (entity instanceof class_1657) {
            Optional<Power> optional = ((OriginComponent)ModComponents.ORIGIN.get((Object)entity)).getPowers(powerClass).stream().filter(p -> power == null || power.test(p)).findAny();
            optional.ifPresent(with);
        }
    }

    public static <T extends Power> List<T> getPowers(class_1297 entity, Class<T> powerClass) {
        if (entity instanceof class_1657) {
            return ((OriginComponent)ModComponents.ORIGIN.get((Object)entity)).getPowers(powerClass);
        }
        return Lists.newArrayList();
    }

    public static <T extends Power> boolean hasPower(class_1297 entity, Class<T> powerClass) {
        if (entity instanceof class_1657) {
            return ((OriginComponent)ModComponents.ORIGIN.get((Object)entity)).getPowers().stream().anyMatch(p -> powerClass.isAssignableFrom(p.getClass()) && p.isActive());
        }
        return false;
    }

    public static <T extends ValueModifyingPower> float modify(class_1297 entity, Class<T> powerClass, float baseValue) {
        return (float)OriginComponent.modify(entity, powerClass, (double)baseValue, null, null);
    }

    public static <T extends ValueModifyingPower> float modify(class_1297 entity, Class<T> powerClass, float baseValue, Predicate<T> powerFilter) {
        return (float)OriginComponent.modify(entity, powerClass, (double)baseValue, powerFilter, null);
    }

    public static <T extends ValueModifyingPower> float modify(class_1297 entity, Class<T> powerClass, float baseValue, Predicate<T> powerFilter, Consumer<T> powerAction) {
        return (float)OriginComponent.modify(entity, powerClass, (double)baseValue, powerFilter, powerAction);
    }

    public static <T extends ValueModifyingPower> double modify(class_1297 entity, Class<T> powerClass, double baseValue) {
        return OriginComponent.modify(entity, powerClass, baseValue, null, null);
    }

    public static <T extends ValueModifyingPower> double modify(class_1297 entity, Class<T> powerClass, double baseValue, Predicate<T> powerFilter, Consumer<T> powerAction) {
        if (entity instanceof class_1657) {
            List<T> powers = ((OriginComponent)ModComponents.ORIGIN.get((Object)entity)).getPowers(powerClass);
            List<class_1322> mps = powers.stream().filter(p -> powerFilter == null || powerFilter.test(p)).flatMap(p -> p.getModifiers().stream()).collect(Collectors.toList());
            if (powerAction != null) {
                powers.forEach(powerAction);
            }
            return AttributeUtil.sortAndApplyModifiers(mps, baseValue);
        }
        return baseValue;
    }

    default public boolean checkAutoChoosingLayers(class_1657 player, boolean includeDefaults) {
        boolean choseOneAutomatically = false;
        ArrayList<OriginLayer> layers = new ArrayList<OriginLayer>();
        for (OriginLayer layer : OriginLayers.getLayers()) {
            if (!layer.isEnabled()) continue;
            layers.add(layer);
        }
        Collections.sort(layers);
        for (OriginLayer layer : layers) {
            boolean shouldContinue = false;
            if (layer.isEnabled() && !this.hasOrigin(layer)) {
                if (includeDefaults && layer.hasDefaultOrigin()) {
                    this.setOrigin(layer, OriginRegistry.get(layer.getDefaultOrigin()));
                    choseOneAutomatically = true;
                    shouldContinue = true;
                } else if (layer.getOriginOptionCount(player) == 1 && layer.shouldAutoChoose()) {
                    List origins = layer.getOrigins(player).stream().map(OriginRegistry::get).filter(Origin::isChoosable).collect(Collectors.toList());
                    if (origins.size() == 0) {
                        List<class_2960> randomOrigins = layer.getRandomOrigins(player);
                        this.setOrigin(layer, OriginRegistry.get(randomOrigins.get(player.method_6051().nextInt(randomOrigins.size()))));
                    } else {
                        this.setOrigin(layer, (Origin)origins.get(0));
                    }
                    choseOneAutomatically = true;
                    shouldContinue = true;
                }
            } else {
                shouldContinue = true;
            }
            if (shouldContinue) continue;
            break;
        }
        return choseOneAutomatically;
    }
}

