/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.InvisibilityPower;
import io.github.apace100.origins.power.ModelColorPower;
import io.github.apace100.origins.power.ShakingPower;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_922;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_922.class})
public abstract class LivingEntityRendererMixin
extends class_897<class_1309> {
    protected LivingEntityRendererMixin(class_898 dispatcher) {
        super(dispatcher);
    }

    @Inject(method={"isShaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void letPlayersShakeTheirBodies(class_1309 entity, CallbackInfoReturnable<Boolean> cir) {
        if (OriginComponent.hasPower((class_1297)entity, ShakingPower.class)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventPumpkinRendering(class_1309 livingEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo info) {
        List<InvisibilityPower> invisibilityPowers = OriginComponent.getPowers((class_1297)livingEntity, InvisibilityPower.class);
        if (invisibilityPowers.size() > 0 && invisibilityPowers.stream().noneMatch(InvisibilityPower::shouldRenderArmor)) {
            info.cancel();
        }
    }

    @ModifyVariable(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/VertexConsumerProvider;getBuffer(Lnet/minecraft/client/render/RenderLayer;)Lnet/minecraft/client/render/VertexConsumer;", shift=At.Shift.BEFORE))
    private class_1921 changeRenderLayerWhenTranslucent(class_1921 original, class_1309 entity) {
        if (entity instanceof class_1657 && OriginComponent.getPowers((class_1297)entity, ModelColorPower.class).stream().anyMatch(ModelColorPower::isTranslucent)) {
            return class_1921.method_29379((class_2960)this.method_3931((class_1297)entity));
        }
        return original;
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/EntityModel;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;IIFFFF)V", ordinal=0))
    @Environment(value=EnvType.CLIENT)
    private void renderColorChangedModel(class_583 model, class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha, class_1309 player) {
        List<ModelColorPower> modelColorPowers;
        if (player instanceof class_1657 && (modelColorPowers = OriginComponent.getPowers((class_1297)player, ModelColorPower.class)).size() > 0) {
            float r = modelColorPowers.stream().map(ModelColorPower::getRed).reduce((a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).get().floatValue();
            float g = modelColorPowers.stream().map(ModelColorPower::getGreen).reduce((a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).get().floatValue();
            float b2 = modelColorPowers.stream().map(ModelColorPower::getBlue).reduce((a, c) -> Float.valueOf(a.floatValue() * c.floatValue())).get().floatValue();
            float a2 = modelColorPowers.stream().map(ModelColorPower::getAlpha).min(Float::compare).get().floatValue();
            model.method_2828(matrices, vertices, light, overlay, r * red, g * green, b2 * blue, a2 * alpha);
            return;
        }
        model.method_2828(matrices, vertices, light, overlay, red, green, blue, alpha);
    }
}

