/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import dev.onyxstudios.cca.api.v3.component.ComponentProvider;
import io.github.apace100.origins.access.EndRespawningEntity;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.power.ModifyPlayerSpawnPower;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeRegistry;
import io.github.apace100.origins.power.factory.PowerFactory;
import io.github.apace100.origins.registry.ModComponents;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3324;
import net.minecraft.class_5275;
import net.minecraft.class_5321;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_3324.class})
public abstract class LoginMixin {
    @Shadow
    public abstract List<class_3222> method_14571();

    @Inject(at={@At(value="TAIL")}, method={"Lnet/minecraft/server/PlayerManager;onPlayerConnect(Lnet/minecraft/network/ClientConnection;Lnet/minecraft/server/network/ServerPlayerEntity;)V"})
    private void openOriginsGui(class_2535 connection, class_3222 player, CallbackInfo info) {
        OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)player);
        class_2540 powerListData = new class_2540(Unpooled.buffer());
        powerListData.writeInt(PowerTypeRegistry.size());
        PowerTypeRegistry.entries().forEach(entry -> {
            PowerType type = (PowerType)entry.getValue();
            PowerFactory.Instance factory = type.getFactory();
            if (factory != null) {
                powerListData.method_10812((class_2960)entry.getKey());
                factory.write(powerListData);
                powerListData.method_10814(type.getOrCreateNameTranslationKey());
                powerListData.method_10814(type.getOrCreateDescriptionTranslationKey());
                powerListData.writeBoolean(type.isHidden());
            }
        });
        class_2540 originListData = new class_2540(Unpooled.buffer());
        originListData.writeInt(OriginRegistry.size() - 1);
        OriginRegistry.entries().forEach(entry -> {
            if (entry.getValue() != Origin.EMPTY) {
                originListData.method_10812((class_2960)entry.getKey());
                ((Origin)entry.getValue()).write(originListData);
            }
        });
        class_2540 originLayerData = new class_2540(Unpooled.buffer());
        originLayerData.writeInt(OriginLayers.size());
        OriginLayers.getLayers().forEach(layer -> {
            layer.write(originLayerData);
            if (layer.isEnabled() && !component.hasOrigin((OriginLayer)layer)) {
                component.setOrigin((OriginLayer)layer, Origin.EMPTY);
            }
        });
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.POWER_LIST, (class_2540)powerListData);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.ORIGIN_LIST, (class_2540)originListData);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.LAYER_LIST, (class_2540)originLayerData);
        List<class_3222> playerList = this.method_14571();
        playerList.forEach(spe -> ModComponents.ORIGIN.syncWith(spe, ComponentProvider.fromEntity((class_1297)player)));
        OriginComponent.sync((class_1657)player);
        if (!component.hasAllOrigins()) {
            if (component.checkAutoChoosingLayers((class_1657)player, true)) {
                component.sync();
            }
            if (component.hasAllOrigins()) {
                component.getOrigins().values().forEach(o -> o.getPowerTypes().forEach(powerType -> ((Power)component.getPower(powerType)).onChosen(false)));
            } else {
                class_2540 data = new class_2540(Unpooled.buffer());
                data.writeBoolean(true);
                ServerPlayNetworking.send((class_3222)player, (class_2960)ModPackets.OPEN_ORIGIN_SCREEN, (class_2540)data);
            }
        }
    }

    @Redirect(method={"respawnPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;setSpawnPoint(Lnet/minecraft/util/registry/RegistryKey;Lnet/minecraft/util/math/BlockPos;FZZ)V"))
    private void preventEndExitSpawnPointSetting(class_3222 serverPlayerEntity, class_5321<class_1937> dimension, class_2338 pos, float angle, boolean spawnPointSet, boolean bl, class_3222 playerEntity, boolean alive) {
        EndRespawningEntity ere = (EndRespawningEntity)playerEntity;
        if (ere.hasRealRespawnPoint()) {
            serverPlayerEntity.method_26284(dimension, pos, angle, spawnPointSet, bl);
        }
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    private void invokeOnRemovedCallback(class_3222 player, CallbackInfo ci) {
        OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)player);
        component.getPowers().forEach(Power::onRemoved);
    }

    @Redirect(method={"respawnPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;findRespawnPosition(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;FZZ)Ljava/util/Optional;"))
    private Optional<class_243> retryObstructedSpawnpointIfFailed(class_3218 world, class_2338 pos, float f, boolean bl, boolean bl2, class_3222 player, boolean alive) {
        Optional original = class_1657.method_26091((class_3218)world, (class_2338)pos, (float)f, (boolean)bl, (boolean)bl2);
        if (!original.isPresent() && OriginComponent.hasPower((class_1297)player, ModifyPlayerSpawnPower.class)) {
            return Optional.ofNullable(class_5275.method_30769((class_1299)class_1299.field_6097, (class_1941)world, (class_2338)pos, (boolean)bl));
        }
        return original;
    }

    @Inject(method={"respawnPlayer"}, at={@At(value="HEAD")})
    private void invokePowerRemovedCallback(class_3222 player, boolean alive, CallbackInfoReturnable<class_3222> cir) {
        List<Power> powers = ((OriginComponent)ModComponents.ORIGIN.get((Object)player)).getPowers();
        powers.forEach(Power::onRemoved);
    }

    @Inject(method={"respawnPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;onSpawn()V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void invokePowerRespawnCallback(class_3222 player, boolean alive, CallbackInfoReturnable<class_3222> cir, class_2338 blockPos, float f, boolean bl, class_3218 serverWorld, Optional optional2, class_3225 serverPlayerInteractionManager2, class_3218 serverWorld2, class_3222 serverPlayerEntity) {
        if (!alive) {
            List<Power> powers = ((OriginComponent)ModComponents.ORIGIN.get((Object)serverPlayerEntity)).getPowers();
            powers.forEach(Power::onRespawn);
        }
    }
}

