/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import java.util.HashMap;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class ConditionedRestrictArmorPower
extends Power {
    private final HashMap<class_1304, Predicate<class_1799>> armorConditions;
    private final int tickRate;

    public ConditionedRestrictArmorPower(PowerType<?> type, class_1657 player, HashMap<class_1304, Predicate<class_1799>> armorConditions, int tickRate) {
        super(type, player);
        this.armorConditions = armorConditions;
        this.setTicking(true);
        this.tickRate = tickRate;
    }

    public boolean canEquip(class_1799 itemStack, class_1304 slot) {
        return !this.armorConditions.get(slot).test(itemStack);
    }

    @Override
    public void tick() {
        if (this.player.field_6012 % this.tickRate == 0 && this.isActive()) {
            for (class_1304 slot : this.armorConditions.keySet()) {
                class_1799 equippedItem = this.player.method_6118(slot);
                if (equippedItem.method_7960() || this.canEquip(equippedItem, slot)) continue;
                if (!this.player.field_7514.method_7394(equippedItem)) {
                    this.player.method_7328(equippedItem, true);
                }
                this.player.method_5673(slot, class_1799.field_8037);
            }
        }
    }
}

