/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.action;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.apace100.origins.power.factory.action.ActionFactory;
import java.util.Optional;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ActionType<T> {
    private final String actionTypeName;
    private final class_2378<ActionFactory<T>> actionFactoryRegistry;

    public ActionType(String actionTypeName, class_2378<ActionFactory<T>> actionFactoryRegistry) {
        this.actionTypeName = actionTypeName;
        this.actionFactoryRegistry = actionFactoryRegistry;
    }

    public void write(class_2540 buf, ActionFactory.Instance actionInstance) {
        actionInstance.write(buf);
    }

    public ActionFactory.Instance read(class_2540 buf) {
        class_2960 type = buf.method_10810();
        ActionFactory actionFactory = (ActionFactory)this.actionFactoryRegistry.method_10223(type);
        if (actionFactory == null) {
            throw new JsonSyntaxException(this.actionTypeName + " \"" + type + "\" was not registered.");
        }
        return actionFactory.read(buf);
    }

    public ActionFactory.Instance read(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject obj = jsonElement.getAsJsonObject();
            if (!obj.has("type")) {
                throw new JsonSyntaxException(this.actionTypeName + " json requires \"type\" identifier.");
            }
            String typeIdentifier = class_3518.method_15265((JsonObject)obj, (String)"type");
            class_2960 type = class_2960.method_12829((String)typeIdentifier);
            Optional optionalAction = this.actionFactoryRegistry.method_17966(type);
            if (!optionalAction.isPresent()) {
                throw new JsonSyntaxException(this.actionTypeName + " json type \"" + type.toString() + "\" is not defined.");
            }
            return ((ActionFactory)optionalAction.get()).read(obj);
        }
        throw new JsonSyntaxException(this.actionTypeName + " has to be a JsonObject!");
    }
}

