/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.BiomeTextureMap;
import hunternif.mc.impl.atlas.client.KeyHandler;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetConfig;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.ext.ExtTileIdMap;
import hunternif.mc.impl.atlas.marker.MarkerTextureConfig;
import hunternif.mc.impl.atlas.registry.MarkerType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_5458;

@Environment(value=EnvType.CLIENT)
public class ClientProxy
implements SimpleSynchronousResourceReloadListener {
    private static TextureSetMap textureSetMap;
    private static TextureSetConfig textureSetConfig;
    private static BiomeTextureMap textureMap;
    private static MarkerTextureConfig markerTextureConfig;

    public void initClient() {
        textureSetMap = TextureSetMap.instance();
        textureSetConfig = new TextureSetConfig(textureSetMap);
        this.registerDefaultTextureSets(textureSetMap);
        textureSetMap.setDirty(false);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)textureSetConfig);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this);
        textureMap = BiomeTextureMap.instance();
        this.registerVanillaCustomTileTextures();
        textureMap.setDirty(false);
        this.assignVanillaBiomeTextures();
        markerTextureConfig = new MarkerTextureConfig();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)markerTextureConfig);
        for (MarkerType type : MarkerType.REGISTRY) {
            type.initMips();
        }
        if (!AntiqueAtlasMod.CONFIG.itemNeeded) {
            KeyHandler.registerBindings();
            ClientTickEvents.START_CLIENT_TICK.register(KeyHandler::onClientTick);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void registerDefaultTextureSets(TextureSetMap map) {
        map.register(TextureSet.ICE);
        map.register(TextureSet.SHORE);
        map.register(TextureSet.ROCK_SHORE);
        map.register(TextureSet.DESERT);
        map.register(TextureSet.PLAINS);
        map.register(TextureSet.SUNFLOWERS);
        map.register(TextureSet.HILLS);
        map.register(TextureSet.DESERT_HILLS);
        map.register(TextureSet.ICE_SPIKES);
        map.register(TextureSet.SNOW_PINES);
        map.register(TextureSet.SNOW_PINES_HILLS);
        map.register(TextureSet.SNOW_HILLS);
        map.register(TextureSet.SNOW);
        map.register(TextureSet.MOUNTAINS_NAKED);
        map.register(TextureSet.MOUNTAINS);
        map.register(TextureSet.MOUNTAINS_SNOW_CAPS);
        map.register(TextureSet.MOUNTAINS_ALL);
        map.register(TextureSet.FOREST);
        map.register(TextureSet.FOREST_HILLS);
        map.register(TextureSet.FOREST_FLOWERS);
        map.register(TextureSet.DENSE_FOREST);
        map.register(TextureSet.DENSE_FOREST_HILLS);
        map.register(TextureSet.BIRCH);
        map.register(TextureSet.BIRCH_HILLS);
        map.register(TextureSet.TALL_BIRCH);
        map.register(TextureSet.TALL_BIRCH_HILLS);
        map.register(TextureSet.DENSE_BIRCH);
        map.register(TextureSet.JUNGLE);
        map.register(TextureSet.JUNGLE_HILLS);
        map.register(TextureSet.JUNGLE_CLIFFS);
        map.register(TextureSet.JUNGLE_EDGE);
        map.register(TextureSet.JUNGLE_EDGE_HILLS);
        map.register(TextureSet.PINES);
        map.register(TextureSet.PINES_HILLS);
        map.register(TextureSet.SAVANNA);
        map.register(TextureSet.SAVANNA_PLATEAU);
        map.register(TextureSet.PLATEAU_SAVANNA_M);
        map.register(TextureSet.MESA);
        map.register(TextureSet.BRYCE);
        map.register(TextureSet.PLATEAU_MESA);
        map.register(TextureSet.PLATEAU_MESA_LOW);
        map.register(TextureSet.PLATEAU_MESA_TREES);
        map.register(TextureSet.PLATEAU_MESA_TREES_LOW);
        map.register(TextureSet.PLATEAU_SAVANNA);
        map.register(TextureSet.MEGA_SPRUCE);
        map.register(TextureSet.MEGA_SPRUCE_HILLS);
        map.register(TextureSet.MEGA_TAIGA);
        map.register(TextureSet.MEGA_TAIGA_HILLS);
        map.register(TextureSet.SWAMP);
        map.register(TextureSet.SWAMP_HILLS);
        map.register(TextureSet.MUSHROOM);
        map.register(TextureSet.WATER);
        map.register(TextureSet.LAVA);
        map.register(TextureSet.LAVA_SHORE);
        map.register(TextureSet.CAVE_WALLS);
        map.register(TextureSet.RAVINE);
        map.register(TextureSet.HOUSE);
        map.register(TextureSet.FENCE);
        map.register(TextureSet.LIBRARY);
        map.register(TextureSet.L_HOUSE);
        map.register(TextureSet.SMITHY);
        map.register(TextureSet.FARMLAND_LARGE);
        map.register(TextureSet.FARMLAND_SMALL);
        map.register(TextureSet.WELL);
        map.register(TextureSet.VILLAGE_TORCH);
        map.register(TextureSet.HUT);
        map.register(TextureSet.HOUSE_SMALL);
        map.register(TextureSet.BUTCHERS_SHOP);
        map.register(TextureSet.CHURCH);
        map.register(TextureSet.SOUL_SAND_VALLEY);
        map.register(TextureSet.NETHER_BRIDGE);
        map.register(TextureSet.NETHER_BRIDGE_X);
        map.register(TextureSet.NETHER_BRIDGE_Z);
        map.register(TextureSet.NETHER_BRIDGE_END_X);
        map.register(TextureSet.NETHER_BRIDGE_END_Z);
        map.register(TextureSet.NETHER_BRIDGE_GATE);
        map.register(TextureSet.NETHER_TOWER);
        map.register(TextureSet.NETHER_WALL);
        map.register(TextureSet.NETHER_HALL);
        map.register(TextureSet.NETHER_FORT_STAIRS);
        map.register(TextureSet.NETHER_THRONE);
        map.register(TextureSet.END_ISLAND);
        map.register(TextureSet.END_ISLAND_PLANTS);
        map.register(TextureSet.END_VOID);
    }

    private void assignVanillaBiomeTextures() {
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9453, TextureSet.ICE_SPIKES);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9455, TextureSet.SUNFLOWERS);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9478, TextureSet.SHORE);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9419, TextureSet.ROCK_SHORE);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9444, TextureSet.MOUNTAINS_SNOW_CAPS);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9472, TextureSet.MOUNTAINS_ALL);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9437, TextureSet.MOUNTAINS_SNOW_CAPS);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9409, TextureSet.FOREST);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9414, TextureSet.FOREST_FLOWERS);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9412, TextureSet.BIRCH);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9431, TextureSet.TALL_BIRCH);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9421, TextureSet.BIRCH_HILLS);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9458, TextureSet.TALL_BIRCH_HILLS);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9417, TextureSet.JUNGLE);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9405, TextureSet.JUNGLE_CLIFFS);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9432, TextureSet.JUNGLE_HILLS);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9474, TextureSet.JUNGLE_EDGE);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9420, TextureSet.PINES);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9428, TextureSet.PINES_HILLS);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9428, TextureSet.PINES_HILLS);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9454, TextureSet.SNOW_PINES);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9425, TextureSet.SNOW_PINES_HILLS);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9437, TextureSet.SNOW_PINES_HILLS);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9477, TextureSet.MEGA_TAIGA);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9416, TextureSet.MEGA_SPRUCE);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9429, TextureSet.MEGA_TAIGA_HILLS);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9404, TextureSet.MEGA_SPRUCE_HILLS);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9461, TextureSet.CAVE_WALLS);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_22076, TextureSet.SOUL_SAND_VALLEY);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_22077, TextureSet.FOREST);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_22075, TextureSet.JUNGLE);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_23859, TextureSet.MOUNTAINS_ALL);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9411, TextureSet.END_ISLAND);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9462, TextureSet.MUSHROOM);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9407, TextureSet.SHORE);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9410, TextureSet.PLATEAU_MESA_TREES);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9433, TextureSet.PLATEAU_MESA);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9443, TextureSet.MESA);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9415, TextureSet.MESA);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9449, TextureSet.SAVANNA);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9430, TextureSet.SAVANNA_PLATEAU);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9456, TextureSet.SAVANNA);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9445, TextureSet.SAVANNA_PLATEAU);
        this.setBiomeTextureIfNone((class_5321<class_1959>)class_1972.field_9418, TextureSet.ICE_SPIKES);
        for (class_1959 biome : class_5458.field_25933) {
            BiomeTextureMap.instance().checkRegistration(biome);
        }
    }

    private void setBiomeTextureIfNone(class_5321<class_1959> biome, TextureSet textureSet) {
        if (!textureMap.isRegistered(biome.method_29177())) {
            textureMap.setTexture(biome.method_29177(), textureSet);
        }
    }

    private void registerVanillaCustomTileTextures() {
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_LIBRARY, TextureSet.LIBRARY);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_SMITHY, TextureSet.SMITHY);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_L_HOUSE, TextureSet.L_HOUSE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_FARMLAND_LARGE, TextureSet.FARMLAND_LARGE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_FARMLAND_SMALL, TextureSet.FARMLAND_SMALL);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_WELL, TextureSet.WELL);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_TORCH, TextureSet.VILLAGE_TORCH);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_HUT, TextureSet.HUT);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_SMALL_HOUSE, TextureSet.HOUSE_SMALL);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_BUTCHERS_SHOP, TextureSet.BUTCHERS_SHOP);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_CHURCH, TextureSet.CHURCH);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_LAVA, TextureSet.LAVA);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_LAVA_SHORE, TextureSet.LAVA_SHORE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_FORTRESS_BRIDGE_CROSSING, TextureSet.NETHER_BRIDGE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_BRIDGE_X, TextureSet.NETHER_BRIDGE_X);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_BRIDGE_Z, TextureSet.NETHER_BRIDGE_Z);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_BRIDGE_END_X, TextureSet.NETHER_BRIDGE_END_X);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_BRIDGE_END_Z, TextureSet.NETHER_BRIDGE_END_Z);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_FORTRESS_BRIDGE_SMALL_CROSSING, TextureSet.NETHER_BRIDGE_GATE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_FORTRESS_BRIDGE_STAIRS, TextureSet.NETHER_TOWER);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_FORTRESS_WALL, TextureSet.NETHER_WALL);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_FORTRESS_EXIT, TextureSet.NETHER_HALL);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_FORTRESS_CORRIDOR_NETHER_WARTS_ROOM, TextureSet.NETHER_FORT_STAIRS);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_FORTRESS_BRIDGE_PLATFORM, TextureSet.NETHER_THRONE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_END_ISLAND, TextureSet.END_ISLAND);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_END_ISLAND_PLANTS, TextureSet.END_ISLAND_PLANTS);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_END_VOID, TextureSet.END_VOID);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_RAVINE, TextureSet.RAVINE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.SWAMP_WATER, TextureSet.SWAMP_WATER);
    }

    private void setCustomTileTextureIfNone(class_2960 tileId, TextureSet textureSet) {
        if (!textureMap.isRegistered(tileId)) {
            textureMap.setTexture(tileId, textureSet);
        }
    }

    public class_2960 getFabricId() {
        return AntiqueAtlasMod.id("proxy");
    }

    public void method_14491(class_3300 var1) {
        for (MarkerType type : MarkerType.REGISTRY) {
            type.initMips();
        }
    }
}

