/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.BiomeTextureMap;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_5458;

@Environment(value=EnvType.CLIENT)
public class BiomeTextureConfig
implements SimpleResourceReloadListener<Map<class_2960, String>> {
    private static final int VERSION = 2;
    private static final JsonParser PARSER = new JsonParser();
    private final BiomeTextureMap biomeTextureMap;
    private final TextureSetMap textureSetMap;

    public BiomeTextureConfig(BiomeTextureMap biomeTextureMap, TextureSetMap textureSetMap) {
        this.biomeTextureMap = biomeTextureMap;
        this.textureSetMap = textureSetMap;
    }

    public CompletableFuture<Map<class_2960, String>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<class_2960, String> map = new HashMap<class_2960, String>();
            try {
                for (class_3298 resource : manager.method_14489(new class_2960("antiqueatlas:biome_textures.json"))) {
                    try {
                        InputStream stream = resource.method_14482();
                        Throwable throwable = null;
                        try {
                            InputStreamReader reader = new InputStreamReader(stream);
                            Throwable throwable2 = null;
                            try {
                                JsonElement element = PARSER.parse((Reader)reader);
                                if (element.isJsonObject()) {
                                    JsonObject obj = element.getAsJsonObject();
                                    if (!obj.has("version")) {
                                        Log.warn("Invalid biome texture file found!", new Object[0]);
                                        continue;
                                    }
                                    if (obj.get("version").getAsInt() < 2) {
                                        Log.warn("Outdated biome texture file version: " + obj.get("version").getAsInt(), new Object[0]);
                                        continue;
                                    }
                                    for (Map.Entry entry : obj.get("data").getAsJsonObject().entrySet()) {
                                        map.put(AntiqueAtlasMod.id((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsString());
                                    }
                                    continue;
                                }
                                Log.warn("Invalid biome texture file found!", new Object[0]);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                reader.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                    catch (Throwable e) {
                        Log.warn(e, "Failed to read biome texture file!", new Object[0]);
                    }
                }
            }
            catch (Throwable e) {
                Log.warn(e, "Failed to read biome textures!", new Object[0]);
            }
            return map;
        });
    }

    public CompletableFuture<Void> apply(Map<class_2960, String> biomeTexMap, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (Map.Entry entry : biomeTexMap.entrySet()) {
                class_1959 biome = (class_1959)class_5458.field_25933.method_10223((class_2960)entry.getKey());
                if (biome == null) {
                    Log.warn("Unknown biome in texture map: %s", entry.getKey());
                    continue;
                }
                String name = (String)entry.getValue();
                if (this.textureSetMap.isRegistered(name)) {
                    this.biomeTextureMap.setTexture(biome, this.textureSetMap.getByName(AntiqueAtlasMod.id(name)));
                    Log.info("Registered texture set %s for biome %s", name, entry.getKey());
                    continue;
                }
                Log.warn("Unknown texture set %s for biome %s", name, entry.getKey());
            }
        });
    }

    public class_2960 getFabricId() {
        return new class_2960("antiqueatlas:biome_textures");
    }

    public Collection<class_2960> getFabricDependencies() {
        return Collections.singleton(new class_2960("antiqueatlas:texture_sets"));
    }
}

