/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.SaveData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5458;
import net.minecraft.class_5464;

@Environment(value=EnvType.CLIENT)
public class BiomeTextureMap
extends SaveData {
    private static final BiomeTextureMap INSTANCE = new BiomeTextureMap();
    final Map<class_2960, TextureSet> textureMap = new HashMap<class_2960, TextureSet>();
    public static final TextureSet defaultTexture = TextureSet.PLAINS;

    public static BiomeTextureMap instance() {
        return INSTANCE;
    }

    public void setTexture(class_1959 biome, TextureSet textureSet) {
        this.setTexture(class_5458.field_25933.method_10221((Object)biome), textureSet);
    }

    public void setTexture(class_2960 tileId, TextureSet textureSet) {
        if (textureSet == null) {
            if (this.textureMap.remove(tileId) != null) {
                Log.warn("Removing old texture for %d", tileId);
            }
            return;
        }
        TextureSet previous = this.textureMap.put(tileId, textureSet);
        if (previous == null) {
            this.markDirty();
        } else if (!previous.equals(textureSet)) {
            Log.warn("Overwriting texture set for %d", tileId);
            this.markDirty();
        }
    }

    private void autoRegister(class_1959 biome) {
        if (biome == null) {
            Log.warn("Biome is null", new Object[0]);
            return;
        }
        switch (biome.method_8688()) {
            case field_9364: {
                this.setTexture(biome, biome.method_8686() >= 0.25f ? TextureSet.SWAMP_HILLS : TextureSet.SWAMP);
                break;
            }
            case field_9367: 
            case field_9369: {
                this.setTexture(biome, biome.method_8694() == class_1959.class_1963.field_9383 ? TextureSet.ICE : TextureSet.WATER);
                break;
            }
            case field_9363: {
                this.setTexture(biome, TextureSet.SHORE);
                break;
            }
            case field_9358: {
                this.setTexture(biome, biome.method_8686() >= 0.25f ? TextureSet.JUNGLE_HILLS : TextureSet.JUNGLE);
                break;
            }
            case field_9356: {
                this.setTexture(biome, biome.method_8695() >= 1.0f ? TextureSet.PLATEAU_SAVANNA : TextureSet.SAVANNA);
                break;
            }
            case field_9354: {
                this.setTexture(biome, TextureSet.PLATEAU_MESA);
                break;
            }
            case field_9370: {
                this.setTexture(biome, biome.method_8694() == class_1959.class_1963.field_9383 ? (biome.method_8686() >= 0.25f ? TextureSet.SNOW_PINES_HILLS : TextureSet.SNOW_PINES) : (biome.method_8686() >= 0.25f ? TextureSet.FOREST_HILLS : TextureSet.FOREST));
                break;
            }
            case field_9355: {
                this.setTexture(biome, biome.method_8694() == class_1959.class_1963.field_9383 ? (biome.method_8686() >= 0.25f ? TextureSet.SNOW_HILLS : TextureSet.SNOW) : (biome.method_8686() >= 0.25f ? TextureSet.HILLS : TextureSet.PLAINS));
                break;
            }
            case field_9362: {
                this.setTexture(biome, biome.method_8686() >= 0.25f ? TextureSet.MOUNTAINS_SNOW_CAPS : TextureSet.ICE_SPIKES);
                break;
            }
            case field_9368: {
                this.setTexture(biome, biome.method_8686() >= 0.25f ? TextureSet.DESERT_HILLS : TextureSet.DESERT);
                break;
            }
            case field_9361: {
                this.setTexture(biome, TextureSet.SNOW);
                break;
            }
            case field_9357: {
                this.setTexture(biome, biome.method_8686() >= 0.25f ? TextureSet.MOUNTAINS : TextureSet.HILLS);
                break;
            }
            case field_9360: {
                List features = biome.method_30970().method_30983();
                boolean has_chorus_plant = features.stream().anyMatch(supplier -> supplier.stream().anyMatch(step -> step.get() == class_5464.field_26119));
                if (has_chorus_plant) {
                    this.setTexture(biome, TextureSet.END_ISLAND_PLANTS);
                    break;
                }
                this.setTexture(biome, TextureSet.END_ISLAND);
                break;
            }
            case field_9371: {
                this.setTexture(biome, TextureSet.END_VOID);
                break;
            }
            default: {
                this.setTexture(biome, defaultTexture);
            }
        }
        Log.info("Auto-registered standard texture set for biome %s", class_5458.field_25933.method_10221((Object)biome).toString());
    }

    public void checkRegistration(class_1959 biome) {
        if (!this.isRegistered(biome)) {
            this.autoRegister(biome);
            this.markDirty();
        }
    }

    private void checkRegistration(class_2960 id) {
        if (!this.isRegistered(id)) {
            this.setTexture(id, defaultTexture);
        }
    }

    public boolean isRegistered(class_1959 biome) {
        return this.isRegistered(class_5458.field_25933.method_10221((Object)biome));
    }

    public boolean isRegistered(class_2960 id) {
        return this.textureMap.containsKey(id);
    }

    public TextureSet getTextureSet(class_2960 tile) {
        if (tile == null) {
            return defaultTexture;
        }
        class_1959 biome = (class_1959)class_5458.field_25933.method_10223(tile);
        if (biome != null) {
            this.checkRegistration(biome);
        } else {
            this.checkRegistration(tile);
        }
        return this.textureMap.get(tile);
    }

    public ITexture getTexture(SubTile subTile) {
        return this.getTextureSet(subTile.tile).getTexture(subTile.variationNumber);
    }

    public List<class_2960> getAllTextures() {
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        for (Map.Entry<class_2960, TextureSet> entry : this.textureMap.entrySet()) {
            Arrays.stream(entry.getValue().textures).map(iTexture -> list.add(iTexture.getTexture()));
        }
        return list;
    }
}

