/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.api.AtlasAPI;
import hunternif.mc.impl.atlas.client.BiomeTextureMap;
import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.SubTileQuartet;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.TileRenderIterator;
import hunternif.mc.impl.atlas.client.gui.ExportUpdateListener;
import hunternif.mc.impl.atlas.client.gui.GuiArrowButton;
import hunternif.mc.impl.atlas.client.gui.GuiBlinkingMarker;
import hunternif.mc.impl.atlas.client.gui.GuiBookmarkButton;
import hunternif.mc.impl.atlas.client.gui.GuiMarkerFinalizer;
import hunternif.mc.impl.atlas.client.gui.GuiPositionButton;
import hunternif.mc.impl.atlas.client.gui.GuiScaleBar;
import hunternif.mc.impl.atlas.client.gui.ProgressBarOverlay;
import hunternif.mc.impl.atlas.client.gui.core.GuiComponent;
import hunternif.mc.impl.atlas.client.gui.core.GuiComponentButton;
import hunternif.mc.impl.atlas.client.gui.core.GuiCursor;
import hunternif.mc.impl.atlas.client.gui.core.GuiStates;
import hunternif.mc.impl.atlas.client.gui.core.IButtonListener;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.client.texture.TileTexture;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.event.MarkerClickedCallback;
import hunternif.mc.impl.atlas.event.MarkerHoveredCallback;
import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.DimensionMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.network.packet.c2s.play.BrowsingPositionC2SPacket;
import hunternif.mc.impl.atlas.registry.MarkerRenderInfo;
import hunternif.mc.impl.atlas.registry.MarkerType;
import hunternif.mc.impl.atlas.util.ExportImageUtil;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.MathUtil;
import hunternif.mc.impl.atlas.util.Rect;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1160;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5321;

public class GuiAtlas
extends GuiComponent {
    public static final int WIDTH = 310;
    public static final int HEIGHT = 218;
    private static final int CONTENT_X = 17;
    private static final int CONTENT_Y = 11;
    private static final int MAP_WIDTH = 276;
    private static final int MAP_HEIGHT = 194;
    private static final float PLAYER_ROTATION_STEPS = 16.0f;
    private static final int PLAYER_ICON_WIDTH = 7;
    private static final int PLAYER_ICON_HEIGHT = 8;
    public static final int MARKER_SIZE = 32;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private static final double MIN_SCALE_THRESHOLD = 0.5;
    private final long[] renderTimes = new long[30];
    private int renderTimesIndex = 0;
    private final GuiStates state = new GuiStates();
    private final GuiStates.IState NORMAL = new GuiStates.SimpleState();
    private final GuiStates.IState HIDING_MARKERS = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.btnShowMarkers.setSelected(false);
            GuiAtlas.this.btnShowMarkers.setTitle((class_2561)new class_2588("gui.antiqueatlas.showMarkers"));
            GuiAtlas.this.btnShowMarkers.setIconTexture(Textures.ICON_SHOW_MARKERS);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.btnShowMarkers.setSelected(false);
            GuiAtlas.this.btnShowMarkers.setTitle((class_2561)new class_2588("gui.antiqueatlas.hideMarkers"));
            GuiAtlas.this.btnShowMarkers.setIconTexture(Textures.ICON_HIDE_MARKERS);
        }
    };
    private final GuiStates.IState PLACING_MARKER = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.btnMarker.setSelected(true);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.btnMarker.setSelected(false);
        }
    };
    private final GuiStates.IState DELETING_MARKER = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.addChild(GuiAtlas.this.eraser);
            GuiAtlas.this.btnDelMarker.setSelected(true);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.removeChild(GuiAtlas.this.eraser);
            GuiAtlas.this.btnDelMarker.setSelected(false);
        }
    };
    private final GuiCursor eraser = new GuiCursor();
    private final GuiStates.IState EXPORTING_IMAGE = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.btnExportPng.setSelected(true);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.btnExportPng.setSelected(false);
        }
    };
    private final GuiArrowButton btnUp;
    private final GuiArrowButton btnDown;
    private final GuiArrowButton btnLeft;
    private final GuiArrowButton btnRight;
    private final GuiBookmarkButton btnExportPng;
    private final GuiBookmarkButton btnMarker;
    private final GuiBookmarkButton btnDelMarker;
    private final GuiBookmarkButton btnShowMarkers;
    private final GuiPositionButton btnPosition;
    private static final int BUTTON_PAUSE = 8;
    private static final int navigateStep = 24;
    private GuiComponentButton selectedButton = null;
    private long timeButtonPressed = 0L;
    private boolean isDragging = false;
    private int mapOffsetX;
    private int mapOffsetY;
    private boolean followPlayer;
    private final GuiScaleBar scaleBar = new GuiScaleBar();
    private double mapScale;
    private int tileHalfSize;
    private int tile2ChunkScale;
    private DimensionMarkersData localMarkersData;
    private DimensionMarkersData globalMarkersData;
    private Marker hoveredMarker;
    private final GuiMarkerFinalizer markerFinalizer = new GuiMarkerFinalizer();
    private final GuiBlinkingMarker blinkingIcon = new GuiBlinkingMarker();
    private class_1657 player;
    private class_1799 stack;
    private WorldData biomeData;
    private double screenScale;
    private final ProgressBarOverlay progressBar = new ProgressBarOverlay(100, 2);
    private long lastUpdateMillis = System.currentTimeMillis();
    private int scaleAlpha = 255;
    private int scaleClipIndex = 0;
    private final int zoomLevelOne = 8;
    private int zoomLevel = 8;
    private final String[] zoomNames = new String[]{"256", "128", "64", "32", "16", "8", "4", "2", "1", "1/2", "1/4", "1/8", "1/16", "1/32", "1/64", "1/128", "1/256"};
    private Thread exportThread;

    public GuiAtlas() {
        this.setSize(310, 218);
        this.setMapScale(0.5);
        this.followPlayer = true;
        this.setInterceptKeyboard(true);
        this.btnUp = GuiArrowButton.up();
        this.addChild(this.btnUp).offsetGuiCoords(148, 10);
        this.btnDown = GuiArrowButton.down();
        this.addChild(this.btnDown).offsetGuiCoords(148, 194);
        this.btnLeft = GuiArrowButton.left();
        this.addChild(this.btnLeft).offsetGuiCoords(15, 100);
        this.btnRight = GuiArrowButton.right();
        this.addChild(this.btnRight).offsetGuiCoords(283, 100);
        this.btnPosition = new GuiPositionButton();
        this.btnPosition.setEnabled(!this.followPlayer);
        this.addChild(this.btnPosition).offsetGuiCoords(283, 194);
        IButtonListener<GuiComponentButton> positionListener = button -> {
            this.selectedButton = button;
            if (((Object)((Object)button)).equals((Object)this.btnPosition)) {
                this.followPlayer = true;
                this.btnPosition.setEnabled(false);
            } else {
                this.navigateByButton(this.selectedButton);
                this.timeButtonPressed = this.player.method_5770().method_8510();
            }
        };
        this.btnUp.addListener(positionListener);
        this.btnDown.addListener(positionListener);
        this.btnLeft.addListener(positionListener);
        this.btnRight.addListener(positionListener);
        this.btnPosition.addListener(positionListener);
        this.btnExportPng = new GuiBookmarkButton(1, Textures.ICON_EXPORT, (class_2561)new class_2588("gui.antiqueatlas.exportImage")){

            @Override
            public boolean isEnabled() {
                return !ExportImageUtil.isExporting;
            }
        };
        this.addChild(this.btnExportPng).offsetGuiCoords(300, 75);
        this.btnExportPng.addListener(button -> {
            if (this.stack != null || !AntiqueAtlasMod.CONFIG.itemNeeded) {
                this.exportThread = new Thread(() -> this.exportImage(this.getAtlasID()), "Atlas file export thread");
                this.exportThread.start();
            }
        });
        this.btnMarker = new GuiBookmarkButton(0, Textures.ICON_ADD_MARKER, (class_2561)new class_2588("gui.antiqueatlas.addMarker"));
        this.addChild(this.btnMarker).offsetGuiCoords(300, 14);
        this.btnMarker.addListener(button -> {
            if (this.state.is(this.PLACING_MARKER)) {
                this.selectedButton = null;
                this.state.switchTo(this.NORMAL);
            } else if (this.stack != null || !AntiqueAtlasMod.CONFIG.itemNeeded) {
                this.selectedButton = button;
                this.state.switchTo(this.PLACING_MARKER);
                if (GuiAtlas.method_25442()) {
                    this.markerFinalizer.setMarkerData(this.player.method_5770(), this.getAtlasID(), (int)this.player.method_23317(), (int)this.player.method_23321());
                    this.addChild(this.markerFinalizer);
                    this.blinkingIcon.setTexture(this.markerFinalizer.selectedType.getTexture(), 32, 32);
                    this.addChildBehind(this.markerFinalizer, this.blinkingIcon).setRelativeCoords(this.worldXToScreenX((int)this.player.method_23317()) - this.getGuiX() - 16, this.worldZToScreenY((int)this.player.method_23321()) - this.getGuiY() - 16);
                    this.setInterceptKeyboard(true);
                    class_304.method_1437();
                    this.selectedButton = null;
                    this.state.switchTo(this.NORMAL);
                }
            }
        });
        this.btnDelMarker = new GuiBookmarkButton(2, Textures.ICON_DELETE_MARKER, (class_2561)new class_2588("gui.antiqueatlas.delMarker"));
        this.addChild(this.btnDelMarker).offsetGuiCoords(300, 33);
        this.btnDelMarker.addListener(button -> {
            if (this.state.is(this.DELETING_MARKER)) {
                this.selectedButton = null;
                this.state.switchTo(this.NORMAL);
            } else if (this.stack != null || !AntiqueAtlasMod.CONFIG.itemNeeded) {
                this.selectedButton = button;
                this.state.switchTo(this.DELETING_MARKER);
            }
        });
        this.btnShowMarkers = new GuiBookmarkButton(3, Textures.ICON_HIDE_MARKERS, (class_2561)new class_2588("gui.antiqueatlas.hideMarkers"));
        this.addChild(this.btnShowMarkers).offsetGuiCoords(300, 52);
        this.btnShowMarkers.addListener(button -> {
            this.selectedButton = null;
            if (this.state.is(this.HIDING_MARKERS)) {
                this.state.switchTo(this.NORMAL);
            } else if (this.stack != null || !AntiqueAtlasMod.CONFIG.itemNeeded) {
                this.selectedButton = null;
                this.state.switchTo(this.HIDING_MARKERS);
            }
        });
        this.addChild(this.scaleBar).offsetGuiCoords(20, 198);
        this.scaleBar.setMapScale(1.0);
        this.markerFinalizer.addMarkerListener(this.blinkingIcon);
        this.eraser.setTexture(Textures.ERASER, 12, 14, 2, 11);
        this.state.switchTo(this.NORMAL);
    }

    public GuiAtlas prepareToOpen(class_1799 stack) {
        this.stack = stack;
        return this.prepareToOpen();
    }

    public GuiAtlas prepareToOpen() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
        this.player = class_310.method_1551().field_1724;
        this.updateAtlasData();
        if (!this.followPlayer && AntiqueAtlasMod.CONFIG.doSaveBrowsingPos) {
            this.loadSavedBrowsingPosition();
        }
        return this;
    }

    public void loadSavedBrowsingPosition() {
        this.setMapScale(this.biomeData.getBrowsingZoom());
        this.mapOffsetX = this.biomeData.getBrowsingX();
        this.mapOffsetY = this.biomeData.getBrowsingY();
        this.isDragging = false;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.state.is(this.EXPORTING_IMAGE)) {
            this.state.switchTo(this.NORMAL);
        }
        class_310.method_1551().field_1774.method_1462(true);
        this.screenScale = class_310.method_1551().method_22683().method_4495();
        this.setCentered();
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int mouseState) {
        boolean isMouseOverMap;
        boolean result = super.method_25402(mouseX, mouseY, mouseState);
        if (this.state.is(this.EXPORTING_IMAGE)) {
            return result;
        }
        if (result) {
            return true;
        }
        if (mouseState == 1 && this.state.is(this.NORMAL)) {
            this.method_25419();
            return true;
        }
        int mapX = (this.field_22789 - 276) / 2;
        int mapY = (this.field_22790 - 194) / 2;
        boolean bl = isMouseOverMap = mouseX >= (double)mapX && mouseX <= (double)(mapX + 276) && mouseY >= (double)mapY && mouseY <= (double)(mapY + 194);
        if (!this.state.is(this.NORMAL) && !this.state.is(this.HIDING_MARKERS)) {
            int atlasID = this.getAtlasID();
            if (this.state.is(this.PLACING_MARKER) && isMouseOverMap && mouseState == 0) {
                this.markerFinalizer.setMarkerData(this.player.method_5770(), atlasID, this.screenXToWorldX((int)mouseX), this.screenYToWorldZ((int)mouseY));
                this.addChild(this.markerFinalizer);
                this.blinkingIcon.setTexture(this.markerFinalizer.selectedType.getTexture(), 32, 32);
                this.addChildBehind(this.markerFinalizer, this.blinkingIcon).setRelativeCoords((int)mouseX - this.getGuiX() - 16, (int)mouseY - this.getGuiY() - 16);
                this.setInterceptKeyboard(true);
                class_304.method_1437();
                this.state.switchTo(this.NORMAL);
                return true;
            }
            if (this.state.is(this.DELETING_MARKER) && this.hoveredMarker != null && !this.hoveredMarker.isGlobal() && isMouseOverMap && mouseState == 0) {
                AtlasAPI.markers.deleteMarker(this.player.method_5770(), atlasID, this.hoveredMarker.getId());
                this.hoveredMarker = null;
                this.player.method_5770().method_8396(this.player, this.player.method_24515(), class_3417.field_17484, class_3419.field_15256, 1.0f, 0.5f);
            }
            this.state.switchTo(this.NORMAL);
        } else if (isMouseOverMap && this.selectedButton == null && (this.hoveredMarker == null || !((MarkerClickedCallback)MarkerClickedCallback.EVENT.invoker()).onClicked(this.player, this.hoveredMarker, mouseState))) {
            this.isDragging = true;
            return true;
        }
        return false;
    }

    private void exportImage(int atlasID) {
        boolean showMarkers = !this.state.is(this.HIDING_MARKERS);
        this.state.switchTo(this.EXPORTING_IMAGE);
        ExportImageUtil.isExporting = true;
        File screenshot_folder = new File(class_310.method_1551().field_1697, "screenshots");
        if (!screenshot_folder.isDirectory()) {
            screenshot_folder.mkdir();
        }
        String outputname = "atlas-" + DATE_FORMAT.format(new Date());
        File file = new File(screenshot_folder, outputname + ".png");
        int i = 1;
        while (file.exists()) {
            file = new File(screenshot_folder, outputname + "_" + i + ".png");
            ++i;
        }
        try {
            Log.info("Exporting image from Atlas #%d to file %s", atlasID, file.getAbsolutePath());
            ExportImageUtil.exportPngImage(this.biomeData, this.globalMarkersData, this.localMarkersData, file, showMarkers);
            Log.info("Finished exporting image", new Object[0]);
        }
        catch (OutOfMemoryError e) {
            Log.warn(e, "Image is too large, trying to export in strips", new Object[0]);
            try {
                ExportImageUtil.exportPngImageTooLarge(this.biomeData, this.globalMarkersData, this.localMarkersData, file, showMarkers);
            }
            catch (OutOfMemoryError e2) {
                int minX = (this.biomeData.getScope().minX - 1) * 16;
                int minY = (this.biomeData.getScope().minY - 1) * 16;
                int outWidth = (this.biomeData.getScope().maxX + 2) * 16 - minX;
                int outHeight = (this.biomeData.getScope().maxY + 2) * 16 - minY;
                Log.error(e2, "Image is STILL too large, how massive is this map?! Answer: (%dx%d)", outWidth, outHeight);
                ExportUpdateListener.INSTANCE.setStatusString(class_1074.method_4662((String)"gui.antiqueatlas.export.tooLarge", (Object[])new Object[0]), new Object[0]);
                ExportImageUtil.isExporting = false;
                return;
            }
        }
        ExportImageUtil.isExporting = false;
        this.state.switchTo(showMarkers ? this.NORMAL : this.HIDING_MARKERS);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.navigateMap(0, 24);
        } else if (keyCode == 264) {
            this.navigateMap(0, -24);
        } else if (keyCode == 263) {
            this.navigateMap(24, 0);
        } else if (keyCode == 262) {
            this.navigateMap(-24, 0);
        } else if (keyCode == 61 || keyCode == 334) {
            this.setMapScale(this.mapScale * 2.0);
        } else if (keyCode == 45 || keyCode == 333) {
            this.setMapScale(this.mapScale / 2.0);
        } else if (keyCode == 256) {
            this.method_25419();
        } else {
            class_304[] hotbarKeys;
            for (class_304 bind : hotbarKeys = class_310.method_1551().field_1690.field_1852) {
                if (!bind.method_1417(keyCode, scanCode) || this.markerFinalizer.getParent() != null) continue;
                this.method_25419();
                return false;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        return true;
    }

    @Override
    public boolean method_25401(double mx, double my, double wheelMove) {
        double origWheelMove = wheelMove;
        boolean handled = super.method_25401(mx, my, origWheelMove);
        if (!handled && wheelMove != 0.0) {
            double d = wheelMove = wheelMove > 0.0 ? 1.0 : -1.0;
            if (AntiqueAtlasMod.CONFIG.doReverseWheelZoom) {
                wheelMove *= -1.0;
            }
            double mouseOffsetX = (double)class_310.method_1551().method_22683().method_4489() / this.screenScale / 2.0 - this.getMouseX();
            double mouseOffsetY = (double)class_310.method_1551().method_22683().method_4506() / this.screenScale / 2.0 - this.getMouseY();
            double newScale = this.mapScale * Math.pow(2.0, wheelMove);
            double addOffsetX = 0.0;
            double addOffsetY = 0.0;
            if (Math.abs(mouseOffsetX) < 138.0 && Math.abs(mouseOffsetY) < 97.0) {
                addOffsetX = mouseOffsetX * wheelMove;
                addOffsetY = mouseOffsetY * wheelMove;
                if (wheelMove > 0.0) {
                    addOffsetX *= this.mapScale / newScale;
                    addOffsetY *= this.mapScale / newScale;
                }
            }
            this.setMapScale(newScale, (int)addOffsetX, (int)addOffsetY);
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
            return true;
        }
        return handled;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int mouseState) {
        boolean result = false;
        if (mouseState != -1) {
            result = this.selectedButton != null || this.isDragging;
            this.selectedButton = null;
            this.isDragging = false;
        }
        return super.method_25406(mouseX, mouseY, mouseState) || result;
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int lastMouseButton, double deltaX, double deltaY) {
        boolean result = false;
        if (this.isDragging) {
            this.followPlayer = false;
            this.btnPosition.setEnabled(true);
            this.mapOffsetX += (int)deltaX;
            this.mapOffsetY += (int)deltaY;
            result = true;
        }
        return super.method_25403(mouseX, mouseY, lastMouseButton, deltaX, deltaY) || result;
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.player == null) {
            return;
        }
        if (this.followPlayer) {
            this.mapOffsetX = (int)(-this.player.method_23317() * this.mapScale);
            this.mapOffsetY = (int)(-this.player.method_23321() * this.mapScale);
        }
        if (this.player.method_5770().method_8510() > this.timeButtonPressed + 8L) {
            this.navigateByButton(this.selectedButton);
        }
        this.updateAtlasData();
    }

    private void updateAtlasData() {
        int atlasID = this.getAtlasID();
        this.biomeData = AntiqueAtlasMod.atlasData.getAtlasData(atlasID, this.player.method_5770()).getWorldData((class_5321<class_1937>)this.player.method_5770().method_27983());
        this.globalMarkersData = AntiqueAtlasMod.globalMarkersData.getData().getMarkersDataInWorld((class_5321<class_1937>)this.player.method_5770().method_27983());
        MarkersData markersData = AntiqueAtlasMod.markersData.getMarkersData(atlasID, this.player.method_5770());
        this.localMarkersData = markersData != null ? markersData.getMarkersDataInWorld((class_5321<class_1937>)this.player.method_5770().method_27983()) : null;
    }

    private void navigateByButton(GuiComponentButton btn) {
        if (btn == null) {
            return;
        }
        if (((Object)((Object)btn)).equals((Object)this.btnUp)) {
            this.navigateMap(0, 24);
        } else if (((Object)((Object)btn)).equals((Object)this.btnDown)) {
            this.navigateMap(0, -24);
        } else if (((Object)((Object)btn)).equals((Object)this.btnLeft)) {
            this.navigateMap(24, 0);
        } else if (((Object)((Object)btn)).equals((Object)this.btnRight)) {
            this.navigateMap(-24, 0);
        }
    }

    private void navigateMap(int dx, int dy) {
        this.mapOffsetX += dx;
        this.mapOffsetY += dy;
        this.followPlayer = false;
        this.btnPosition.setEnabled(true);
    }

    public void setMapScale(double scale) {
        this.setMapScale(scale, 0, 0);
    }

    private void setMapScale(double scale, int addOffsetX, int addOffsetY) {
        double oldScale = this.mapScale;
        this.mapScale = Math.min(Math.max(scale, AntiqueAtlasMod.CONFIG.minScale), AntiqueAtlasMod.CONFIG.maxScale);
        if (oldScale == this.mapScale) {
            return;
        }
        if (this.mapScale >= 0.5) {
            this.tileHalfSize = (int)Math.round(8.0 * this.mapScale);
            this.tile2ChunkScale = 1;
        } else {
            this.tileHalfSize = (int)Math.round(4.0);
            this.tile2ChunkScale = (int)Math.round(0.5 / this.mapScale);
        }
        this.scaleBar.setMapScale(this.mapScale * 2.0);
        this.mapOffsetX = (int)((double)(this.mapOffsetX + addOffsetX) * (this.mapScale / oldScale));
        this.mapOffsetY = (int)((double)(this.mapOffsetY + addOffsetY) * (this.mapScale / oldScale));
        this.scaleClipIndex = class_3532.method_15351((int)((int)(this.mapScale * 8192.0))) + 1 - 13;
        this.zoomLevel = -this.scaleClipIndex + 8;
        this.scaleAlpha = 255;
        if (this.followPlayer && (addOffsetX != 0 || addOffsetY != 0)) {
            this.followPlayer = false;
            this.btnPosition.setEnabled(true);
        }
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float par3) {
        long currentMillis = System.currentTimeMillis();
        long deltaMillis = currentMillis - this.lastUpdateMillis;
        this.lastUpdateMillis = currentMillis;
        if (AntiqueAtlasMod.CONFIG.debugRender) {
            this.renderTimes[this.renderTimesIndex++] = System.currentTimeMillis();
            if (this.renderTimesIndex == this.renderTimes.length) {
                this.renderTimesIndex = 0;
                double elapsed = 0.0;
                for (int i = 0; i < this.renderTimes.length - 1; ++i) {
                    elapsed += (double)(this.renderTimes[i + 1] - this.renderTimes[i]);
                }
                System.out.printf("GuiAtlas avg. render time: %.3f\n", elapsed / (double)this.renderTimes.length);
            }
        }
        super.method_25420(matrices);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableAlphaTest();
        RenderSystem.alphaFunc((int)516, (float)0.0f);
        Textures.BOOK.draw(matrices, this.getGuiX(), this.getGuiY());
        if (this.stack == null && AntiqueAtlasMod.CONFIG.itemNeeded || this.biomeData == null) {
            return;
        }
        if (this.state.is(this.DELETING_MARKER)) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
        RenderSystem.enableScissor((int)((int)((double)(this.getGuiX() + 17) * this.screenScale)), (int)((int)((double)class_310.method_1551().method_22683().method_4506() - (double)(this.getGuiY() + 11 + 194) * this.screenScale)), (int)((int)(276.0 * this.screenScale)), (int)((int)(194.0 * this.screenScale)));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int mapStartX = MathUtil.roundToBase((int)Math.floor(-(138.0 + (double)this.mapOffsetX + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapStartZ = MathUtil.roundToBase((int)Math.floor(-(97.0 + (double)this.mapOffsetY + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapEndX = MathUtil.roundToBase((int)Math.ceil((138.0 - (double)this.mapOffsetX + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapEndZ = MathUtil.roundToBase((int)Math.ceil((97.0 - (double)this.mapOffsetY + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapStartScreenX = this.getGuiX() + 155 + (int)((double)(mapStartX << 4) * this.mapScale) + this.mapOffsetX;
        int mapStartScreenY = this.getGuiY() + 109 + (int)((double)(mapStartZ << 4) * this.mapScale) + this.mapOffsetY;
        TileRenderIterator iter = new TileRenderIterator(this.biomeData);
        iter.setScope(new Rect().setOrigin(mapStartX, mapStartZ).set(mapStartX, mapStartZ, mapEndX, mapEndZ));
        iter.setStep(this.tile2ChunkScale);
        matrices.method_22903();
        matrices.method_22904((double)mapStartScreenX, (double)mapStartScreenY, 0.0);
        while (iter.hasNext()) {
            SubTileQuartet subtiles = iter.next();
            for (SubTile subtile : subtiles) {
                ITexture texture;
                if (subtile == null || subtile.tile == null || !((texture = BiomeTextureMap.instance().getTexture(subtile)) instanceof TileTexture)) continue;
                TileTexture tileTexture = (TileTexture)texture;
                tileTexture.bind();
                tileTexture.drawSubTile(matrices, subtile, this.tileHalfSize);
            }
        }
        matrices.method_22909();
        int markersStartX = MathUtil.roundToBase(mapStartX, 8) / 8 - 1;
        int markersStartZ = MathUtil.roundToBase(mapStartZ, 8) / 8 - 1;
        int markersEndX = MathUtil.roundToBase(mapEndX, 8) / 8 + 1;
        int markersEndZ = MathUtil.roundToBase(mapEndZ, 8) / 8 + 1;
        this.renderMarkers(matrices, mouseX, mouseY, markersStartX, markersStartZ, markersEndX, markersEndZ, this.globalMarkersData);
        this.renderMarkers(matrices, mouseX, mouseY, markersStartX, markersStartZ, markersEndX, markersEndZ, this.localMarkersData);
        RenderSystem.disableScissor();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Textures.BOOK_FRAME.draw(matrices, this.getGuiX(), this.getGuiY());
        this.renderScaleOverlay(matrices, deltaMillis);
        double iconScale = this.getIconScale();
        if (!this.state.is(this.HIDING_MARKERS)) {
            int playerOffsetX = (int)(this.player.method_23317() * this.mapScale) + this.mapOffsetX;
            int playerOffsetZ = (int)(this.player.method_23321() * this.mapScale) + this.mapOffsetY;
            if (playerOffsetX < -138) {
                playerOffsetX = -138;
            }
            if (playerOffsetX > 138) {
                playerOffsetX = 138;
            }
            if (playerOffsetZ < -97) {
                playerOffsetZ = -97;
            }
            if (playerOffsetZ > 95) {
                playerOffsetZ = 95;
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.state.is(this.PLACING_MARKER) ? 0.5f : 1.0f));
            matrices.method_22903();
            matrices.method_22904((double)(this.getGuiX() + 155 + playerOffsetX), (double)(this.getGuiY() + 109 + playerOffsetZ), 0.0);
            float playerRotation = (float)Math.round(this.player.field_6031 / 360.0f * 16.0f) / 16.0f * 360.0f;
            matrices.method_22907(class_1160.field_20707.method_23214(180.0f + playerRotation));
            matrices.method_22904((double)((float)(-3.0 * iconScale)), (double)((float)(-4.0 * iconScale)), 0.0);
            Textures.PLAYER.draw(matrices, 0, 0, (int)Math.round(7.0 * iconScale), (int)Math.round(8.0 * iconScale));
            matrices.method_22909();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        super.method_25394(matrices, mouseX, mouseY, par3);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        if (this.state.is(this.PLACING_MARKER)) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            this.markerFinalizer.selectedType.calculateMip(iconScale, this.mapScale, this.screenScale);
            MarkerRenderInfo renderInfo = this.markerFinalizer.selectedType.getRenderInfo(iconScale, this.mapScale, this.screenScale);
            this.markerFinalizer.selectedType.resetMip();
            renderInfo.tex.draw(matrices, mouseX + renderInfo.x, mouseY + renderInfo.y);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.disableBlend();
        if (this.state.is(this.EXPORTING_IMAGE)) {
            this.method_25420(matrices);
            this.progressBar.draw(matrices, (this.field_22789 - 100) / 2, this.field_22790 / 2 - 34);
        }
    }

    private void renderMarkers(class_4587 matrices, int mouseX, int mouseY, int markersStartX, int markersStartZ, int markersEndX, int markersEndZ, DimensionMarkersData markersData) {
        if (markersData == null) {
            return;
        }
        for (int x = markersStartX; x <= markersEndX; ++x) {
            for (int z = markersStartZ; z <= markersEndZ; ++z) {
                List<Marker> markers = markersData.getMarkersAtChunk(x, z);
                if (markers == null) continue;
                for (Marker marker : markers) {
                    this.renderMarker(matrices, mouseX, mouseY, marker, this.getIconScale());
                }
            }
        }
    }

    private void renderScaleOverlay(class_4587 matrices, long deltaMillis) {
        if (this.scaleAlpha > 3) {
            int textWidth;
            matrices.method_22903();
            matrices.method_22904((double)(this.getGuiX() + 310 - 13), (double)(this.getGuiY() + 12), 0.0);
            int color = this.scaleAlpha << 24;
            String text = "x";
            int xWidth = textWidth = this.field_22793.method_1727(text);
            ++xWidth;
            this.field_22793.method_1729(matrices, text, (float)(-textWidth), 0.0f, color);
            text = this.zoomNames[this.zoomLevel];
            if (text.contains("/")) {
                String[] parts = text.split("/");
                int centerXtranslate = Math.max(this.field_22793.method_1727(parts[0]), this.field_22793.method_1727(parts[1])) / 2;
                double d = -xWidth - centerXtranslate;
                this.field_22793.getClass();
                matrices.method_22904(d, (double)((float)(-9) / 2.0f), 0.0);
                int n = -centerXtranslate - 1;
                this.field_22793.getClass();
                this.field_22793.getClass();
                class_332.method_25294((class_4587)matrices, (int)n, (int)(9 - 1), (int)centerXtranslate, (int)9, (int)color);
                textWidth = this.field_22793.method_1727(parts[0]);
                this.field_22793.method_1729(matrices, parts[0], (float)(-textWidth) / 2.0f, 0.0f, color);
                textWidth = this.field_22793.method_1727(parts[1]);
                this.field_22793.method_1729(matrices, parts[1], (float)(-textWidth) / 2.0f, 10.0f, color);
            } else {
                textWidth = this.field_22793.method_1727(text);
                this.field_22793.method_1729(matrices, text, (float)(-textWidth - xWidth + 1), 2.0f, color);
            }
            matrices.method_22909();
            int deltaScaleAlpha = (int)((double)deltaMillis * 0.256);
            if (deltaScaleAlpha == 0) {
                deltaScaleAlpha = 1;
            }
            this.scaleAlpha -= deltaScaleAlpha;
            if (this.scaleAlpha < 0) {
                this.scaleAlpha = 0;
            }
        }
    }

    private void renderMarker(class_4587 matrices, int mouseX, int mouseY, Marker marker, double scale) {
        MarkerType type = (MarkerType)MarkerType.REGISTRY.method_10223(marker.getType());
        if (type == null) {
            Log.warn("Could not find marker data for %s. Is it in the config file?\n", marker.getType());
            return;
        }
        if (type.shouldHide(this.state.is(this.HIDING_MARKERS), this.scaleClipIndex)) {
            return;
        }
        int markerX = this.worldXToScreenX(marker.getX());
        int markerY = this.worldZToScreenY(marker.getZ());
        if (!marker.isVisibleAhead() && !this.biomeData.hasTileAt(marker.getChunkX(), marker.getChunkZ())) {
            return;
        }
        type.calculateMip(scale, this.mapScale, this.screenScale);
        MarkerRenderInfo info = type.getRenderInfo(scale, this.mapScale, this.screenScale);
        boolean mouseIsOverMarker = type.shouldHover((this.getMouseX() - (double)(markerX + info.x)) / (double)info.tex.width(), (this.getMouseY() - (double)(markerY + info.y)) / (double)info.tex.height());
        type.resetMip();
        if (mouseIsOverMarker) {
            RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            this.hoveredMarker = marker;
            ((MarkerHoveredCallback)MarkerHoveredCallback.EVENT.invoker()).onHovered(this.player, marker);
        } else {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.hoveredMarker == marker) {
                this.hoveredMarker = null;
            }
        }
        if (this.state.is(this.PLACING_MARKER)) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        } else if (this.state.is(this.DELETING_MARKER) && marker.isGlobal()) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        } else {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (AntiqueAtlasMod.CONFIG.debugRender) {
            System.out.println("Rendering Marker: " + info.tex);
        }
        info.tex.draw(matrices, markerX + info.x, markerY + info.y, info.width, info.height);
        if (this.isMouseOver && mouseIsOverMarker && marker.getLabel().getString().length() > 0) {
            this.drawTooltip(Collections.singletonList(marker.getLabel()), this.field_22793);
        }
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    public void method_25419() {
        super.method_25419();
        this.markerFinalizer.close();
        this.removeChild(this.blinkingIcon);
        this.biomeData.setBrowsingPosition(this.mapOffsetX, this.mapOffsetY, this.mapScale);
        new BrowsingPositionC2SPacket(this.getAtlasID(), (class_5321<class_1937>)this.player.method_5770().method_27983(), this.mapOffsetX, this.mapOffsetY, this.mapScale).send();
    }

    private int screenXToWorldX(int mouseX) {
        return (int)Math.round((double)(mouseX - this.field_22789 / 2 - this.mapOffsetX) / this.mapScale);
    }

    private int screenYToWorldZ(int mouseY) {
        return (int)Math.round((double)(mouseY - this.field_22790 / 2 - this.mapOffsetY) / this.mapScale);
    }

    private int worldXToScreenX(int x) {
        return (int)Math.round((double)x * this.mapScale + (double)((float)this.field_22789 / 2.0f) + (double)this.mapOffsetX);
    }

    private int worldZToScreenY(int z) {
        return (int)Math.round((double)z * this.mapScale + (double)((float)this.field_22790 / 2.0f) + (double)this.mapOffsetY);
    }

    @Override
    protected void onChildClosed(GuiComponent child) {
        if (((Object)((Object)child)).equals((Object)this.markerFinalizer)) {
            this.setInterceptKeyboard(true);
            this.removeChild(this.blinkingIcon);
        }
    }

    public void updateL18n() {
        this.btnExportPng.setTitle((class_2561)new class_2588("gui.antiqueatlas.exportImage"));
        this.btnMarker.setTitle((class_2561)new class_2588("gui.antiqueatlas.addMarker"));
    }

    private double getIconScale() {
        return AntiqueAtlasMod.CONFIG.doScaleMarkers ? (this.mapScale < 0.5 ? 0.5 : (this.mapScale > 1.0 ? 2.0 : 1.0)) : 1.0;
    }

    private int getAtlasID() {
        return AntiqueAtlasMod.CONFIG.itemNeeded ? AtlasItem.getAtlasID(this.stack) : this.player.method_5667().hashCode();
    }
}

