/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.BiomeDetectorBase;
import hunternif.mc.impl.atlas.core.BiomeDetectorEnd;
import hunternif.mc.impl.atlas.core.BiomeDetectorNether;
import hunternif.mc.impl.atlas.core.IBiomeDetector;
import hunternif.mc.impl.atlas.core.TileInfo;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.network.packet.s2c.play.MapDataS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.ShortVec2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class AtlasData
extends class_18 {
    public static final int VERSION = 4;
    public static final String TAG_VERSION = "aaVersion";
    public static final String TAG_WORLD_MAP_LIST = "qWorldMap";
    public static final String TAG_WORLD_ID = "qWorldID";
    public static final String TAG_VISITED_CHUNKS = "qVisitedChunks";
    public static final String TAG_BROWSING_X = "qBrowseX";
    public static final String TAG_BROWSING_Y = "qBrowseY";
    public static final String TAG_BROWSING_ZOOM = "qBrowseZoom";
    private final Map<class_5321<class_1937>, IBiomeDetector> biomeAnalyzers = new HashMap<class_5321<class_1937>, IBiomeDetector>();
    private final BiomeDetectorBase biomeDetectorOverworld = new BiomeDetectorBase();
    private final BiomeDetectorNether biomeDetectorNether = new BiomeDetectorNether();
    private final BiomeDetectorEnd biomeDetectorEnd = new BiomeDetectorEnd();
    private final Map<class_5321<class_1937>, WorldData> worldMap = new ConcurrentHashMap<class_5321<class_1937>, WorldData>(2, 0.75f, 2);
    private final Set<class_1657> playersSentTo = new HashSet<class_1657>();
    private class_2487 nbt;

    public AtlasData(String key) {
        super(key);
        this.biomeDetectorOverworld.setScanPonds(AntiqueAtlasMod.CONFIG.doScanPonds);
        this.biomeDetectorOverworld.setScanRavines(AntiqueAtlasMod.CONFIG.doScanRavines);
        this.setBiomeDetectorForWorld((class_5321<class_1937>)class_1937.field_25179, this.biomeDetectorOverworld);
        this.setBiomeDetectorForWorld((class_5321<class_1937>)class_1937.field_25180, this.biomeDetectorNether);
        this.setBiomeDetectorForWorld((class_5321<class_1937>)class_1937.field_25181, this.biomeDetectorEnd);
    }

    public void method_77(class_2487 compound) {
        this.nbt = compound;
        int version = compound.method_10550(TAG_VERSION);
        if (version < 4) {
            Log.warn("Outdated atlas data format! Was %d but current is %d.", version, 4);
            return;
        }
        class_2499 worldMapList = compound.method_10554(TAG_WORLD_MAP_LIST, 10);
        for (int d = 0; d < worldMapList.size(); ++d) {
            class_2487 worldTag = worldMapList.method_10602(d);
            class_5321 worldID = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(worldTag.method_10558(TAG_WORLD_ID)));
            class_2499 dimensionTag = (class_2499)worldTag.method_10580(TAG_VISITED_CHUNKS);
            WorldData dimData = this.getWorldData((class_5321<class_1937>)worldID);
            dimData.readFromNBT(dimensionTag);
            double zoom = worldTag.method_10574(TAG_BROWSING_ZOOM);
            if (zoom == 0.0) {
                zoom = 0.5;
            }
            dimData.setBrowsingPosition(worldTag.method_10550(TAG_BROWSING_X), worldTag.method_10550(TAG_BROWSING_Y), zoom);
        }
    }

    public class_2487 method_75(class_2487 compound) {
        return this.writeToNBT(compound, true);
    }

    public class_2487 writeToNBT(class_2487 compound, boolean includeTileData) {
        class_2499 dimensionMapList = new class_2499();
        compound.method_10569(TAG_VERSION, 4);
        for (Map.Entry<class_5321<class_1937>, WorldData> dimensionEntry : this.worldMap.entrySet()) {
            class_2487 dimTag = new class_2487();
            dimTag.method_10582(TAG_WORLD_ID, dimensionEntry.getKey().method_29177().toString());
            WorldData dimData = dimensionEntry.getValue();
            if (includeTileData) {
                dimTag.method_10566(TAG_VISITED_CHUNKS, (class_2520)dimData.writeToNBT());
            }
            dimTag.method_10569(TAG_BROWSING_X, dimData.getBrowsingX());
            dimTag.method_10569(TAG_BROWSING_Y, dimData.getBrowsingY());
            dimTag.method_10549(TAG_BROWSING_ZOOM, dimData.getBrowsingZoom());
            dimensionMapList.add((Object)dimTag);
        }
        compound.method_10566(TAG_WORLD_MAP_LIST, (class_2520)dimensionMapList);
        return compound;
    }

    private void setBiomeDetectorForWorld(class_5321<class_1937> world, IBiomeDetector biomeAnalyzer) {
        this.biomeAnalyzers.put(world, biomeAnalyzer);
    }

    private IBiomeDetector getBiomeDetectorForWorld(class_5321<class_1937> world) {
        IBiomeDetector biomeAnalyzer = this.biomeAnalyzers.get(world);
        return biomeAnalyzer == null ? this.biomeDetectorOverworld : biomeAnalyzer;
    }

    public Collection<TileInfo> updateMapAroundPlayer(class_1657 player) {
        int newScanInterval = Math.round(AntiqueAtlasMod.CONFIG.newScanInterval * 20.0f);
        if (player.method_5770().method_8510() % (long)newScanInterval != 0L) {
            return Collections.emptyList();
        }
        ArrayList<TileInfo> updatedTiles = new ArrayList<TileInfo>();
        int rescanInterval = newScanInterval * AntiqueAtlasMod.CONFIG.rescanRate;
        boolean rescanRequired = AntiqueAtlasMod.CONFIG.doRescan && player.method_5770().method_8510() % (long)rescanInterval == 0L;
        int scanRadius = AntiqueAtlasMod.CONFIG.scanRadius;
        for (int dx = -scanRadius; dx <= scanRadius; ++dx) {
            for (int dz = -scanRadius; dz <= scanRadius; ++dz) {
                if (dx * dx + dz * dz > scanRadius * scanRadius) continue;
                int chunkX = player.field_6024 + dx;
                int chunkZ = player.field_5980 + dz;
                TileInfo update = this.updateMapChunk(player.method_5770(), chunkX, chunkZ, rescanRequired);
                if (update == null) continue;
                updatedTiles.add(update);
            }
        }
        return updatedTiles;
    }

    private TileInfo updateMapChunk(class_1937 world, int x, int z, boolean rescanRequired) {
        WorldData seenChunks = this.getWorldData((class_5321<class_1937>)world.method_27983());
        class_2960 oldTile = seenChunks.getTile(x, z);
        class_2960 tile = null;
        tile = AntiqueAtlasMod.tileData.getData(world).getTile(x, z);
        if (tile == null) {
            if (oldTile != null && !rescanRequired) {
                return null;
            }
            class_2791 chunk = world.method_8402(x, z, class_2806.field_12803, AntiqueAtlasMod.CONFIG.forceChunkLoading);
            if (chunk == null) {
                return null;
            }
            IBiomeDetector biomeDetector = this.getBiomeDetectorForWorld((class_5321<class_1937>)world.method_27983());
            tile = biomeDetector.getBiomeID(world, chunk);
            if (oldTile != null) {
                if (tile == null) {
                    this.removeTile((class_5321<class_1937>)world.method_27983(), x, z);
                } else if (!oldTile.equals((Object)tile)) {
                    this.setTile((class_5321<class_1937>)world.method_27983(), x, z, tile);
                    return new TileInfo(x, z, tile);
                }
            } else if (tile != null) {
                this.setTile((class_5321<class_1937>)world.method_27983(), x, z, tile);
                return new TileInfo(x, z, tile);
            }
        } else if (oldTile == null || !oldTile.equals((Object)tile)) {
            this.setTile((class_5321<class_1937>)world.method_27983(), x, z, tile);
            this.method_80();
            return new TileInfo(x, z, tile);
        }
        return null;
    }

    public void setTile(class_5321<class_1937> world, int x, int y, class_2960 tile) {
        WorldData worldData = this.getWorldData(world);
        worldData.setTile(x, y, tile);
    }

    private class_2960 removeTile(class_5321<class_1937> world, int x, int y) {
        WorldData dimData = this.getWorldData(world);
        return dimData.removeTile(x, y);
    }

    public Set<class_5321<class_1937>> getVisitedWorlds() {
        return this.worldMap.keySet();
    }

    public WorldData getWorldData(class_5321<class_1937> world) {
        return this.worldMap.computeIfAbsent(world, k -> new WorldData(this, world));
    }

    public Map<ShortVec2, class_2960> getSeenChunksInDimension(class_5321<class_1937> world) {
        return this.getWorldData(world).getSeenChunks();
    }

    public Collection<class_1657> getSyncedPlayers() {
        return Collections.unmodifiableCollection(this.playersSentTo);
    }

    public boolean isSyncedOnPlayer(class_1657 player) {
        return this.playersSentTo.contains(player);
    }

    public void syncOnPlayer(int atlasID, class_1657 player) {
        if (this.nbt == null) {
            this.nbt = new class_2487();
        }
        this.writeToNBT(this.nbt, false);
        new MapDataS2CPacket(atlasID, this.nbt).send((class_3222)player);
        for (class_5321<class_1937> world : this.worldMap.keySet()) {
            this.worldMap.get(world).syncOnPlayer(atlasID, player);
        }
        Log.info("Sent Atlas #%d data to player %s", atlasID, player.method_5671().method_9214());
        this.playersSentTo.add(player);
    }

    public boolean isEmpty() {
        return this.worldMap.isEmpty();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AtlasData)) {
            return false;
        }
        AtlasData other = (AtlasData)((Object)obj);
        if (other.worldMap.size() != this.worldMap.size()) {
            return false;
        }
        for (class_5321<class_1937> key : this.worldMap.keySet()) {
            if (this.worldMap.get(key).equals(other.worldMap.get(key))) continue;
            return false;
        }
        return true;
    }
}

