/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.core.IBiomeDetector;
import hunternif.mc.impl.atlas.ext.ExtTileIdMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_4548;
import net.minecraft.class_5458;

public class BiomeDetectorBase
implements IBiomeDetector {
    private boolean doScanPonds = true;
    private boolean doScanRavines = true;
    private static final class_2960 waterPoolBiome = class_1972.field_9438.method_29177();
    private static final int priorityRavine = 12;
    private static final int priorityWaterPool = 4;
    private static final int prioritylavaPool = 6;
    private static final int ravineMinDepth = 7;
    private static final Set<class_1959> waterBiomes = new HashSet<class_1959>();
    private static final Set<class_1959> beachBiomes = new HashSet<class_1959>();
    private static final Set<class_2960> swampBiomes = new HashSet<class_2960>();

    public static void scanBiomeTypes() {
        for (class_1959 biome : class_5458.field_25933) {
            switch (biome.method_8688()) {
                case field_9363: {
                    beachBiomes.add(biome);
                    break;
                }
                case field_9369: 
                case field_9367: {
                    waterBiomes.add(biome);
                    break;
                }
                case field_9364: {
                    swampBiomes.add(class_5458.field_25933.method_10221((Object)biome));
                }
            }
        }
    }

    public void setScanPonds(boolean value) {
        this.doScanPonds = value;
    }

    public void setScanRavines(boolean value) {
        this.doScanRavines = value;
    }

    int priorityForBiome(class_1959 biome) {
        if (waterBiomes.contains(biome)) {
            return 4;
        }
        if (beachBiomes.contains(biome)) {
            return 3;
        }
        return 1;
    }

    protected static class_2960 getBiomeIdentifier(class_1937 world, class_1959 biome) {
        return world.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome);
    }

    protected static void updateOccurrencesMap(Map<class_2960, Integer> map, class_2960 biome, int weight) {
        int occurrence = map.getOrDefault(biome, 0) + weight;
        map.put(biome, occurrence);
    }

    protected static void updateOccurrencesMap(Map<class_2960, Integer> map, class_1937 world, class_1959 biome, int weight) {
        class_2960 id = BiomeDetectorBase.getBiomeIdentifier(world, biome);
        int occurrence = map.getOrDefault(id, 0) + weight;
        map.put(id, occurrence);
    }

    @Override
    public class_2960 getBiomeID(class_1937 world, class_2791 chunk) {
        class_4548 chunkBiomes = chunk.method_12036();
        HashMap<class_2960, Integer> biomeOccurrences = new HashMap<class_2960, Integer>(class_5458.field_25933.method_10235().size());
        if (chunkBiomes == null) {
            return null;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height;
                int y;
                class_1959 biome = chunkBiomes.method_16359(x, 0, z);
                if (this.doScanPonds && (y = chunk.method_12032(class_2902.class_2903.field_13197).method_12603(x, z)) > 0) {
                    class_2248 topBlock = chunk.method_8320(new class_2338(x, y - 1, z)).method_26204();
                    if (topBlock == class_2246.field_10382) {
                        if (swampBiomes.contains(BiomeDetectorBase.getBiomeIdentifier(world, biome))) {
                            BiomeDetectorBase.updateOccurrencesMap(biomeOccurrences, ExtTileIdMap.SWAMP_WATER, 4);
                        } else {
                            BiomeDetectorBase.updateOccurrencesMap(biomeOccurrences, waterPoolBiome, 4);
                        }
                    } else if (topBlock == class_2246.field_10164) {
                        BiomeDetectorBase.updateOccurrencesMap(biomeOccurrences, ExtTileIdMap.TILE_LAVA, 6);
                    }
                }
                if (this.doScanRavines && (height = chunk.method_12032(class_2902.class_2903.field_13197).method_12603(x, z)) > 0 && height < world.method_8615() - 7) {
                    BiomeDetectorBase.updateOccurrencesMap(biomeOccurrences, ExtTileIdMap.TILE_RAVINE, 12);
                }
                BiomeDetectorBase.updateOccurrencesMap(biomeOccurrences, world, biome, this.priorityForBiome(biome));
            }
        }
        if (biomeOccurrences.isEmpty()) {
            return null;
        }
        Map.Entry meanBiome = Collections.max(biomeOccurrences.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
        return (class_2960)meanBiome.getKey();
    }
}

